/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.decorator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.team.core.RepositoryProvider;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;

public class CapellaScmLabelDecorator
implements ILightweightLabelDecorator {
    public static final String ID = "org.polarsys.capella.common.menu.dynamic.CapellaScmDecorator";

    public void decorate(Object element, IDecoration decoration) {
        DRepresentation representation;
        if (element instanceof NamedElement) {
            this.handleNamedElement(decoration, (NamedElement)element);
        } else if (element instanceof DRepresentation) {
            this.handleRespresentation(decoration, (DRepresentation)element);
        } else if (element instanceof DRepresentationDescriptor && (representation = ((DRepresentationDescriptor)element).getRepresentation()) != null) {
            this.handleRespresentation(decoration, representation);
        }
    }

    protected void handleRespresentation(IDecoration decoration, DRepresentation element) {
        this.addScmOverlay(decoration, (EObject)element);
    }

    protected void handleNamedElement(IDecoration decoration, NamedElement element) {
        boolean addOverlay = false;
        if (element instanceof Project) {
            addOverlay = true;
        } else {
            try {
                addOverlay = AdapterFactoryEditingDomain.isControlled((Object)element);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (addOverlay) {
            this.addScmOverlay(decoration, (EObject)element);
        }
    }

    protected void addScmOverlay(IDecoration decoration, EObject element) {
        RepositoryProvider scmProvider;
        Resource resource = element.eResource();
        IFile file = EcoreUtil2.getFile((Resource)resource);
        if (file != null && (scmProvider = RepositoryProvider.getProvider((IProject)file.getProject())) != null) {
            boolean isReadOnly = EcoreUtil2.isReadOnly((Resource)resource);
            ImageDescriptor imageDescriptor = null;
            imageDescriptor = isReadOnly ? CapellaNavigatorPlugin.getDefault().getImageDescriptor("ovr/version_controlled.gif") : CapellaNavigatorPlugin.getDefault().getImageDescriptor("ovr/co.gif");
            decoration.addOverlay(imageDescriptor);
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

