/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.handlers;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.platform.sirius.ui.navigator.handlers.AbstractDiagramCommandHandler;
import org.polarsys.capella.core.platform.sirius.ui.navigator.handlers.Messages;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class FixDiagramFiltersHandler
extends AbstractDiagramCommandHandler {
    public Object execute(ExecutionEvent event_p) throws ExecutionException {
        if (!MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.FixFiltersAction_1, (String)Messages.FixFiltersAction_2)) {
            return null;
        }
        IStructuredSelection selection = this.getSelection();
        for (Object file : selection) {
            if (!(file instanceof IFile)) continue;
            IFile resource = (IFile)file;
            Session session = SessionHelper.getSession((IFile)resource);
            FixDiagramsJob job = new FixDiagramsJob("Fix filters on aird", resource.getName(), session, Display.getDefault());
            job.setUser(true);
            job.schedule();
        }
        return null;
    }

    protected class ClosingDiagramJob
    extends WorkspaceJob {
        private Display _display;
        private IEditorPart editor;

        public ClosingDiagramJob(String name, IEditorPart editor_p, Display display_p) {
            super(name);
            this.editor = editor_p;
            this._display = display_p;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            this._display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchPartSite site;
                    if (ClosingDiagramJob.this.editor != null && (site = ClosingDiagramJob.this.editor.getSite()) != null && (page = site.getPage()) != null) {
                        page.closeEditor(ClosingDiagramJob.this.editor, false);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }

    public class FixDiagramsJob
    extends WorkspaceJob {
        private Session _session;
        private String _resName;
        private Display _display;

        public FixDiagramsJob(String name, String resName_p, Session session_p, Display display_p) {
            super(name);
            this._session = session_p;
            this._resName = resName_p;
            this._display = display_p;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor_p) throws CoreException {
            monitor_p.beginTask(this.getName(), -1);
            if (this._session != null) {
                Collection representations = DialectManager.INSTANCE.getAllRepresentations(this._session);
                monitor_p.beginTask(String.valueOf(Messages.FixFiltersAction_5) + this._resName, representations.size());
                for (DRepresentation dRepresentation : representations) {
                    monitor_p.setTaskName(String.valueOf(Messages.FixFiltersAction_6) + dRepresentation.getName() + Messages.FixFiltersAction_7);
                    OpeningDiagramJob job_opening = new OpeningDiagramJob("Opening diagram", this._session, dRepresentation);
                    job_opening.setUser(false);
                    job_opening.schedule();
                    try {
                        job_opening.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (job_opening.getResult().isOK()) {
                        ClosingDiagramJob job_closing = new ClosingDiagramJob("Closing diagram", job_opening.getCurrentEditor(), this._display);
                        job_closing.setUser(false);
                        job_closing.schedule();
                        try {
                            job_closing.join();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    monitor_p.worked(1);
                    if (monitor_p.isCanceled()) break;
                }
            }
            monitor_p.setTaskName(String.valueOf(Messages.FixFiltersAction_8) + this._resName + Messages.FixFiltersAction_9);
            monitor_p.done();
            return Status.OK_STATUS;
        }
    }

    protected class OpeningDiagramJob
    extends WorkspaceJob {
        private Session _session;
        private DRepresentation _dRepresentation;
        private IEditorPart currentEditor;

        public OpeningDiagramJob(String name, Session session_p, DRepresentation dRepresentation_p) {
            super(name);
            this._session = session_p;
            this._dRepresentation = dRepresentation_p;
            this.currentEditor = null;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            if (this._session != null && this._dRepresentation != null) {
                this.currentEditor = DialectUIManager.INSTANCE.openEditor(this._session, this._dRepresentation, monitor);
            }
            return Status.OK_STATUS;
        }

        public IEditorPart getCurrentEditor() {
            return this.currentEditor;
        }
    }
}

