/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.platform.sirius.ui.navigator.handlers.AbstractDiagramCommandHandler;
import org.polarsys.capella.core.platform.sirius.ui.navigator.handlers.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.refresh.SpecificRefreshCommand;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class RefreshDiagramsCommandHandler
extends AbstractDiagramCommandHandler {
    protected boolean confirm(ExecutionEvent event_p) {
        return MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.RefreshDiagramsCommandHandler_ConfirmRefreshDialog_Title, (String)Messages.RefreshDiagramsCommandHandler_ConfirmRefreshDialog_Text);
    }

    public Object execute(ExecutionEvent event_p) throws ExecutionException {
        Object selectedElement = this.getSelection().getFirstElement();
        Session session = this.getSession(selectedElement);
        List<DRepresentation> representationsToRefresh = Collections.emptyList();
        if (selectedElement instanceof ModelElement) {
            representationsToRefresh = new ArrayList();
            Collection allSessionRepresentations = DialectManager.INSTANCE.getAllRepresentations(session);
            for (DRepresentation representation : allSessionRepresentations) {
                EObject associatedModelElement;
                if (!(representation instanceof DSemanticDecorator) || !EcoreUtil.isAncestor((EObject)((ModelElement)selectedElement), (EObject)(associatedModelElement = ((DSemanticDecorator)representation).getTarget()))) continue;
                representationsToRefresh.add(representation);
            }
        } else if (selectedElement instanceof IFile) {
            representationsToRefresh = DialectManager.INSTANCE.getAllRepresentations(session);
        }
        if (representationsToRefresh.isEmpty()) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.RefreshDiagramsCommandHandler_NoDiagramDialog_Title, (String)Messages.RefreshDiagramsCommandHandler_NoDiagramDialog_Text);
            return null;
        }
        boolean refreshConfirmed = this.confirm(event_p);
        if (!refreshConfirmed) {
            return null;
        }
        String selectedElementName = "";
        selectedElementName = selectedElement instanceof IFile ? ((IFile)selectedElement).getName() : (selectedElement instanceof NamedElement ? ((NamedElement)selectedElement).getName() : selectedElement.toString());
        RefreshDiagramsJob job = new RefreshDiagramsJob(selectedElementName, session, representationsToRefresh, Display.getCurrent());
        job.setThread(Display.getDefault().getThread());
        job.setUser(true);
        job.schedule();
        return null;
    }

    protected Session getSession(Object object_p) {
        Session session = null;
        if (object_p instanceof IFile) {
            session = SessionHelper.getSessionForDiagramFile((IFile)((IFile)object_p));
        } else if (object_p instanceof ModelElement) {
            session = SessionManager.INSTANCE.getSession((EObject)((ModelElement)object_p));
        }
        return session;
    }

    @Override
    public boolean isEnabled() {
        IStructuredSelection currentSelection = this.getSelection();
        if (currentSelection.isEmpty()) {
            return false;
        }
        Object selectedElement = currentSelection.getFirstElement();
        Session selectedElementSession = this.getSession(selectedElement);
        return selectedElementSession != null;
    }

    public class RefreshDiagramsJob
    extends WorkspaceJob {
        private String _baseElementName;
        private Display _display;
        private Collection<DRepresentation> _representationsToRefresh;
        private Session _session;

        public RefreshDiagramsJob(String baseElementName_p, Session session_p, Collection<DRepresentation> representationsToRefresh_p, Display display_p) {
            super(Messages.RefreshDiagramsCommandHandler_JobName);
            this._baseElementName = baseElementName_p;
            this._session = session_p;
            this._representationsToRefresh = representationsToRefresh_p;
            this._display = display_p;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor_p) throws CoreException {
            Logger logger = ReportManagerRegistry.getInstance().subscribe("Model Management");
            monitor_p.beginTask(this.getName(), -1);
            logger.info((Object)("Starting refresh of diagrams below " + this._baseElementName));
            Collection<DRepresentation> modifiedRepresentations = SpecificRefreshCommand.refreshRepresentations(this._session, this._representationsToRefresh, monitor_p, this._display);
            for (DRepresentation dRepresentation : modifiedRepresentations) {
                logger.info((Object)("Diagram " + dRepresentation.getName() + " refreshed."));
            }
            logger.info((Object)("Refresh of diagrams below " + this._baseElementName + " done."));
            monitor_p.done();
            return Status.OK_STATUS;
        }
    }
}

