/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.view;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorSaveablesService;
import org.eclipse.ui.navigator.SaveablesProvider;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.FilteredTree;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.PatternFilter;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.StringMatcherFactory;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.TreePatternFilter;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SelectionHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.MoveDownAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.MoveUpAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.ActiveSessionManager;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.CapellaNavigatorContentProvider;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.ICommandStackSelectionProvider;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.NavigatorEditingDomainDispatcher;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.NavigatorSessionManagerListener;
import org.polarsys.capella.core.preferences.Activator;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.ui.properties.CapellaTabbedPropertySheetPage;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;

public class CapellaCommonNavigator
extends CommonNavigator
implements IEditingDomainProvider,
ITabbedPropertySheetPageContributor,
ICommandStackSelectionProvider,
IPropertyChangeListener {
    public static final String ID = "capella.project.explorer";
    private static final String TAG_MEMENTO = "memento";
    private CapellaFilteredTree _filteredTree;
    private MoveDownAction _moveDown;
    private MoveUpAction _moveUp;
    private NavigatorSessionManagerListener _sessionManagerListener;
    private CapellaNavigatorPatternFilter patternFilter;
    private TabbedPropertySheetPage propertySheetPage;
    private IDialogSettings _viewSettings = this.getDialogSettingsSection();
    private CapellaNavigatorContentProvider _contentProvider;

    protected void contributeToolbarActions() {
        IViewSite site = this.getViewSite();
        IToolBarManager toolBarManager = site.getActionBars().getToolBarManager();
        IContributionItem[] items = toolBarManager.getItems();
        toolBarManager.removeAll();
        this._moveUp = new MoveUpAction();
        toolBarManager.add((IAction)this._moveUp);
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._moveUp, site.getSelectionProvider());
        this._moveDown = new MoveDownAction();
        toolBarManager.add((IAction)this._moveDown);
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._moveDown, site.getSelectionProvider());
        toolBarManager.add((IContributionItem)new Separator());
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contributionItem = iContributionItemArray[n2];
            toolBarManager.add(contributionItem);
            ++n2;
        }
        IStructuredSelection selection = (IStructuredSelection)site.getSelectionProvider().getSelection();
        this._moveUp.selectionChanged(selection);
        this._moveDown.selectionChanged(selection);
    }

    protected CommonViewer createCommonViewer(Composite parent) {
        this.patternFilter = new CapellaNavigatorPatternFilter();
        this.patternFilter.setStringMatcherFactory(new StringMatcherFactory(){

            public StringMatcher createStringMatcher(String pattern) {
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                return new StringMatcher(pattern, store.getBoolean("preference.ignoreCase"), false);
            }
        });
        this._filteredTree = new CapellaFilteredTree(parent, 770, (PatternFilter)this.patternFilter);
        final CapellaCommonViewer commonViewer = (CapellaCommonViewer)this._filteredTree.getViewer();
        this.initListeners((TreeViewer)commonViewer);
        commonViewer.getNavigatorContentService().restoreState(this.memento);
        SiriusTransPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String propertyName = event.getProperty();
                if ("GROUP_ENABLE".equals(propertyName) || "GROUP_TRIGGER".equals(propertyName) || "GROUP_SIZE".equals(propertyName)) {
                    commonViewer.refresh();
                }
            }
        });
        return commonViewer;
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        super.createPartControl(composite);
        CapellaCommonViewer commonViewer = this.getCommonViewer();
        commonViewer.getControl().setLayoutData((Object)new GridData(1808));
        if (this._sessionManagerListener == null) {
            this._sessionManagerListener = new NavigatorSessionManagerListener(this);
        }
        this.contributeToolbarActions();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        Activator.getDefault().addProjectsPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("preference.show.capella.project.concept".equals(property) || "preference.show.part.explicit".equals(property)) {
            for (Session session : SessionManager.INSTANCE.getSessions()) {
                if (!PreferencesHelper.isNonReferencesCapellaProject((Object)event.getSource(), (Project)SessionHelper.getCapellaProject((Session)session), (Session)session) || this._sessionManagerListener == null) continue;
                this._sessionManagerListener.notifyUpdatedSession(session);
            }
        }
    }

    public void enableContentNotifications() {
        CapellaNavigatorContentProvider contentProvider = this.getContentProvider();
        if (contentProvider == null) {
            return;
        }
        ActiveSessionManager.getInstance().enableContentNotifications();
    }

    public void disableContentNotifications() {
        CapellaNavigatorContentProvider contentProvider = this.getContentProvider();
        if (contentProvider == null) {
            return;
        }
        ActiveSessionManager.getInstance().disableContentNotifications();
    }

    public void enableContentNotifications(SemanticEditingDomainFactory.SemanticEditingDomain editingDomain) {
        CapellaNavigatorContentProvider contentProvider = this.getContentProvider();
        if (contentProvider == null) {
            return;
        }
        ActiveSessionManager.getInstance().enableContentNotifications(editingDomain);
    }

    public void disableContentNotifications(SemanticEditingDomainFactory.SemanticEditingDomain editingDomain) {
        CapellaNavigatorContentProvider contentProvider = this.getContentProvider();
        if (contentProvider == null) {
            return;
        }
        ActiveSessionManager.getInstance().disableContentNotifications(editingDomain);
    }

    public void dispose() {
        ISelectionProvider selectionProvider = this.getViewSite().getSelectionProvider();
        if (this._moveUp != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._moveUp);
            this._moveUp = null;
        }
        if (this._moveDown != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._moveDown);
            this._moveDown = null;
        }
        if (this._sessionManagerListener != null) {
            this._sessionManagerListener.dispose();
            this._sessionManagerListener = null;
        }
        NavigatorEditingDomainDispatcher.unregisterCommandStackSelectionProvider(this);
        CapellaNavigatorPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.saveViewSettings();
        super.dispose();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IPropertySheetPage.class.equals(adapter)) {
            return (T)this.getPropertySheetPage();
        }
        return (T)super.getAdapter(adapter);
    }

    public CapellaCommonViewer getCommonViewer() {
        return (CapellaCommonViewer)super.getCommonViewer();
    }

    public CapellaNavigatorContentProvider getContentProvider() {
        if (this._contentProvider != null && this._contentProvider.getSessionContentProvider() != null) {
            return this._contentProvider;
        }
        INavigatorContentService navigatorContentService = this.getCommonViewer().getNavigatorContentService();
        INavigatorContentExtension contentExt = navigatorContentService.getContentExtensionById("capella.project.explorer.content");
        ITreeContentProvider contentProvider = contentExt.getContentProvider();
        this._contentProvider = contentProvider instanceof CapellaNavigatorContentProvider ? (CapellaNavigatorContentProvider)contentProvider : null;
        return this._contentProvider;
    }

    public String getContributorId() {
        return "org.polarsys.capella.core.data.capellamodeller.properties";
    }

    private IDialogSettings getDialogSettingsSection() {
        String sectionName;
        IDialogSettings dialogSettings = CapellaNavigatorPlugin.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(sectionName = this.getClass().getName());
        if (section == null) {
            section = dialogSettings.addNewSection(sectionName);
        }
        return section;
    }

    protected CapellaNavigatorPatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    private IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new CapellaTabbedPropertySheetPage(this){

                public void dispose() {
                    super.dispose();
                    CapellaCommonNavigator.this.propertySheetPage = null;
                }

                public void init(IPageSite pageSite) {
                    super.init(pageSite);
                    pageSite.setSelectionProvider((ISelectionProvider)CapellaCommonNavigator.this.getCommonViewer());
                }
            };
        }
        return this.propertySheetPage;
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        super.handleDoubleClick(event);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = selection.getFirstElement();
        if (CapellaResourceHelper.isSemanticElement((Object)element)) {
            CapellaUIPropertiesPlugin.getDefault().openWizard(event, (EObject)element);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        memento = this.restoreViewSettings(memento);
        super.init(site, memento);
    }

    private IMemento restoreViewSettings(IMemento memento) {
        String persistedMemento;
        IMemento memento_l = memento;
        if (memento_l == null && (persistedMemento = this._viewSettings.get(TAG_MEMENTO)) != null) {
            try {
                memento_l = XMLMemento.createReadRoot((Reader)new StringReader(persistedMemento));
            }
            catch (WorkbenchException workbenchException) {
                // empty catch block
            }
        }
        return memento_l;
    }

    private void saveViewSettings() {
        String rootName = this.getClass().getSimpleName();
        XMLMemento memento_l = XMLMemento.createWriteRoot((String)rootName);
        this.saveState((IMemento)memento_l);
        StringWriter writer = new StringWriter();
        try {
            memento_l.save((Writer)writer);
            this._viewSettings.put(TAG_MEMENTO, writer.getBuffer().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Saveable[] getActiveSaveables() {
        INavigatorSaveablesService navigatorSaveablesService = this.getCommonViewer().getNavigatorContentService().getSaveablesService();
        return navigatorSaveablesService.getActiveSaveables();
    }

    public Saveable[] getSaveables() {
        SaveablesProvider saveablesProvider = (SaveablesProvider)this.getContentProvider().getAdapter(SaveablesProvider.class);
        return saveablesProvider.getSaveables();
    }

    @Override
    public void commandStackSelectionChanged(ISelection selection) {
        boolean enabled = true;
        if (selection instanceof IStructuredSelection) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)((IStructuredSelection)selection).getFirstElement());
            enabled = ActiveSessionManager.getInstance().isEnabledContentNotifications(domain);
        }
        if (enabled) {
            this.selectReveal(selection);
        }
    }

    public EditingDomain getEditingDomain() {
        ISelection selection = this.getCommonViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            ArrayList<EObject> selectedElements = new ArrayList<EObject>();
            for (Object element : (IStructuredSelection)selection) {
                if (!(element instanceof EObject)) continue;
                selectedElements.add((EObject)element);
            }
            return TransactionHelper.getEditingDomain(selectedElements);
        }
        return null;
    }

    public class CapellaCommonViewer
    extends CommonViewer {
        @Deprecated
        protected volatile boolean _isRefreshEnabled;

        public CapellaCommonViewer(String aViewerId, Composite aParent, int aStyle) {
            super(aViewerId, aParent, aStyle);
            this._isRefreshEnabled = true;
            NavigatorEditingDomainDispatcher.registerCommandStackSelectionProvider(CapellaCommonNavigator.this);
        }

        public void add(Object parentElementOrTreePath, Object childElement) {
            CapellaCommonNavigator.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElement);
        }

        public void add(Object parentElementOrTreePath, Object[] childElements) {
            CapellaCommonNavigator.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElements);
        }

        public ISelection getSelection() {
            try {
                return super.getSelection();
            }
            catch (Exception e) {
                return StructuredSelection.EMPTY;
            }
        }

        protected void inputChanged(Object input, Object oldInput) {
            CapellaCommonNavigator.this.getPatternFilter().clearCaches();
            super.inputChanged(input, oldInput);
        }

        public void insert(Object parentElementOrTreePath, Object element, int position) {
            CapellaCommonNavigator.this.getPatternFilter().clearCaches();
            super.insert(parentElementOrTreePath, element, position);
        }

        public void refresh(Object element, boolean updateLabels) {
            CapellaCommonNavigator.this.getPatternFilter().clearCaches();
            super.refresh(element, updateLabels);
        }

        public void remove(Object elementsOrTreePaths) {
            CapellaCommonNavigator.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void remove(Object parent, Object[] elements) {
            CapellaCommonNavigator.this.getPatternFilter().clearCaches();
            super.remove(parent, elements);
        }

        public void remove(Object[] elementsOrTreePaths) {
            CapellaCommonNavigator.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void replace(Object parentElementOrTreePath, int index, Object element) {
            CapellaCommonNavigator.this.getPatternFilter().clearCaches();
            super.replace(parentElementOrTreePath, index, element);
        }

        public void setFilters(ViewerFilter ... filters) {
            super.setFilters(filters);
            this.addFilter((ViewerFilter)CapellaCommonNavigator.this.getPatternFilter());
        }

        public void resetFilters() {
            super.resetFilters();
            this.addFilter((ViewerFilter)CapellaCommonNavigator.this.getPatternFilter());
        }

        public void setChildCount(Object elementOrTreePath, int count) {
            CapellaCommonNavigator.this.getPatternFilter().clearCaches();
            super.setChildCount(elementOrTreePath, count);
        }

        public void setContentProvider(IContentProvider provider) {
            CapellaCommonNavigator.this.getPatternFilter().clearCaches();
            super.setContentProvider(provider);
        }

        public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
            CapellaCommonNavigator.this.getPatternFilter().clearCaches();
            super.setHasChildren(elementOrTreePath, hasChildren);
        }

        public void update(Object element, String[] properties) {
            super.update(element, properties);
        }
    }

    protected class CapellaFilteredTree
    extends FilteredTree {
        protected CapellaFilteredTree(Composite parent) {
            super(parent);
            this.attachFilterControlFocusListener();
        }

        public CapellaFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter);
            this.attachFilterControlFocusListener();
        }

        protected void clearText() {
            this.getPatternFilter().setSearchInDescription(false);
            super.clearText();
        }

        protected void createClearText(Composite parent) {
            this.filterToolBar = new ToolBarManager(0x800100);
            this.filterToolBar.createControl(parent);
            this.createSearchDescriptionButton(parent);
            super.createClearText(parent);
        }

        protected Composite createFilterControls(Composite parent) {
            GridLayout layout = (GridLayout)parent.getLayout();
            layout.numColumns = 3;
            Composite filterControls = super.createFilterControls(parent);
            return filterControls;
        }

        protected Label createMessageArea(Composite parent) {
            Label messageArea = super.createMessageArea(parent);
            GridData layoutData = (GridData)messageArea.getLayoutData();
            layoutData.horizontalSpan = 3;
            return messageArea;
        }

        private void createSearchDescriptionButton(Composite parent) {
            Action searchInDescriptionAction = new Action("", 1){

                public void run() {
                    CapellaFilteredTree.this.getPatternFilter().setSearchInDescription(true);
                    CapellaFilteredTree.this.textChanged();
                }
            };
            searchInDescriptionAction.setToolTipText(Messages.CapellaCommonNavigator_searchInDescriptionAction_Tooltip);
            searchInDescriptionAction.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("search.gif"));
            this.filterToolBar.add((IAction)searchInDescriptionAction);
        }

        protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
            return new CapellaCommonViewer(CapellaCommonNavigator.this.getViewSite().getId(), parent, style);
        }

        protected int getExpansionLevelWhenNoFilter() {
            return 4;
        }

        public CapellaNavigatorPatternFilter getPatternFilter() {
            return (CapellaNavigatorPatternFilter)super.getPatternFilter();
        }

        protected void handleCRKeyStoke() {
            this.getPatternFilter().setSearchInDescription(false);
            super.handleCRKeyStoke();
        }

        protected void init(int treeStyle, PatternFilter filter) {
            this.setAutoFiltering(false);
            super.init(treeStyle, filter);
        }

        protected void updateToolbar(boolean visible) {
            IContributionItem[] items = this.filterToolBar.getItems();
            items[this.hasNativeClearButton() ? 0 : 1].setVisible(visible);
            this.filterToolBar.update(true);
        }

        private void attachFilterControlFocusListener() {
            this.getFilterControl().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    IActionBars ab = CapellaCommonNavigator.this.getViewSite().getActionBars();
                    ab.setGlobalActionHandler(ActionFactory.CUT.getId(), null);
                    ab.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
                    ab.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
                }
            });
        }
    }

    protected class CapellaNavigatorPatternFilter
    extends TreePatternFilter {
        private boolean _searchInDescription;

        protected CapellaNavigatorPatternFilter() {
        }

        protected String getTextFromModelElement(EObject element) {
            String result = null;
            if (this._searchInDescription) {
                if (element instanceof CapellaElement) {
                    result = ((CapellaElement)element).getDescription();
                } else if (element instanceof DSemanticDiagram) {
                    result = ((DSemanticDiagram)element).getDocumentation();
                }
            } else {
                result = super.getTextFromModelElement(element);
            }
            return result == null ? "" : result;
        }

        public boolean isElementVisible(Viewer viewer, Object parentElement, Object element) {
            if (this._searchInDescription) {
                return this.isLeafMatch(viewer, parentElement, element) || this.isParentMatch(viewer, parentElement, element);
            }
            boolean visible = super.isElementVisible(viewer, parentElement, element);
            return visible;
        }

        protected boolean isLeafMatch(Viewer viewer, Object parentElement, Object element) {
            if (this._searchInDescription) {
                return this.doIsLeafMatch(viewer, parentElement, element);
            }
            return super.isLeafMatch(viewer, parentElement, element);
        }

        protected boolean isParentMatch(Viewer viewer, Object parentElement, Object element) {
            CapellaNavigatorContentProvider iTreeContentProvider = CapellaCommonNavigator.this.getContentProvider();
            Object[] children = iTreeContentProvider.getChildren(element);
            if (children != null && children.length > 0) {
                return this.isAnyVisible(viewer, element, children);
            }
            return false;
        }

        protected boolean isSearchingInDescription() {
            return this._searchInDescription;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this._searchInDescription) {
                return this.isElementVisible(viewer, parentElement, element);
            }
            return super.select(viewer, parentElement, element);
        }

        protected void setSearchInDescription(boolean searchInDescription) {
            this._searchInDescription = searchInDescription;
        }
    }
}

