/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.viewer;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.common.ui.services.helper.ViewerHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.ActiveSessionManager;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class NavigatorSessionManagerListener
extends SessionManagerListener.Stub {
    private CapellaCommonNavigator _capellaCommonNavigator;

    public NavigatorSessionManagerListener(CapellaCommonNavigator capellaCommonNavigator) {
        this._capellaCommonNavigator = capellaCommonNavigator;
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)this);
        Collection activeSessions = SessionManager.INSTANCE.getSessions();
        for (Session activeSession : activeSessions) {
            this.notify(activeSession, 7);
        }
    }

    public void dispose() {
        SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)this);
        this._capellaCommonNavigator = null;
    }

    public void notifyRemoveSession(Session removedSession) {
        if (SessionManager.INSTANCE.getSessions().isEmpty()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CapellaCommonNavigator.CapellaCommonViewer viewer = NavigatorSessionManagerListener.this._capellaCommonNavigator.getCommonViewer();
                    if (viewer != null && !viewer.getControl().isDisposed()) {
                        viewer.getNavigatorContentService().getActivationService().deactivateExtensions(new String[]{"capella.project.explorer.content"}, true);
                        viewer.getNavigatorContentService().getActivationService().activateExtensions(new String[]{"capella.project.explorer.content"}, false);
                    }
                }
            });
        }
    }

    protected void refreshViewer(Session updatedSession) {
        if (this._capellaCommonNavigator == null) {
            return;
        }
        CapellaCommonNavigator.CapellaCommonViewer viewer = this._capellaCommonNavigator.getCommonViewer();
        if (viewer != null && !viewer.getControl().isDisposed() && !viewer.isBusy() && updatedSession.isOpen() && ActiveSessionManager.getInstance().isEnabledContentNotifications(updatedSession.getTransactionalEditingDomain())) {
            this.refreshItem(updatedSession, true);
        }
    }

    @Deprecated
    protected void refreshItem(Session updatedSession) {
        this.refreshItem(updatedSession, false);
    }

    protected void refreshItem(Session updatedSession, boolean contentRefresh) {
        if (!updatedSession.isOpen()) {
            return;
        }
        boolean triggerRefresh = ((TransactionalEditingDomainImpl)updatedSession.getTransactionalEditingDomain()).getActiveTransaction() == null;
        this.refreshItem(updatedSession, contentRefresh, triggerRefresh);
    }

    protected void refreshItem(Session updatedSession, boolean contentRefresh, boolean triggerRefresh) {
        final IFile file = EcoreUtil2.getFile((Resource)updatedSession.getSessionResource());
        NotificationImpl notification = new NotificationImpl(1, null, file){

            public Object getNotifier() {
                return file;
            }
        };
        if (this._capellaCommonNavigator != null) {
            this._capellaCommonNavigator.getContentProvider().notifyChanged((Notification)new ViewerNotification((Notification)notification, (Object)file, contentRefresh, true));
            if (triggerRefresh) {
                this._capellaCommonNavigator.getContentProvider().runRefresh();
            }
        }
    }

    protected void handleClosed(Session updatedSession) {
        CapellaCommonNavigator.CapellaCommonViewer viewer = this._capellaCommonNavigator.getCommonViewer();
        if (viewer != null && !viewer.getControl().isDisposed()) {
            viewer.setSelection((ISelection)StructuredSelection.EMPTY);
            ViewerHelper.refresh((StructuredViewer)viewer);
        }
    }

    protected void handleOpened(Session updatedSession) {
        final CapellaCommonNavigator.CapellaCommonViewer viewer = this._capellaCommonNavigator.getCommonViewer();
        if (viewer != null && !viewer.getControl().isDisposed() && ActiveSessionManager.getInstance().isEnabledContentNotifications(updatedSession.getTransactionalEditingDomain())) {
            Iterator iterator;
            final IFile parent = SessionHelper.getFirstAnalysisFile((DAnalysisSession)((DAnalysisSession)updatedSession));
            ViewerHelper.refresh((StructuredViewer)viewer, (Object)parent);
            if (parent != null && !viewer.getExpandedState(parent)) {
                ViewerHelper.run((StructuredViewer)viewer, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        viewer.expandToLevel((Object)parent, 1);
                    }
                });
            }
            if ((iterator = updatedSession.getSemanticResources().iterator()).hasNext()) {
                Project root;
                EList modelRoots;
                Resource semanticResource = (Resource)iterator.next();
                EObject rootObject = (EObject)semanticResource.getContents().get(0);
                final Object[] expandedObject = new Object[]{rootObject};
                if (rootObject instanceof Project && !(modelRoots = (root = (Project)rootObject).getOwnedModelRoots()).isEmpty()) {
                    expandedObject[0] = modelRoots.get(0);
                }
                ViewerHelper.run((StructuredViewer)viewer, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        viewer.expandToLevel(expandedObject[0], 1);
                    }
                });
            }
        }
    }

    public void notify(final Session updatedSession, int notification) {
        final SemanticEditingDomainFactory.SemanticEditingDomain domain = (SemanticEditingDomainFactory.SemanticEditingDomain)updatedSession.getTransactionalEditingDomain();
        switch (notification) {
            case 6: 
            case 8: {
                this._capellaCommonNavigator.disableContentNotifications(domain);
                break;
            }
            case 7: {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NavigatorSessionManagerListener.this._capellaCommonNavigator.enableContentNotifications(domain);
                        NavigatorSessionManagerListener.this.handleOpened(updatedSession);
                    }
                });
                break;
            }
            case 3: {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NavigatorSessionManagerListener.this.refreshViewer(updatedSession);
                    }
                });
                break;
            }
            case 2: {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NavigatorSessionManagerListener.this.refreshItem(updatedSession, false);
                    }
                });
                break;
            }
            case 4: {
                this._capellaCommonNavigator.disableContentNotifications(domain);
                break;
            }
            case 5: {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NavigatorSessionManagerListener.this._capellaCommonNavigator.enableContentNotifications(domain);
                        NavigatorSessionManagerListener.this.refreshViewer(updatedSession);
                    }
                });
                break;
            }
            case 10: {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NavigatorSessionManagerListener.this.refreshViewer(updatedSession);
                    }
                });
                break;
            }
            case 11: {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NavigatorSessionManagerListener.this.refreshViewer(updatedSession);
                    }
                });
                break;
            }
            case 9: {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NavigatorSessionManagerListener.this._capellaCommonNavigator.enableContentNotifications(domain);
                        ActiveSessionManager.getInstance().remove((TransactionalEditingDomain)domain);
                        NavigatorSessionManagerListener.this.handleClosed(updatedSession);
                    }
                });
            }
        }
    }

    public void notifyUpdatedSession(Session updatedSession) {
        this.fakeRepresentationChange(updatedSession);
    }

    public void viewpointDeselected(Viewpoint deselectedViewpoint) {
        this.doUpdateViewpoint();
    }

    public void viewpointSelected(Viewpoint selectedViewpoint) {
        this.doUpdateViewpoint();
    }

    protected void doUpdateViewpoint() {
        final CapellaCommonNavigator.CapellaCommonViewer viewer = this._capellaCommonNavigator.getCommonViewer();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ISelection selection = viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                    Session session = null;
                    if (firstElement instanceof Session) {
                        session = (Session)firstElement;
                    } else if (firstElement instanceof EObject) {
                        session = SessionManager.INSTANCE.getSession((EObject)firstElement);
                    }
                    if (session != null) {
                        NavigatorSessionManagerListener.this.fakeRepresentationChange(session);
                    }
                }
            }
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Control control = viewer.getControl();
            if (!control.isDisposed()) {
                control.getDisplay().asyncExec(runnable);
            }
        }
    }

    private void fakeRepresentationChange(Session session) {
        if (session == null) {
            return;
        }
        this.notify(session, 10);
    }
}

