/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.perspective;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.BasicSplashHandler;

public class CapellaSplashHandler
extends BasicSplashHandler {
    public void init(Shell splash) {
        String version;
        String buildId;
        block19: {
            int foregroundColorInteger;
            super.init(splash);
            String progressRectString = null;
            String messageRectString = null;
            String foregroundColorString = null;
            IProduct product = Platform.getProduct();
            if (product != null) {
                progressRectString = product.getProperty("startupProgressRect");
                messageRectString = product.getProperty("startupMessageRect");
                foregroundColorString = product.getProperty("startupForegroundColor");
            }
            Rectangle progressRect = StringConverter.asRectangle((String)progressRectString, (Rectangle)new Rectangle(10, 10, 300, 15));
            this.setProgressRect(progressRect);
            Rectangle messageRect = StringConverter.asRectangle((String)messageRectString, (Rectangle)new Rectangle(10, 35, 300, 15));
            this.setMessageRect(messageRect);
            try {
                foregroundColorInteger = Integer.parseInt(foregroundColorString, 16);
            }
            catch (Exception ex) {
                foregroundColorInteger = 13817855;
            }
            this.setForeground(new RGB((foregroundColorInteger & 0xFF0000) >> 16, (foregroundColorInteger & 0xFF00) >> 8, foregroundColorInteger & 0xFF));
            buildId = "Unknown";
            version = "Unknown";
            BufferedReader bufferedReader = null;
            try {
                try {
                    InputStream inputStream = product.getDefiningBundle().getEntry("about.mappings").openConnection().getInputStream();
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    String line = null;
                    while ((line = bufferedReader.readLine()) != null) {
                        if (line.startsWith("0=")) {
                            version = line.substring(2);
                        }
                        if (!line.startsWith("1=")) continue;
                        buildId = line.substring(2);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Version : ");
        builder.append(version);
        builder.append("\n");
        builder.append("Build id : ");
        builder.append(buildId);
        final String text = builder.toString();
        final Point buildIdPoint = new Point(200, 225);
        this.getContent().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(CapellaSplashHandler.this.getForeground());
                FontData[] fontData = e.gc.getFont().getFontData();
                int i = 0;
                while (i < fontData.length) {
                    fontData[i].setHeight(12);
                    ++i;
                }
                Font newFont = new Font((Device)e.display, fontData);
                e.gc.setFont(newFont);
                e.gc.drawText(text, buildIdPoint.x, buildIdPoint.y, true);
            }
        });
    }
}

