/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.DeleteRepresentationCommand;
import org.polarsys.capella.core.sirius.ui.Messages;
import org.polarsys.capella.core.sirius.ui.helper.SiriusItemWrapperHelper;

public class DeleteRepresentationAction
extends BaseSelectionListenerAction {
    public DeleteRepresentationAction() {
        super("Delete");
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        List selectedRepresentations = RepresentationHelper.getRepresentations(SiriusItemWrapperHelper.filterItemWrapper(selection), (boolean)true);
        if (!selectedRepresentations.isEmpty()) {
            TransactionalEditingDomain domain;
            int deletedDiagramCount = selectedRepresentations.size();
            String contextualMessage = null;
            contextualMessage = deletedDiagramCount == 1 ? StringHelper.formatMessage((String)Messages.DeleteRepresentationAction_One_Diagram_Message, (Object[])new String[]{((DRepresentation)selectedRepresentations.get(0)).getName()}) : StringHelper.formatMessage((String)Messages.DeleteRepresentationAction_Multiple_Diagram_Message, (Object[])new String[]{String.valueOf(deletedDiagramCount)});
            if (MessageDialog.openConfirm(null, (String)Messages.DeleteRepresentationAction_Title, (String)(String.valueOf(Messages.DeleteRepresentationAction_Message) + contextualMessage)) && (domain = TransactionHelper.getEditingDomain((Collection)selectedRepresentations)) != null) {
                DeleteRepresentationCommand command = new DeleteRepresentationCommand(domain, (Collection)selectedRepresentations);
                domain.getCommandStack().execute((Command)command);
            }
        }
    }
}

