/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.control.SiriusControlCommand;
import org.eclipse.sirius.business.api.control.SiriusUncontrolCommand;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.ui.tools.api.control.SiriusControlHandler;
import org.eclipse.sirius.ui.tools.api.control.SiriusUncontrolHandler;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.command.AbstractNonDirtyingCommand;
import org.polarsys.capella.common.ef.command.AbstractReadOnlyCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commands.preferences.service.AbstractPreferencesInitializer;
import org.polarsys.capella.core.model.handler.AbortedTransactionException;
import org.polarsys.capella.core.model.handler.helpers.CrossReferencerHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.sirius.ui.actions.ControlAction;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.sirius.ui.internal.ControlResourceDialog;
import org.polarsys.capella.core.sirius.ui.internal.UncontrolMessageDialog;
import org.polarsys.capella.core.sirius.ui.listener.FileModificationPreCommitListener;
import org.polarsys.capella.core.sirius.ui.wizard.SelectRepresentationsWizard;

public class DesignerControlAction
extends ControlAction {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("User Interface");

    protected void doExecuteCommand(final EObject semanticRoot, final Collection<Resource> representationResources, final Command realCommand) {
        final HashMap initialResourceWithStatus = new HashMap(1);
        try {
            TransactionHelper.getExecutionManager((EObject)semanticRoot).execute((ICommand)new AbstractNonDirtyingCommand(){

                private void changeResourceSyncStatus(ResourceSetSync resourceSetSync, Map<Resource, ResourceSetSync.ResourceStatus> resourceWithStatus, Resource handleResource, ResourceSetSync.ResourceStatus handleResourceStatus) {
                    resourceWithStatus.put(handleResource, handleResourceStatus);
                    resourceSetSync.statusChanged(handleResource, handleResourceStatus, ResourceSetSync.ResourceStatus.CHANGED);
                }

                public void commandInterrupted() {
                    this.commandRolledBack();
                }

                public void commandRolledBack() {
                    this.restoreResourceSyncStatus(initialResourceWithStatus, ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)TransactionHelper.getEditingDomain((EObject)semanticRoot)));
                }

                protected void restoreResourceSyncStatus(Map<Resource, ResourceSetSync.ResourceStatus> initialResourceWithStatus2, ResourceSetSync resourceSetSync) {
                    for (Map.Entry<Resource, ResourceSetSync.ResourceStatus> entry : initialResourceWithStatus2.entrySet()) {
                        resourceSetSync.statusChanged(entry.getKey(), ResourceSetSync.ResourceStatus.CHANGED, entry.getValue());
                    }
                }

                public void run() {
                    ResourceSetSync resourceSetSync = ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)TransactionHelper.getEditingDomain((EObject)semanticRoot));
                    this.changeResourceSyncStatus(resourceSetSync, initialResourceWithStatus, semanticRoot.eResource(), ResourceSetSync.getStatus((Resource)semanticRoot.eResource()));
                    for (Resource representationResource : representationResources) {
                        this.changeResourceSyncStatus(resourceSetSync, initialResourceWithStatus, representationResource, ResourceSetSync.getStatus((Resource)representationResource));
                    }
                    try {
                        ArrayList<IFile> filesToMakeWritable = new ArrayList<IFile>(initialResourceWithStatus.keySet().size());
                        for (Resource currentResource : initialResourceWithStatus.keySet()) {
                            filesToMakeWritable.add(EcoreUtil2.getFile((Resource)currentResource));
                        }
                        FileModificationPreCommitListener.makeFilesWritable(TransactionHelper.getEditingDomain((EObject)semanticRoot), filesToMakeWritable);
                        realCommand.execute();
                    }
                    catch (AbortedTransactionException exception) {
                        this.commandRolledBack();
                    }
                }
            });
        }
        finally {
            initialResourceWithStatus.clear();
        }
    }

    protected void fragment(Shell shell_) {
        CapellaSiriusControlHandler siriusControlHandler = new CapellaSiriusControlHandler(shell_);
        siriusControlHandler.performControl(shell_, this._eObject, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void run() {
        boolean controlling = this.command == null;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((EObject)this._eObject);
        CrossReferencerHelper.enableResolveProxy((TransactionalEditingDomain)editingDomain);
        if (controlling) {
            this.fragment(shell);
        } else {
            this.unFragment(shell);
        }
        CrossReferencerHelper.disableResolveProxy((TransactionalEditingDomain)editingDomain);
    }

    protected void saveSession(EObject semanticRoot) {
        final Session session = SessionManager.INSTANCE.getSession(semanticRoot);
        TransactionHelper.getExecutionManager((Session)session).execute((ICommand)new AbstractNonDirtyingCommand(){

            public void run() {
                session.save((IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    protected void unFragment(Shell shell_) {
        final UncontrolMessageDialog confirmationDialog = new UncontrolMessageDialog(shell_, EObjectLabelProviderHelper.getText((EObject)this._eObject));
        if (confirmationDialog.open() != 0) {
            return;
        }
        CapellaSiriusUncontrolHandler siriusUncontrolHandler = new CapellaSiriusUncontrolHandler(this){

            protected boolean shouldUncontrolRepresentations(Shell shell) {
                return confirmationDialog.shouldUncontrolRepresentations();
            }
        };
        siriusUncontrolHandler.performUncontrol(shell_, this._eObject, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void setResourceSetSyncNotificationEnabled(Session session, boolean notificationEnabled) {
        ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)TransactionHelper.getEditingDomain((Session)session)).setNotificationIsRequired(notificationEnabled);
    }

    public class CapellaSiriusControlCommand
    extends SiriusControlCommand {
        public CapellaSiriusControlCommand(EObject semanticRoot, URI semanticDest, Set<DRepresentationDescriptor> repDescriptors, URI representationsDest) {
            super(semanticRoot, semanticDest, repDescriptors, representationsDest, true, (IProgressMonitor)new NullProgressMonitor());
        }

        protected EObject getRootContainer(EObject eObject) {
            return super.getRootContainer(eObject);
        }
    }

    public class CapellaSiriusControlHandler
    extends SiriusControlHandler {
        protected Shell shell;

        public CapellaSiriusControlHandler(Shell shell) {
            this.shell = shell;
        }

        protected ResourceDialog createControlResourceDialog(Shell shell, String defaultURI) {
            ControlResourceDialog controlResourceDialog = new ControlResourceDialog(this.shell, DesignerControlAction.this.domain, DesignerControlAction.this._eObject.eResource(), DesignerControlAction.this._eObject);
            return controlResourceDialog;
        }

        protected URI getDefaultCorrespondingAird(URI semanticModelUri) {
            return semanticModelUri.trimFileExtension().appendFileExtension(AbstractPreferencesInitializer.getString((String)"CapellaAirdFragmentFileExtension", (boolean)true));
        }

        protected Collection<DRepresentationDescriptor> getRepresentationDescriptorsToMove(Shell shell, Session session, EObject semanticRoot) throws InterruptedException {
            Collection<DRepresentationDescriptor> repDescriptors = this.collectExistingRepresentationDescriptors(session, semanticRoot);
            Collection<DRepresentationDescriptor> repDescriptorsToMove = null;
            repDescriptorsToMove = repDescriptors.isEmpty() ? repDescriptors : this.askUserWhichRepresentationToSplit(this.shell, session, repDescriptors);
            return repDescriptorsToMove;
        }

        protected Collection<DRepresentationDescriptor> askUserWhichRepresentationToSplit(Shell shell, Session session, Collection<DRepresentationDescriptor> preselection) throws InterruptedException {
            if (!DialectManager.INSTANCE.getAllRepresentationDescriptors(session).isEmpty()) {
                SelectRepresentationsWizard wizard = new SelectRepresentationsWizard(session, preselection);
                wizard.init();
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.setHelpAvailable(false);
                dialog.create();
                if (dialog.open() == 0) {
                    return wizard.getSelectedRepresentations();
                }
                throw new InterruptedException();
            }
            return Collections.emptySet();
        }

        public void performControl(Shell shell, EObject semanticRoot, IProgressMonitor monitor) {
            URI semanticDest;
            Session session = SessionManager.INSTANCE.getSession(semanticRoot);
            if (session != null && (semanticDest = this.getControledResourceURI(this.shell, semanticRoot)) != null) {
                HashSet<DRepresentationDescriptor> repDescriptors = new HashSet<DRepresentationDescriptor>(0);
                try {
                    repDescriptors.addAll(this.getRepresentationDescriptorsToMove(this.shell, session, semanticRoot));
                }
                catch (InterruptedException exception) {
                    StringBuilder loggerMessage = new StringBuilder(".performControl(..) _ ");
                    logger.warn((Object)new EmbeddedMessage(loggerMessage.toString(), "User Interface"));
                }
                HashSet<Resource> resources = new HashSet<Resource>(0);
                for (DRepresentationDescriptor repDescriptor : repDescriptors) {
                    resources.add(repDescriptor.eResource());
                }
                resources.addAll(RepresentationHelper.collectDependentResources((EObject)semanticRoot));
                URI representationDest = this.getDefaultCorrespondingAird(semanticDest);
                DesignerControlAction.this.setResourceSetSyncNotificationEnabled(session, false);
                try {
                    DesignerControlAction.this.doExecuteCommand(semanticRoot, resources, (Command)new CapellaSiriusControlCommand(semanticRoot, semanticDest, repDescriptors, representationDest));
                }
                catch (Throwable throwable) {
                    Display.getCurrent().syncExec(new Runnable(session, semanticRoot, repDescriptors){
                        private final /* synthetic */ Session val$session;
                        private final /* synthetic */ EObject val$semanticRoot;
                        private final /* synthetic */ Set val$repDescriptors;
                        {
                            this.val$session = session;
                            this.val$semanticRoot = eObject;
                            this.val$repDescriptors = set;
                        }

                        @Override
                        public void run() {
                            DesignerControlAction.this.setResourceSetSyncNotificationEnabled(this.val$session, true);
                            DesignerControlAction.this.saveSession(this.val$semanticRoot);
                            HashSet representations = Sets.newHashSet();
                            for (DRepresentationDescriptor repDesc : this.val$repDescriptors) {
                                representations.add(repDesc.getRepresentation());
                            }
                            SessionHelper.reloadEditors(this.val$session, representations);
                        }
                    });
                    throw throwable;
                }
                Display.getCurrent().syncExec(new /* invalid duplicate definition of identical inner class */);
            }
        }

        public void dispose() {
            super.dispose();
            this.shell = null;
        }
    }

    public class CapellaSiriusUncontrolCommand
    extends SiriusUncontrolCommand {
        private EObject semanticRoot;

        public CapellaSiriusUncontrolCommand(EObject semanticRoot, boolean uncontrolRepresentations) {
            super(semanticRoot, uncontrolRepresentations, true, (IProgressMonitor)new NullProgressMonitor());
            this.semanticRoot = semanticRoot;
        }

        protected void doExecute() {
            super.doExecute();
            SemanticEditingDomainFactory.SemanticEditingDomain editingDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)TransactionHelper.getEditingDomain((EObject)this.semanticRoot);
            EReference containingFeature = this.semanticRoot.eContainmentFeature();
            int eventType = containingFeature.isMany() ? 3 : 1;
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this.semanticRoot.eContainer(), eventType, (EStructuralFeature)containingFeature, null, (Object)this.semanticRoot);
            editingDomain.getCrossReferencer().notifyChanged((Notification)notification);
        }

        public Resource getAirdResourceWithAnalysisOn(EObject object) {
            return super.getAirdResourceWithAnalysisOn(object);
        }

        public Collection<DAnalysis> getAnalyses(Resource aird) {
            return super.getAnalyses(aird);
        }

        protected EObject getRootContainer(EObject eObject) {
            return super.getRootContainer(eObject);
        }
    }

    public class CapellaSiriusUncontrolHandler
    extends SiriusUncontrolHandler {
        private Resource addUnreferencedRootSemanticResource(final EObject semanticRoot) {
            final ArrayList referencingElements = new ArrayList(1);
            AbstractReadOnlyCommand resolveResourceCommand = new AbstractReadOnlyCommand(){

                public boolean isReadOnly() {
                    return false;
                }

                public void run() {
                    referencingElements.add(semanticRoot.eResource());
                }
            };
            TransactionHelper.getExecutionManager((EObject)semanticRoot).execute((ICommand)resolveResourceCommand);
            return (Resource)referencingElements.get(0);
        }

        public void performUncontrol(Shell shell, EObject semanticRoot, IProgressMonitor monitor) {
            Session session;
            boolean uncontrolRepresentations = this.shouldUncontrolRepresentations(shell);
            CapellaSiriusUncontrolCommand vuc = new CapellaSiriusUncontrolCommand(semanticRoot, uncontrolRepresentations);
            EObject parentContainer = EcoreUtil2.getResourceContainer((EObject)semanticRoot);
            Resource airdResource = vuc.getAirdResourceWithAnalysisOn(parentContainer);
            HashSet<Resource> resources = new HashSet<Resource>(1);
            if (airdResource != null) {
                resources.add(airdResource);
            }
            if ((session = SessionManager.INSTANCE.getSession(semanticRoot)) != null) {
                Collection settings = session.getSemanticCrossReferencer().getInverseReferences(semanticRoot);
                for (EStructuralFeature.Setting setting : settings) {
                    if (setting == null || !ViewpointPackage.Literals.DANALYSIS__MODELS.equals(setting.getEStructuralFeature()) || setting.getEObject() == null || setting.getEObject().eResource() == null) continue;
                    resources.add(setting.getEObject().eResource());
                }
            }
            resources.addAll(RepresentationHelper.collectDependentResources((EObject)semanticRoot));
            if (semanticRoot.eResource() != null && !resources.contains(semanticRoot.eResource())) {
                resources.add(this.addUnreferencedRootSemanticResource(semanticRoot));
            }
            DesignerControlAction.this.setResourceSetSyncNotificationEnabled(session, false);
            try {
                DesignerControlAction.this.doExecuteCommand(parentContainer, resources, (Command)vuc);
            }
            catch (Throwable throwable) {
                Display.getCurrent().syncExec(new Runnable(session, semanticRoot){
                    private final /* synthetic */ Session val$session;
                    private final /* synthetic */ EObject val$semanticRoot;
                    {
                        this.val$session = session;
                        this.val$semanticRoot = eObject;
                    }

                    @Override
                    public void run() {
                        DesignerControlAction.this.setResourceSetSyncNotificationEnabled(this.val$session, true);
                        DesignerControlAction.this.saveSession(this.val$semanticRoot);
                        SessionHelper.reloadEditors(this.val$session);
                    }
                });
                throw throwable;
            }
            Display.getCurrent().syncExec(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

