/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.closeproject;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.util.ECrossReferenceAdapterWithUnproxyCapability;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.polarsys.capella.common.helpers.TransactionHelper;

public class SessionCloseManager {
    public static void saveSession(Session session) {
        session.save((IProgressMonitor)new NullProgressMonitor());
    }

    public static IEditingSession getUISession(Session session) {
        IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(session);
        return editingSession;
    }

    public static void closeUISession(IEditingSession uiSession, boolean saveIsNeeded) {
        uiSession.close(saveIsNeeded);
        SessionUIManager.INSTANCE.remove(uiSession);
    }

    public static boolean isDirty(Session session) {
        return SessionStatus.DIRTY.equals((Object)session.getStatus());
    }

    public static void closeSession(Session session) {
        SessionCloseManager.closeSession(session, null);
    }

    public static void closeSession(Session session, IProgressMonitor monitor) {
        session.close(monitor);
    }

    public static void cleanSession(Session session) {
        TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((Session)session);
        if (session instanceof DAnalysisSessionImpl) {
            ECrossReferenceAdapterWithUnproxyCapability cross = ((DAnalysisSessionImpl)session).getSemanticCrossReferencer();
            cross.disableResolveProxy();
        }
        try {
            for (Resource resource : session.getAllSessionResources()) {
                resource.unload();
                editingDomain.getResourceSet().getResources().remove((Object)resource);
            }
            for (Resource resource : session.getSemanticResources()) {
                resource.unload();
                editingDomain.getResourceSet().getResources().remove((Object)resource);
            }
        }
        finally {
            if (session instanceof DAnalysisSessionImpl) {
                ECrossReferenceAdapterWithUnproxyCapability cross = ((DAnalysisSessionImpl)session).getSemanticCrossReferencer();
                cross.enableResolveProxy();
            }
        }
        SessionManager.INSTANCE.remove(session);
    }
}

