/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.validation.scenario;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityRealization;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class AbstractCapabilityRealizationCheck
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof AbstractCapability) {
            AbstractCapability capa = (AbstractCapability)eObj;
            EList incomingTraces = capa.getIncomingTraces();
            if (!incomingTraces.isEmpty()) {
                for (AbstractTrace abstractTrace : incomingTraces) {
                    if (!(abstractTrace instanceof AbstractCapabilityRealization)) continue;
                    return ctx_p.createSuccessStatus();
                }
            }
            if (CapellaLayerCheckingExt.isAOrInEPBSLayer((CapellaElement)capa)) {
                return ctx_p.createSuccessStatus();
            }
            String lowerLayerCapa = "CapabilityRealization";
            if (CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)capa)) {
                lowerLayerCapa = "Capability";
            }
            return ctx_p.createFailureStatus(new Object[]{String.valueOf(capa.getName()) + " (" + capa.eClass().getName() + ")" + " is not realized by any " + lowerLayerCapa});
        }
        return ctx_p.createSuccessStatus();
    }
}

