/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.validation.sequence_message;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_SequenceMessage_NameValidation
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL) {
            Event event;
            IStatus status = null;
            SequenceMessage seqMsg = (SequenceMessage)eObj;
            MessageEnd rcvMsgEnd = seqMsg.getReceivingEnd();
            if (rcvMsgEnd != null && (event = rcvMsgEnd.getEvent()) != null) {
                if (event instanceof EventReceiptOperation) {
                    EventReceiptOperation evt = (EventReceiptOperation)event;
                    AbstractEventOperation op = evt.getOperation();
                    status = this.getAppropriateFailureMessage(ctx_p, seqMsg, op);
                } else if (event instanceof EventSentOperation) {
                    EventSentOperation evt = (EventSentOperation)event;
                    AbstractEventOperation op = evt.getOperation();
                    status = this.getAppropriateFailureMessage(ctx_p, seqMsg, op);
                }
            }
            if (status != null) {
                return status;
            }
        }
        return ctx_p.createSuccessStatus();
    }

    private IStatus getAppropriateFailureMessage(IValidationContext ctx_p, SequenceMessage seqMsg, AbstractEventOperation op) {
        IStatus status = null;
        if (op != null) {
            String opName = op.getName();
            String seqMsgName = seqMsg.getName();
            if (op instanceof ExchangeItemAllocation) {
                ExchangeItemAllocation itemAllocation = (ExchangeItemAllocation)op;
                ExchangeItem allocatedItem = itemAllocation.getAllocatedItem();
                if (allocatedItem != null && ((opName = allocatedItem.getName()) == null && seqMsgName != null || opName != null && !opName.equals(seqMsgName))) {
                    status = ctx_p.createFailureStatus(new Object[]{seqMsg.getName(), opName, InformationPackage.Literals.OPERATION.getName()});
                }
            } else if (opName == null && seqMsgName != null || opName != null && !opName.equals(seqMsgName)) {
                status = ctx_p.createFailureStatus(new Object[]{seqMsg.getName(), opName, InformationPackage.Literals.OPERATION.getName()});
            }
        }
        return status;
    }
}

