/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.validation.stateFragment;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.interaction.services.InstanceRoleExt;
import org.polarsys.capella.core.data.helpers.interaction.services.StateFragmentExt;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_StateFragment_ES_OES_AllocatedFunction
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EMFEventType eType = ctx.getEventType();
        if (EMFEventType.NULL != eType) {
            return ctx.createSuccessStatus();
        }
        EObject eObj = ctx.getTarget();
        if (!(eObj instanceof StateFragment)) {
            return ctx.createSuccessStatus();
        }
        StateFragment stateFragment = (StateFragment)eObj;
        if (stateFragment.getRelatedAbstractFunction() == null) {
            return ctx.createSuccessStatus();
        }
        Scenario containingScenario = (Scenario)stateFragment.eContainer();
        if (containingScenario.getKind() != ScenarioKind.DATA_FLOW && (containingScenario.getKind() != ScenarioKind.INTERACTION || ScenarioExt.isFunctionalScenario((Scenario)containingScenario))) {
            return ctx.createSuccessStatus();
        }
        AbstractFunction relatedFunction = stateFragment.getRelatedAbstractFunction();
        InstanceRole instanceRole = StateFragmentExt.getCoveredInstanceRole((StateFragment)stateFragment);
        AbstractInstance representedInstance = instanceRole.getRepresentedInstance();
        if (representedInstance != null && !CapellaServices.getService().isAllocatedFunction((EObject)representedInstance, relatedFunction, (EObject)representedInstance.getAbstractType())) {
            Component component = InstanceRoleExt.getComponent((InstanceRole)instanceRole);
            String relatedFunctionMetaClassLabel = EObjectLabelProviderHelper.getMetaclassLabel((EObject)relatedFunction, (boolean)false);
            String scenarioMetaClassLabel = EObjectLabelProviderHelper.getMetaclassLabel((EObject)containingScenario, (boolean)false);
            String componentMetaClassLabel = EObjectLabelProviderHelper.getMetaclassLabel((EObject)component, (boolean)false);
            String deployed = BlockArchitectureExt.getRootBlockArchitecture((EObject)containingScenario) instanceof PhysicalArchitecture ? "/deployed" : "";
            String componentName = null;
            if (component != null) {
                componentName = component.getName();
            }
            return ctx.createFailureStatus(new Object[]{relatedFunction.getName(), relatedFunctionMetaClassLabel, containingScenario.getName(), scenarioMetaClassLabel, componentName, componentMetaClassLabel, deployed});
        }
        return ctx.createSuccessStatus();
    }
}

