/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.association;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.model.helpers.AssociationExt;
import org.polarsys.capella.core.model.helpers.PropertyExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ClassAssociationConsistency
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        EObject eObj = ctx.getTarget();
        if (eObj instanceof Association) {
            Association assoc = (Association)eObj;
            ArrayList propsToCheck = new ArrayList();
            if (AssociationExt.isUnidirectional((EObject)assoc)) {
                propsToCheck.addAll(assoc.getNavigableMembers());
                propsToCheck.addAll(assoc.getOwnedMembers());
            } else if (AssociationExt.isBidirectional((EObject)assoc)) {
                propsToCheck.addAll(assoc.getNavigableMembers());
            } else if (AssociationExt.isNondirectional((EObject)assoc)) {
                propsToCheck.addAll(assoc.getOwnedMembers());
            }
            for (Property property : propsToCheck) {
                if (PropertyExt.isTyped((Property)property)) continue;
                IStatus status = ctx.createFailureStatus(new Object[]{property.getName(), assoc.getName()});
                statuses.add(status);
            }
            if (!statuses.isEmpty()) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }
}

