/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.dataValue;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datavalue.BooleanReference;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.DatavaluePackage;
import org.polarsys.capella.core.data.information.datavalue.EnumerationLiteral;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralStringValue;
import org.polarsys.capella.core.data.information.datavalue.NumericReference;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.information.datavalue.StringReference;
import org.polarsys.capella.core.data.information.validation.dataValue.Messages;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class EnumerationLiteralDomainValueCheck
extends AbstractValidationRule {
    static final String EMPTY_STRING = "";

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        if (eObj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)eObj;
            EList ownedLiterals = enumeration.getOwnedLiterals();
            for (EnumerationLiteral enumerationLiteral : ownedLiterals) {
                if (this.isSatisfiedBy(enumerationLiteral, enumeration)) continue;
                return ctx.createFailureStatus(new Object[]{eObj, this.typingState(enumeration), this.computeDiagnosticMessage(enumeration)});
            }
        }
        return ctx.createSuccessStatus();
    }

    public boolean isSatisfiedBy(EnumerationLiteral enumerationLiteral, Enumeration enumeration) {
        DataType domainType = enumeration.getDomainType();
        EList ownedLiterals = enumeration.getOwnedLiterals();
        if (ownedLiterals.isEmpty()) {
            return true;
        }
        if (domainType != null) {
            if (this.checkDefined((EList<EnumerationLiteral>)ownedLiterals) && this.ownedLiteralTypesAreConcordantWithEnumDomainType((EList<EnumerationLiteral>)ownedLiterals, domainType)) {
                return true;
            }
        } else {
            if (this.checkDefined((EList<EnumerationLiteral>)ownedLiterals) && this.areNumericValues((EList<EnumerationLiteral>)ownedLiterals)) {
                return true;
            }
            if (this.checkUndefined((EList<EnumerationLiteral>)ownedLiterals)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkDefined(EList<EnumerationLiteral> ownedLiterals) {
        for (EnumerationLiteral literal : ownedLiterals) {
            String valueLiteral;
            DataValue domainValue = literal.getDomainValue();
            if (domainValue == null) {
                return false;
            }
            DataValue value = this.getReferencedLiteralValue(domainValue);
            if (value instanceof LiteralBooleanValue) {
                return true;
            }
            if (!(value instanceof LiteralNumericValue ? this.isNull(valueLiteral = ((LiteralNumericValue)value).getValue(), true) || EMPTY_STRING.equals(valueLiteral) : value instanceof LiteralStringValue && (this.isNull(valueLiteral = ((LiteralStringValue)value).getValue(), true) || EMPTY_STRING.equals(valueLiteral)))) continue;
            return false;
        }
        return true;
    }

    private boolean checkUndefined(EList<EnumerationLiteral> ownedLiterals) {
        for (EnumerationLiteral literal : ownedLiterals) {
            String valueLiteral;
            DataValue domainValue = literal.getDomainValue();
            if (domainValue == null) continue;
            DataValue value = this.getReferencedLiteralValue(domainValue);
            if (value instanceof LiteralBooleanValue) {
                return false;
            }
            if (!(value instanceof LiteralNumericValue ? this.isNull(valueLiteral = ((LiteralNumericValue)value).getValue(), false) && !EMPTY_STRING.equals(valueLiteral) : value instanceof LiteralStringValue && this.isNull(valueLiteral = ((LiteralStringValue)value).getValue(), false) && !EMPTY_STRING.equals(valueLiteral))) continue;
            return false;
        }
        return true;
    }

    private boolean areNumericValues(EList<EnumerationLiteral> ownedLiterals) {
        for (EnumerationLiteral literal : ownedLiterals) {
            DataValue domainValue = literal.getDomainValue();
            DataValue value = this.getReferencedLiteralValue(domainValue);
            if (value instanceof NumericValue) continue;
            return false;
        }
        return true;
    }

    private TypeRelationship getRelationShip(EnumerationLiteral firstLiteral, DataType domainType) {
        if (this.ownedLiteralTypeIsConcordantWithEnumDomainType(firstLiteral, domainType, TypeRelationship.FIRST_UNTYPED)) {
            return TypeRelationship.FIRST_UNTYPED;
        }
        if (this.ownedLiteralTypeIsConcordantWithEnumDomainType(firstLiteral, domainType, TypeRelationship.SUBTYPE)) {
            return TypeRelationship.SUBTYPE;
        }
        return null;
    }

    private boolean ownedLiteralTypesAreConcordantWithEnumDomainType(EList<EnumerationLiteral> ownedLiterals, DataType domainType) {
        if (ownedLiterals.isEmpty()) {
            return true;
        }
        EnumerationLiteral firstLiteral = (EnumerationLiteral)ownedLiterals.get(0);
        TypeRelationship firstLiteralRelationShip = this.getRelationShip(firstLiteral, domainType);
        if (firstLiteralRelationShip == null) {
            return false;
        }
        List ownedLiteralsTail = ownedLiterals.subList(1, ownedLiterals.size());
        for (EnumerationLiteral literal : ownedLiteralsTail) {
            if (this.ownedLiteralTypeIsConcordantWithEnumDomainType(literal, domainType, firstLiteralRelationShip)) continue;
            return false;
        }
        return true;
    }

    private boolean ownedLiteralTypeIsConcordantWithEnumDomainType(EnumerationLiteral literal, DataType domainType, TypeRelationship relationship) {
        AbstractType type;
        DataValue domainValue = literal.getDomainValue();
        DataValue value = this.getReferencedLiteralValue(domainValue);
        return (value instanceof LiteralBooleanValue || value instanceof LiteralNumericValue || value instanceof LiteralStringValue) && this.areConcordantTypes(type = value.getAbstractType(), domainType, relationship);
    }

    private boolean areConcordantTypes(AbstractType type, DataType domainType, TypeRelationship relationshipCheck) {
        switch (relationshipCheck) {
            case FIRST_UNTYPED: {
                return type == null;
            }
            case SUBTYPE: {
                return this.isEqualOrSubtypeOf(type, domainType);
            }
        }
        return false;
    }

    private DataValue getReferencedLiteralValue(DataValue domainValue) {
        if (domainValue instanceof BooleanReference) {
            return this.getReferencedLiteralBooleanValue(domainValue);
        }
        if (domainValue instanceof NumericReference) {
            return this.getReferencedLiteralNumericValue(domainValue);
        }
        if (domainValue instanceof StringReference) {
            return this.getReferencedLiteralStringValue(domainValue);
        }
        return domainValue;
    }

    private LiteralBooleanValue getReferencedLiteralBooleanValue(DataValue domainValue) {
        Object ref = domainValue.eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getBooleanReference_ReferencedValue());
        while (ref instanceof BooleanReference && ((BooleanReference)ref).eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getBooleanReference_ReferencedValue()) != null) {
            ref = ((BooleanReference)ref).eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getBooleanReference_ReferencedValue());
        }
        if (ref instanceof LiteralBooleanValue) {
            return (LiteralBooleanValue)ref;
        }
        return null;
    }

    private LiteralStringValue getReferencedLiteralStringValue(DataValue domainValue) {
        Object ref = domainValue.eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getStringReference_ReferencedValue());
        while (ref instanceof StringReference && ((StringReference)ref).eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getStringReference_ReferencedValue()) != null) {
            ref = ((StringReference)ref).eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getStringReference_ReferencedValue());
        }
        if (ref instanceof LiteralStringValue) {
            return (LiteralStringValue)ref;
        }
        return null;
    }

    private LiteralNumericValue getReferencedLiteralNumericValue(DataValue domainValue) {
        Object ref = domainValue.eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getNumericReference_ReferencedValue());
        while (ref instanceof NumericReference && ((NumericReference)ref).eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getNumericReference_ReferencedValue()) != null) {
            ref = ((NumericReference)ref).eGet((EStructuralFeature)DatavaluePackage.eINSTANCE.getNumericReference_ReferencedValue());
        }
        if (ref instanceof LiteralNumericValue) {
            return (LiteralNumericValue)ref;
        }
        return null;
    }

    private String computeDiagnosticMessage(Enumeration enumeration) {
        if (this.isTyped(enumeration)) {
            return Messages.EnumerationLiteralDomainValueCheck_typedEnum_diagnostic;
        }
        return Messages.EnumerationLiteralDomainValueCheck_unTypedEnum_diagnostic;
    }

    private String typingState(Enumeration enumeration) {
        return this.isTyped(enumeration) ? "typed" : "not typed";
    }

    private boolean isTyped(Enumeration enumeration) {
        return enumeration.getDomainType() != null;
    }

    private boolean isNull(Object elt, boolean expected) {
        if (elt == null) {
            return expected;
        }
        return !expected;
    }

    private boolean isEqualOrSubtypeOf(AbstractType type, DataType domainType) {
        if (domainType == null || type == null) {
            return false;
        }
        List subTypes = GeneralizableElementExt.getAllSubGeneralizableElements((GeneralizableElement)domainType);
        if (subTypes.contains(type)) {
            return true;
        }
        return type.equals(domainType);
    }

    static enum TypeRelationship {
        FIRST_UNTYPED,
        SUBTYPE;

    }
}

