/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.information;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.helpers.information.services.CommunicationLinkExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class CommunicationLinkForComponentIsDefinedInItsParent
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        if (eObj instanceof CommunicationLink) {
            CommunicationLink link = (CommunicationLink)eObj;
            ExchangeItem item = link.getExchangeItem();
            Component component = CommunicationLinkExt.getSource((CommunicationLink)link);
            ArrayList<Component> parentsInError = new ArrayList<Component>();
            for (Component parent : ComponentExt.getDirectParents((Component)component)) {
                if (BlockArchitectureExt.isRootComponent((Component)parent) || this.getExchangeItemsForLinks(parent, link).contains(item)) continue;
                parentsInError.add(parent);
            }
            if (parentsInError.size() > 0) {
                StringBuilder b = new StringBuilder();
                int i = 0;
                while (i < parentsInError.size()) {
                    b.append(CapellaElementExt.getCapellaExplorerLabel((EObject)((EObject)parentsInError.get(i))));
                    if (i < parentsInError.size() - 1) {
                        b.append(", ");
                    }
                    ++i;
                }
                return ctx.createFailureStatus(new Object[]{link.getKind(), CapellaElementExt.getCapellaExplorerLabel((EObject)component), CapellaElementExt.getCapellaExplorerLabel((EObject)item), b.toString()});
            }
        }
        return ctx.createSuccessStatus();
    }

    private List<ExchangeItem> getExchangeItemsForLinks(Component component, CommunicationLink link) {
        ArrayList<ExchangeItem> exchangeItems = new ArrayList<ExchangeItem>();
        ArrayList links = new ArrayList();
        if (CommunicationLinkExt.isSender((CommunicationLink)link)) {
            links.addAll(component.getTransmit());
            links.addAll(component.getSend());
            links.addAll(component.getProduce());
            links.addAll(component.getCall());
            links.addAll(component.getWrite());
        }
        if (CommunicationLinkExt.isReceiver((CommunicationLink)link)) {
            links.addAll(component.getAcquire());
            links.addAll(component.getReceive());
            links.addAll(component.getConsume());
            links.addAll(component.getExecute());
            links.addAll(component.getAccess());
        }
        for (CommunicationLink communicationLink : links) {
            exchangeItems.add(communicationLink.getExchangeItem());
        }
        return exchangeItems;
    }
}

