/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.config.registry;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Logger;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.spi.Filter;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.Bundle;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.EmbeddedMessageRenderer;
import org.polarsys.capella.common.tools.report.ReportManagerActivator;
import org.polarsys.capella.common.tools.report.StatusRenderer;
import org.polarsys.capella.common.tools.report.appenders.IFlushableAppenders;
import org.polarsys.capella.common.tools.report.appenders.ReportManagerFilter;
import org.polarsys.capella.common.tools.report.config.persistence.ConfigurationInstance;
import org.polarsys.capella.common.tools.report.config.persistence.CreateXmlConfiguration;

public class ReportManagerRegistry {
    private Map<String, ConfigurationInstance> _configurations = new HashMap<String, ConfigurationInstance>(1);
    private static ReportManagerRegistry instance;

    protected ReportManagerRegistry() {
        Collection<String> kinds = this.getAppenderKinds();
        CreateXmlConfiguration configuration = new CreateXmlConfiguration();
        ConfigurationInstance defaultConfInstance = configuration.createDefaultConfiguration("Default", kinds);
        this._configurations.put(defaultConfInstance.getComponentName(), defaultConfInstance);
        if (configuration.isConfigurationFileExists()) {
            HashMap<String, ConfigurationInstance> persisted = configuration.loadConfiguration();
            HashMap<String, ConfigurationInstance> result = new HashMap<String, ConfigurationInstance>(1);
            for (Map.Entry<String, ConfigurationInstance> entry : persisted.entrySet()) {
                if (entry.getKey() == null) continue;
                ConfigurationInstance newConf = configuration.createDefaultConfiguration(entry.getKey(), kinds);
                newConf.merge(entry.getValue());
                result.put(entry.getKey(), newConf);
            }
            this._configurations.putAll(result);
        }
        this.setConfigurations(this._configurations);
        this.initRootLogger();
    }

    public Collection<String> getAppenderKinds() {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        List<Appender> appenders = ReportManagerActivator.getDefault().getAppenders();
        for (Appender appender : appenders) {
            ids.add(appender.getName());
        }
        return ids;
    }

    public static String getConfigurationFile(Bundle bundle, String path) {
        try {
            URL confURL = bundle.getEntry(path);
            return FileLocator.toFileURL((URL)confURL).getPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static synchronized ReportManagerRegistry getInstance() {
        if (instance == null) {
            instance = new ReportManagerRegistry();
            instance.subscribe("Default");
        }
        return instance;
    }

    protected void initRootLogger() {
        try {
            Logger root = Logger.getRootLogger();
            for (Appender appender : ReportManagerActivator.getDefault().getAppenders()) {
                root.addAppender(appender);
                appender.addFilter((Filter)new ReportManagerFilter(appender));
            }
            Hierarchy h = (Hierarchy)root.getLoggerRepository();
            EmbeddedMessageRenderer emRenderer = new EmbeddedMessageRenderer();
            h.addRenderer(EmbeddedMessage.class, (ObjectRenderer)emRenderer);
            StatusRenderer stRenderer = new StatusRenderer();
            h.addRenderer(IStatus.class, (ObjectRenderer)stRenderer);
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
    }

    public Logger subscribe(String componentName) {
        return this.subscribe(componentName, null);
    }

    public Logger subscribe(String componentName, String defaultConfigurationPath) {
        this.getComponentConfiguration(componentName, defaultConfigurationPath);
        return Logger.getLogger((String)componentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribe(String componentName) {
        if (this._configurations.containsKey(componentName)) {
            Map<String, ConfigurationInstance> map = this._configurations;
            synchronized (map) {
                this._configurations.remove(componentName);
            }
        }
    }

    protected List<IFlushableAppenders> getFlushableAppenders() {
        ReportManagerActivator act = ReportManagerActivator.getDefault();
        List<IFlushableAppenders> theAppenders = act.getFlushableAppenders();
        return theAppenders;
    }

    public void beginLoggingSession() {
        this.beginLoggingSession("ALL");
    }

    public void beginLoggingSession(String componentName) {
        this.beginLoggingSession(componentName, null);
    }

    public void beginLoggingSession(String componentName, Object loggedElement) {
        for (IFlushableAppenders _appender : this.getFlushableAppenders()) {
            _appender.flush(componentName, loggedElement);
        }
    }

    public Object[] getComponentsList() {
        return this._configurations.keySet().toArray();
    }

    public ConfigurationInstance getComponentConfiguration(String componentName) {
        return this.getComponentConfiguration(componentName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigurationInstance getComponentConfiguration(String componentName, String defaultConfigurationPath) {
        Map<String, ConfigurationInstance> map = this._configurations;
        synchronized (map) {
            ConfigurationInstance instance = this._configurations.get(componentName);
            if (instance == null && defaultConfigurationPath != null) {
                instance = this.loadFromFile(defaultConfigurationPath, componentName);
            }
            if (instance == null) {
                instance = this._configurations.get("Default").clone();
                instance.setComponentName(componentName);
            }
            this._configurations.put(componentName, instance);
            return instance;
        }
    }

    private ConfigurationInstance loadFromFile(String defaultConfigurationPath, String componentName) {
        try {
            return new CreateXmlConfiguration(defaultConfigurationPath).loadConfiguration().get(componentName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration() {
        CreateXmlConfiguration configuration = new CreateXmlConfiguration();
        Map<String, ConfigurationInstance> map = this._configurations;
        synchronized (map) {
            configuration.saveConfiguration(this._configurations);
        }
    }

    public Map<String, ConfigurationInstance> getConfigurations() {
        return this._configurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurations(Map<String, ConfigurationInstance> map) {
        Map<String, ConfigurationInstance> map2 = this._configurations;
        synchronized (map2) {
            this._configurations = map;
        }
    }

    public String toString() {
        return "ReportManager";
    }
}

