/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.ui.renderers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.common.flexibility.properties.PropertyChangeListener;
import org.polarsys.capella.common.flexibility.properties.PropertyChangedEvent;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.wizards.renderer.EditListRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IPropertyRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.handlers.location.LocationHandlerHelper;
import org.polarsys.capella.common.re.handlers.replicable.ReplicableElementHandlerHelper;
import org.polarsys.capella.common.re.helpers.ReplicableElementExt;
import org.polarsys.capella.common.re.ui.renderers.NameCellModifier;
import org.polarsys.capella.common.re.ui.renderers.ReplicaLabelProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.ListData;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ReplicaContentLocationRenderer
extends EditListRenderer
implements PropertyChangeListener {
    protected IRendererContext contextOnDrop = null;

    protected int getExpandLevel() {
        return 2;
    }

    protected void createTreeViewer(Composite parent, IRendererContext context) {
        super.createTreeViewer(parent, context);
        TreeViewer viewer = this.getViewer().getClientViewer();
        viewer.setColumnProperties(new String[]{"name"});
        viewer.setCellModifier((ICellModifier)new NameCellModifier((Viewer)viewer, context));
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)viewer.getTree())});
        TreeViewerFocusCellManager manager = new TreeViewerFocusCellManager(viewer, new FocusCellHighlighter((ColumnViewer)viewer){});
        TreeViewerEditor.create((TreeViewer)viewer, (SWTFocusCellManager)manager, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 1 && event.keyCode == 0x100000B;
            }
        }, (int)32);
    }

    protected void doubleClicked(ISelection doubleClickedElement, IRendererContext rendererContext) {
        super.doubleClicked(doubleClickedElement, rendererContext);
        rendererContext.getPropertyContext().setCurrentValue(rendererContext.getPropertyContext().getProperties().getProperty("org.polarsys.capella.common.re.selection"), (Object)((IStructuredSelection)doubleClickedElement).toList());
    }

    protected IContentProvider createContentProvider(final IRendererContext context) {
        return new AdapterFactoryContentProvider(this.getAdapterFactory(context)){

            public Object[] getElements(Object object) {
                return this.getChildren(object);
            }

            public Object[] getChildren(Object object) {
                IContext ctx = (IContext)context.getPropertyContext().getSource();
                ArrayList<Object> childs = new ArrayList<Object>();
                if (object instanceof CatalogElement) {
                    IProperty property = context.getPropertyContext().getProperties().getProperty("itarget");
                    Object replica = context.getPropertyContext().getCurrentValue(property);
                    Collection usedElements = ReplicableElementHandlerHelper.getInstance((IContext)ctx).getUsedReplicableElements((CatalogElement)replica);
                    for (CatalogElement element : ((CatalogElement)object).getOwnedElements()) {
                        if (usedElements.contains(element)) continue;
                        childs.add(element);
                    }
                } else {
                    childs.addAll(Arrays.asList(super.getChildren(object)));
                }
                Object value = context.getPropertyContext().getCurrentValue(context.getProperty((IPropertyRenderer)ReplicaContentLocationRenderer.this));
                if (value != null && value instanceof Collection) {
                    Collection scopeElements = (Collection)value;
                    for (EObject element : scopeElements) {
                        if (!ContextScopeHandlerHelper.getInstance((IContext)ctx).contains("CREATED_LINKS", element, ctx) || !object.equals(this.getLocation(element)) || childs.contains(element)) continue;
                        childs.add(element);
                    }
                }
                IProperty property = context.getPropertyContext().getProperties().getProperty("locationTarget");
                Object replica = context.getPropertyContext().getCurrentValue(property);
                if (object.equals(replica)) {
                    property = context.getPropertyContext().getProperties().getProperty("itarget");
                    replica = context.getPropertyContext().getCurrentValue(property);
                    if (!childs.contains(replica)) {
                        childs.add(replica);
                    }
                }
                return childs.toArray();
            }

            public boolean hasChildren(Object object) {
                return this.getChildren(object).length > 0;
            }

            protected Object getLocation(EObject element) {
                IContext ctx = (IContext)context.getPropertyContext().getSource();
                if (element instanceof CatalogElementLink) {
                    CatalogElementLink link = (CatalogElementLink)element;
                    EObject location = LocationHandlerHelper.getInstance((IContext)ctx).getCurrentLocation(link, ctx);
                    if (location != null) {
                        return location;
                    }
                    location = LocationHandlerHelper.getInstance((IContext)ctx).getLocation(link, link.getOrigin(), ctx);
                    if (location == null) {
                        EObject defaultLocation = LocationHandlerHelper.getInstance((IContext)ctx).getDefaultLocation(link, link.getOrigin(), ctx);
                        if (defaultLocation != null) {
                            Object value = context.getPropertyContext().getCurrentValue(context.getPropertyContext().getProperties().getProperty("useDefaultLocation"));
                            if (Boolean.FALSE.equals(value)) {
                                return null;
                            }
                            if (defaultLocation instanceof CatalogElementLink && !ContextScopeHandlerHelper.getInstance((IContext)ctx).contains("VIRTUAL_LINKS", defaultLocation, ctx)) {
                                return ((CatalogElementLink)defaultLocation).getTarget();
                            }
                            return defaultLocation;
                        }
                        return null;
                    }
                    if (location instanceof CatalogElement) {
                        IProperty property = context.getPropertyContext().getProperties().getProperty("itarget");
                        Object replica = context.getPropertyContext().getCurrentValue(property);
                        for (CatalogElementLink link2 : ReplicableElementHandlerHelper.getInstance((IContext)ctx).getAllElementsLinks((CatalogElement)replica)) {
                            if (!link2.getTarget().equals(location)) continue;
                            location = link2;
                            break;
                        }
                    }
                    if (location instanceof CatalogElementLink && !ContextScopeHandlerHelper.getInstance((IContext)ctx).contains("CREATED_LINKS", location, ctx)) {
                        return ((CatalogElementLink)location).getTarget();
                    }
                    return location;
                }
                return null;
            }

            public Object getParent(Object object) {
                if (object instanceof CatalogElement) {
                    IProperty property = context.getPropertyContext().getProperties().getProperty("itarget");
                    Object replica = context.getPropertyContext().getCurrentValue(property);
                    if (object.equals(replica)) {
                        property = context.getPropertyContext().getProperties().getProperty("locationTarget");
                        replica = context.getPropertyContext().getCurrentValue(property);
                        return replica;
                    }
                    return null;
                }
                if (object instanceof CatalogElementLink) {
                    Object parent = this.getLocation((EObject)object);
                    return parent;
                }
                return super.getParent(object);
            }
        };
    }

    protected AdapterFactory getAdapterFactory(IRendererContext context) {
        return null;
    }

    protected String getToolbarLocation() {
        return "toolbar:org.polarsys.capella.common.re.createReplica.location";
    }

    protected String getPopupLocation() {
        return "popup:org.polarsys.capella.common.re.createReplica.location";
    }

    public void performRender(Composite parent, final IRendererContext rendererContext) {
        super.performRender(parent, rendererContext);
        int ops = 3;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.getViewer().getClientViewer().addDropSupport(ops, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.getViewer().getClientViewer()){

            protected int determineLocation(DropTargetEvent event) {
                int value = super.determineLocation(event);
                if (value == 2 || value == 1) {
                    value = 4;
                }
                return value;
            }

            public void drop(DropTargetEvent event) {
                Object target = this.determineTarget(event);
                ReplicaContentLocationRenderer.this.contextOnDrop = rendererContext;
                ReplicaContentLocationRenderer.this.handleDrop(target, event.operations, event).isOK();
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return ReplicaContentLocationRenderer.this.validateDrop(target, operation, transferType).isOK();
            }

            public boolean performDrop(Object data) {
                return true;
            }
        });
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return Status.CANCEL_STATUS;
        }
        for (Object item : ((IStructuredSelection)selection).toList()) {
            if (item instanceof CatalogElementLink) continue;
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public IStatus handleDrop(Object target, int operation, DropTargetEvent dropTargetEvent) {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        IContext context = (IContext)this.contextOnDrop.getPropertyContext().getSource();
        for (Object item : ((IStructuredSelection)selection).toList()) {
            if (item instanceof CatalogElementLink && target instanceof CatalogElementLink) {
                LocationHandlerHelper.getInstance((IContext)context).setCurrentLocation((CatalogElementLink)item, (EObject)target, context);
                continue;
            }
            if (!(item instanceof CatalogElementLink) || !(target instanceof EObject)) continue;
            LocationHandlerHelper.getInstance((IContext)context).setCurrentLocation((CatalogElementLink)item, (EObject)target, context);
        }
        IPropertyContext pContext = this.contextOnDrop.getPropertyContext();
        IProperty targetContent = pContext.getProperties().getProperty("targetContent");
        pContext.setCurrentValue(targetContent, pContext.getCurrentValue(targetContent));
        this.getViewer().getClientViewer().refresh();
        this.getViewer().getClientViewer().setSelection(selection, true);
        return Status.OK_STATUS;
    }

    protected Object createInput(IProperty property, IRendererContext context) {
        Object value = context.getPropertyContext().getCurrentValue(property);
        if (value != null && value instanceof Collection) {
            Collection scopeElements = (Collection)value;
            if (scopeElements.isEmpty()) {
                return Collections.emptyList();
            }
            Collection selection = (Collection)((IContext)context.getPropertyContext().getSource()).get((Object)"TRANSITION_SOURCES");
            if (selection != null && selection.size() > 0) {
                for (Object item : selection) {
                    if (!(item instanceof EObject)) continue;
                    return ((EObject)item).eResource();
                }
            }
            return ((CatalogElementLink)scopeElements.iterator().next()).getTarget().eResource();
        }
        return new ListData(Collections.emptyList(), (Object)context.getPropertyContext());
    }

    protected boolean isValidElement(Object element, IRendererContext rendererContext) {
        IProperty property = rendererContext.getPropertyContext().getProperties().getProperty("itarget");
        Object replica = rendererContext.getPropertyContext().getCurrentValue(property);
        IContext context = (IContext)rendererContext.getPropertyContext().getSource();
        for (CatalogElementLink link : ReplicableElementExt.getReferencingLinks((EObject)((EObject)element))) {
            if (!ReplicableElementHandlerHelper.getInstance((IContext)context).getElementsLinks((CatalogElement)replica).contains(link) || ContextScopeHandlerHelper.getInstance((IContext)context).contains("CREATED_LINKS", (EObject)link, context)) continue;
            return true;
        }
        Collection a = (Collection)rendererContext.getPropertyContext().getCurrentValue(rendererContext.getProperty((IPropertyRenderer)this));
        return a.contains(element) || replica.equals(element);
    }

    protected ILabelProvider createLabelProvider(IRendererContext rendererContext) {
        return new ReplicaLabelProvider(rendererContext.getPropertyContext(), super.createLabelProvider(rendererContext));
    }

    protected IStatus getStatus(Object element, IRendererContext rendererContext) {
        IProperty property = rendererContext.getPropertyContext().getProperties().getProperty("itarget");
        Object replica = rendererContext.getPropertyContext().getCurrentValue(property);
        if (element instanceof CatalogElementLink) {
            CatalogElementLink link = (CatalogElementLink)element;
            IContext context = (IContext)rendererContext.getPropertyContext().getSource();
            EObject location = LocationHandlerHelper.getInstance((IContext)context).getCurrentLocation(link, context);
            if (location != null) {
                return new Status(1, "  ", "custom location");
            }
            location = LocationHandlerHelper.getInstance((IContext)context).getLocation(link, link.getOrigin(), context);
            if (location == null) {
                EObject defaultLocation = LocationHandlerHelper.getInstance((IContext)context).getDefaultLocation(link, link.getOrigin(), context);
                if (defaultLocation == null) {
                    return new Status(2, "  ", "no location");
                }
                return new Status(1, "  ", "default location");
            }
        }
        return Status.OK_STATUS;
    }

    public void initialize(IProperty property, IRendererContext rendererContext) {
        super.initialize(property, rendererContext);
        rendererContext.getPropertyContext().registerListener((PropertyChangeListener)this, rendererContext.getPropertyContext().getProperties().getProperty("org.polarsys.capella.common.re.selection"));
    }

    protected void reloadInput(IProperty property, IRendererContext propertyContext) {
        super.reloadInput(property, propertyContext);
    }

    public boolean reloadInputRequired(Object input, Object input2) {
        return input2 == null || !input.equals(input2);
    }

    public void updatedValue(IProperty property, IRendererContext context, Object newValue) {
        if (this.isDisposed()) {
            return;
        }
        super.updatedValue(property, context, newValue);
        this.getViewer().getClientViewer().refresh();
    }

    public void selectionChange(IStructuredSelection selection, IRendererContext context) {
        super.selectionChange(selection, context);
    }

    public void update(PropertyChangedEvent event) {
        if (this.isDisposed()) {
            return;
        }
        if ("org.polarsys.capella.common.re.selection".equals(event.getProperty().getId())) {
            List initialSelection = ((IStructuredSelection)this.getViewer().getClientViewer().getSelection()).toList();
            ArrayList selection = new ArrayList(initialSelection);
            ArrayList list = new ArrayList();
            IContext context = (IContext)event.getPropertyContext().getSource();
            IProperty property = event.getPropertyContext().getProperties().getProperty("itarget");
            Object replica = event.getPropertyContext().getCurrentValue(property);
            for (Object item : (List)event.getPropertyContext().getCurrentValue(event.getPropertyContext().getProperties().getProperty("org.polarsys.capella.common.re.selection"))) {
                if (!(item instanceof CatalogElementLink)) {
                    list.add(item);
                    continue;
                }
                boolean isAdded = false;
                for (CatalogElementLink link : ReplicableElementExt.getReferencingLinks((EObject)((CatalogElementLink)item).getTarget())) {
                    if (!ReplicableElementHandlerHelper.getInstance((IContext)context).getElementsLinks((CatalogElement)replica).contains(link) || ContextScopeHandlerHelper.getInstance((IContext)context).contains("CREATED_LINKS", (EObject)link, context)) continue;
                    list.add(((CatalogElementLink)item).getTarget());
                    isAdded = true;
                    break;
                }
                if (isAdded) continue;
                list.add(item);
            }
            selection.removeAll(list);
            if (initialSelection.isEmpty() || !selection.isEmpty()) {
                this.getViewer().getClientViewer().setSelection((ISelection)new StructuredSelection(list), true);
            }
        } else if ("targetName".equals(event.getProperty().getId())) {
            this.getViewer().getClientViewer().refresh();
        } else if ("suffix".equals(event.getProperty().getId())) {
            this.getViewer().getClientViewer().refresh();
        }
    }
}

