/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.ui.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.common.flexibility.properties.PropertyChangeListener;
import org.polarsys.capella.common.flexibility.properties.PropertyChangedEvent;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.wizards.renderer.EditListRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.CatalogElementPkg;
import org.polarsys.capella.common.re.handlers.location.LocationHandlerHelper;
import org.polarsys.capella.common.re.handlers.replicable.ReplicableElementHandlerHelper;
import org.polarsys.capella.common.re.ui.renderers.NameCellModifier;
import org.polarsys.capella.common.re.ui.renderers.ReplicaLabelProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.ListData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ReplicaContentRenderer
extends EditListRenderer
implements PropertyChangeListener {
    protected void createTreeViewer(Composite parent, IRendererContext context) {
        super.createTreeViewer(parent, context);
        TreeViewer viewer = this.getViewer().getClientViewer();
        viewer.setColumnProperties(new String[]{"name"});
        viewer.setCellModifier((ICellModifier)new NameCellModifier((Viewer)viewer, context));
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)viewer.getTree())});
        TreeViewerFocusCellManager manager = new TreeViewerFocusCellManager(viewer, new FocusCellHighlighter((ColumnViewer)viewer){});
        TreeViewerEditor.create((TreeViewer)viewer, (SWTFocusCellManager)manager, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 1 && event.keyCode == 0x100000B;
            }
        }, (int)32);
    }

    protected int getExpandLevel() {
        return -1;
    }

    protected IContentProvider createContentProvider(IRendererContext context) {
        return new DataContentProvider(){};
    }

    protected Object createMainLayoutData() {
        GridData layoutData = new GridData(1040);
        layoutData.minimumWidth = 250;
        layoutData.minimumHeight = 400;
        return layoutData;
    }

    protected void doubleClicked(ISelection doubleClickedElement, IRendererContext rendererContext) {
        super.doubleClicked(doubleClickedElement, rendererContext);
        IProperty property = rendererContext.getPropertyContext().getProperties().getProperty("org.polarsys.capella.common.re.selection");
        rendererContext.getPropertyContext().setCurrentValue(property, (Object)((IStructuredSelection)doubleClickedElement).toList());
    }

    public void performRender(Composite parent, IRendererContext rendererContext) {
        super.performRender(parent, rendererContext);
        int ops = 3;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.getViewer().getClientViewer().addDragSupport(ops, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(ReplicaContentRenderer.this.getViewer().getClientViewer().getSelection());
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    protected String getToolbarLocation() {
        return "toolbar:org.polarsys.capella.common.re.createReplica.content";
    }

    protected String getPopupLocation() {
        return "popup:org.polarsys.capella.common.re.createReplica.content";
    }

    protected Object createInput(IProperty property, final IRendererContext context) {
        Object value = context.getPropertyContext().getCurrentValue(property);
        if (value != null && value instanceof Collection) {
            HashSet<EObject> scopeElements = new HashSet<EObject>((Collection)value);
            if (!scopeElements.isEmpty()) {
                IProperty prop = context.getPropertyContext().getProperties().getProperty("itarget");
                Object replica = context.getPropertyContext().getCurrentValue(prop);
                scopeElements.add((EObject)replica);
            }
            TreeData data = new TreeData(scopeElements, null){

                protected Object doGetParent(Object element) {
                    if (element instanceof CatalogElement) {
                        return null;
                    }
                    if (element instanceof CatalogElementLink) {
                        CatalogElementLink link = (CatalogElementLink)element;
                        IContext ctx = (IContext)context.getPropertyContext().getSource();
                        EObject location = LocationHandlerHelper.getInstance((IContext)ctx).getCurrentLocation(link, ctx);
                        if (location != null && location instanceof CatalogElementLink) {
                            return location;
                        }
                        location = LocationHandlerHelper.getInstance((IContext)ctx).getLocation(link, link.getOrigin(), ctx);
                        if (location != null && location instanceof CatalogElementLink) {
                            return location;
                        }
                        IProperty property = context.getPropertyContext().getProperties().getProperty("itarget");
                        Object replica = context.getPropertyContext().getCurrentValue(property);
                        if (!(location instanceof CatalogElementLink) && !(location instanceof CatalogElementPkg)) {
                            for (CatalogElementLink link2 : ReplicableElementHandlerHelper.getInstance((IContext)ctx).getAllElementsLinks((CatalogElement)replica)) {
                                if (!link2.getTarget().equals(location)) continue;
                                return link2;
                            }
                        }
                        return replica;
                    }
                    return super.doGetParent(element);
                }
            };
            return data;
        }
        return new ListData(Collections.emptyList(), (Object)context.getPropertyContext());
    }

    protected IStatus getStatus(Object element, IRendererContext context) {
        if (element instanceof CatalogElementLink) {
            CatalogElementLink link = (CatalogElementLink)element;
            IContext ctx = (IContext)context.getPropertyContext().getSource();
            IProperty property = context.getPropertyContext().getProperties().getProperty("itarget");
            Object replica = context.getPropertyContext().getCurrentValue(property);
            if (!replica.equals(link.getSource())) {
                return new Status(0, "  ", "custom location");
            }
            EObject location = LocationHandlerHelper.getInstance((IContext)ctx).getCurrentLocation((CatalogElementLink)element, ctx);
            if (location != null) {
                return new Status(1, "  ", "custom location");
            }
            location = LocationHandlerHelper.getInstance((IContext)ctx).getLocation(link, link.getOrigin(), ctx);
            if (location == null) {
                EObject defaultLocation = LocationHandlerHelper.getInstance((IContext)ctx).getDefaultLocation(link, link.getOrigin(), ctx);
                Object value = context.getPropertyContext().getCurrentValue(context.getPropertyContext().getProperties().getProperty("useDefaultLocation"));
                if (Boolean.FALSE.equals(value) || defaultLocation == null) {
                    return new Status(2, "  ", "no location");
                }
                return new Status(1, "  ", "default location");
            }
        }
        return Status.OK_STATUS;
    }

    protected ILabelProvider createLabelProvider(IRendererContext rendererContext) {
        return new ReplicaLabelProvider(rendererContext.getPropertyContext(), super.createLabelProvider(rendererContext));
    }

    public boolean reloadInputRequired(Object input, Object input2) {
        TreeData data1 = (TreeData)input;
        TreeData data2 = (TreeData)input2;
        if (data1 == null || data2 == null) {
            return true;
        }
        ArrayList valid = new ArrayList(data1.getValidElements());
        ArrayList valid2 = new ArrayList(data2.getValidElements());
        valid.removeAll(valid2);
        return !valid.isEmpty();
    }

    public void updatedValue(IProperty property, IRendererContext context, Object newValue) {
        if (!this.isDisposed()) {
            super.updatedValue(property, context, newValue);
            this.getViewer().getClientViewer().refresh();
        }
    }

    public void initialize(IProperty property, IRendererContext rendererContext) {
        super.initialize(property, rendererContext);
        rendererContext.getPropertyContext().registerListener((PropertyChangeListener)this, rendererContext.getPropertyContext().getProperties().getProperty("org.polarsys.capella.common.re.selection"));
        rendererContext.getPropertyContext().registerListener((PropertyChangeListener)this, rendererContext.getPropertyContext().getProperties().getProperty("targetName"));
        rendererContext.getPropertyContext().registerListener((PropertyChangeListener)this, rendererContext.getPropertyContext().getProperties().getProperty("suffix"));
    }

    public void selectionChange(IStructuredSelection selection, IRendererContext context) {
        super.selectionChange(selection, context);
    }

    public void update(PropertyChangedEvent event) {
        if (this.isDisposed()) {
            return;
        }
        if ("org.polarsys.capella.common.re.selection".equals(event.getProperty().getId())) {
            List initialSelection = ((IStructuredSelection)this.getViewer().getClientViewer().getSelection()).toList();
            ArrayList selection = new ArrayList(initialSelection);
            List list = (List)event.getPropertyContext().getCurrentValue(event.getPropertyContext().getProperties().getProperty("org.polarsys.capella.common.re.selection"));
            selection.removeAll(list);
            if (initialSelection.isEmpty() || !selection.isEmpty()) {
                this.getViewer().getClientViewer().setSelection((ISelection)new StructuredSelection(list), true);
            }
        } else if ("targetName".equals(event.getProperty().getId())) {
            this.getViewer().getClientViewer().refresh();
        } else if ("suffix".equals(event.getProperty().getId())) {
            this.getViewer().getClientViewer().refresh();
        }
    }
}

