/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.ui.subcommands.handlers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.flexibility.properties.loader.PropertiesLoader;
import org.polarsys.capella.common.flexibility.properties.property.PropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.wizards.loader.RenderersLoader;
import org.polarsys.capella.common.flexibility.wizards.renderer.RendererContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRenderers;
import org.polarsys.capella.common.flexibility.wizards.ui.FlatPropertyWizard;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyDialog;
import org.polarsys.capella.common.flexibility.wizards.ui.util.ExecutionEventUtil;
import org.polarsys.capella.common.re.ui.subcommands.handlers.SubCommandHandler;

public class SelectionCommandHandler
extends SubCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = this.getSelection(event);
        if (selection != null && selection instanceof IStructuredSelection) {
            String scope;
            IRendererContext context = ExecutionEventUtil.getRendererContext((ExecutionEvent)event);
            String propertyId = scope = this.getScope();
            if (scope == null || scope.isEmpty()) {
                return null;
            }
            IProperties delegatedProperties = new PropertiesLoader().getProperties(scope);
            Object source = this.getPropertySource(selection, context);
            PropertyContext delegatedContext = new PropertyContext(delegatedProperties, source);
            final IProperty delegatedProperty = delegatedProperties.getProperty(propertyId);
            IRenderers delegatedRenderers = new RenderersLoader().getRenderers(delegatedContext.getProperties());
            RendererContext delegatedRendererContext = new RendererContext(delegatedRenderers, (IPropertyContext)delegatedContext);
            delegatedContext.setCurrentValue(delegatedProperty, delegatedContext.getCurrentValue(delegatedProperty));
            FlatPropertyWizard wizard = new FlatPropertyWizard((IPropertyContext)delegatedContext, (IRendererContext)delegatedRendererContext){

                protected String getTitle() {
                    return delegatedProperty.getName();
                }

                protected String getDescription() {
                    return delegatedProperty.getDescription();
                }
            };
            PropertyDialog dialog = new PropertyDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
            dialog.setHelpAvailable(false);
            dialog.create();
            int result = dialog.open();
            if (result == 0) {
                IProperty property = context.getPropertyContext().getProperties().getProperty("source.scopeElements");
                Object currentValue = delegatedContext.getCurrentValue(delegatedProperty);
                Collection values = (Collection)context.getPropertyContext().getCurrentValue(property);
                this.fillValue(values, (Collection)currentValue);
                context.getPropertyContext().setCurrentValue(property, (Object)values);
            }
        }
        return null;
    }

    protected void fillValue(Collection values, Collection currentValue) {
        values.addAll(currentValue);
    }

    protected Object getPropertySource(ISelection selection, IRendererContext context) {
        ArrayList<IPropertyContext> result = new ArrayList<IPropertyContext>();
        if (selection != null) {
            result.addAll(((IStructuredSelection)selection).toList());
        }
        result.add(context.getPropertyContext());
        result.addAll(context.getPropertyContext().getSourceAsList());
        return result;
    }

    protected String getScope() {
        return "";
    }
}

