/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.services.behaviors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.polarsys.capella.common.ui.toolkit.services.behaviors.IInputBehavior;

public abstract class RegExpInputBehavior
implements IInputBehavior {
    private Pattern pattern = null;

    protected RegExpInputBehavior(String regularExpression) {
        this.pattern = Pattern.compile(regularExpression);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String format(String input) {
        if (this.isValid(input)) {
            return this.doFormatText(input);
        }
        return input;
    }

    protected String doFormatText(String input) {
        return input;
    }

    public boolean isValid(String value) {
        boolean isValid = true;
        if (value != null && value.length() != 0) {
            Matcher matcher = this.pattern.matcher(value);
            isValid = matcher.matches();
        }
        return isValid;
    }
}

