/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.services.validators;

import org.polarsys.capella.common.ui.toolkit.services.validators.RegExpValidator;

public abstract class RegExpValidatorFactory {
    private final String _id;
    public static final RegExpValidatorFactory ONLY_DIGITS = new RegExpValidatorFactory("onlyDigits"){

        @Override
        public RegExpValidator create(String errorMessage, int style) {
            return new RegExpValidator(errorMessage, "\\d*|\\*", style);
        }
    };
    public static final RegExpValidatorFactory ONLY_LOWER_CASE = new RegExpValidatorFactory("onlyLowerCase"){

        @Override
        public RegExpValidator create(String errorMessage, int style) {
            return new RegExpValidator(errorMessage, "\\p{Lower}", style);
        }
    };
    public static final RegExpValidatorFactory ONLY_UPPER_CASE = new RegExpValidatorFactory("onlyUpperCase"){

        @Override
        public RegExpValidator create(String errorMessage, int style) {
            return new RegExpValidator(errorMessage, "\\{Upper}", style);
        }
    };
    public static final RegExpValidatorFactory NOT_NUMERIC_START = new RegExpValidatorFactory("notNumericStart"){

        @Override
        public RegExpValidator create(String errorMessage, int style) {
            return new RegExpValidator(errorMessage, "\\D+(.| )+", style);
        }
    };
    public static final RegExpValidatorFactory NO_PUNCTUATION = new RegExpValidatorFactory("noPunctuation"){

        @Override
        public RegExpValidator create(String errorMessage, int style) {
            return new RegExpValidator(errorMessage, "[^\\p{Punct}]*", style);
        }
    };
    public static final RegExpValidatorFactory NO_SPACE = new RegExpValidatorFactory("noSpace"){

        @Override
        public RegExpValidator create(String errorMessage, int style) {
            return new RegExpValidator(errorMessage, "[^\\s]*", style);
        }
    };
    public static final RegExpValidatorFactory IP_DIGIT = new RegExpValidatorFactory("ipDigit"){

        @Override
        public RegExpValidator create(String errorMessage, int style) {
            return new RegExpValidator(errorMessage, "[1]{0,1}\\d{0,2}|[2][0-5]{0,2}", style);
        }
    };
    public static final RegExpValidatorFactory NOT_EMPTY = new RegExpValidatorFactory("notEmpty"){

        @Override
        public RegExpValidator create(String errorMessage, int style) {
            return new RegExpValidator(errorMessage, ".+", 0);
        }
    };

    protected RegExpValidatorFactory(String validatorId) {
        this._id = validatorId;
    }

    public abstract RegExpValidator create(String var1, int var2);

    public String getId() {
        return this._id;
    }
}

