/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.releng;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.ui.internal.wizards.datatransfer.ZipFileExporter;

public class PublishExamplesTask
implements ITaskProduction {
    private static final String FEATURE_XML = "feature.xml";
    private static final String OUTPUT_FOLDER = "outputFolder";
    private static final String FEATURE_NAME = "featureName";
    private static final String IMPORTER_NAME = "importerName";

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String featureName = System.getProperty(FEATURE_NAME);
        String outputFolder = System.getProperty(OUTPUT_FOLDER);
        String importerName = System.getProperty(IMPORTER_NAME);
        System.out.println("Will export plugins of feature " + featureName + " to folder " + outputFolder);
        this.publishFeature(featureName, outputFolder, importerName);
    }

    protected void publishFeature(String featureName, String outputFolder, String importerName) {
        this.trace("Will create " + outputFolder);
        new File(outputFolder).mkdirs();
        this.trace("Will get project " + featureName);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject featureProject = workspaceRoot.getProject(featureName);
        this.trace("project " + featureName + " " + (featureProject.exists() ? " exists" : " doesn't exist"));
        if (!featureProject.exists()) {
            featureName = featureName.replace('-', '.');
            this.trace("Will get project " + featureName);
            featureProject = workspaceRoot.getProject(featureName);
            this.trace("project " + featureName + " " + (featureProject.exists() ? " exists" : " doesn't exist"));
        }
        this.trace("Will get file feature.xml");
        IFile featureFile = featureProject.getFile(FEATURE_XML);
        this.trace("file " + featureFile + " " + (featureFile.exists() ? " exists" : " doesn't exist"));
        this.trace("Will load featureModel");
        WorkspaceFeatureModel featureModel = new WorkspaceFeatureModel(featureFile);
        featureModel.load();
        this.trace("featureModel loaded");
        ArrayList<IProject> projects = new ArrayList<IProject>();
        this.collectProjects(workspaceRoot, featureModel.getFeature(), projects);
        if (importerName != null) {
            this.emptyImporterZipFolder(importerName);
        }
        for (IProject project : projects) {
            ArrayList<IProject> oneProjectList = new ArrayList<IProject>();
            oneProjectList.add(project);
            String zipName = String.valueOf(project.getName()) + ".zip";
            String zipPath = String.valueOf(outputFolder) + "/" + zipName;
            this.zipProjects(oneProjectList, featureFile, zipName, zipPath);
            this.addZipToImporterProject(importerName, zipPath, zipName);
        }
        if (projects.size() > 1) {
            this.zipProjects(projects, featureFile, "complete examples zip", String.valueOf(outputFolder) + "/all.zip");
        }
    }

    private void collectProjects(IWorkspaceRoot workspaceRoot, IFeature feature, ArrayList<IProject> projects) {
        IFeatureChild[] iFeatureChildArray = feature.getIncludedFeatures();
        int n = iFeatureChildArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureChild child = iFeatureChildArray[n2];
            IFeature childFeature = ((FeatureChild)child).getReferencedFeature();
            this.trace("Contains feature " + childFeature);
            this.collectProjects(workspaceRoot, childFeature, projects);
            ++n2;
        }
        iFeatureChildArray = feature.getPlugins();
        n = iFeatureChildArray.length;
        n2 = 0;
        while (n2 < n) {
            IFeatureChild featurePlugin = iFeatureChildArray[n2];
            this.trace("Will get project " + featurePlugin.getId());
            IProject pluginProject = workspaceRoot.getProject(featurePlugin.getId());
            projects.add(pluginProject);
            ++n2;
        }
    }

    private void emptyImporterZipFolder(String importerName) {
        IFolder importerZipsFolder = this.getImporterZipsFolder(importerName);
        this.trace("Will empty folder " + importerZipsFolder.getRawLocation().toString());
        try {
            ArrayList resourceList = new ArrayList();
            importerZipsFolder.accept((IResourceVisitor)new ProjectVisitor(resourceList));
            for (IFile iFile : resourceList) {
                this.trace("Will delete file " + iFile.getRawLocation().toString());
                iFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            new RuntimeException("Cannot empty folder " + importerZipsFolder.getRawLocation().toString(), e).printStackTrace();
        }
    }

    private void addZipToImporterProject(String importerName, String zipPath, String zipName) {
        block22: {
            if (importerName == null) {
                return;
            }
            IFolder folder = this.getImporterZipsFolder(importerName);
            File sourceFile = new File(zipPath);
            File destinationFile = new File(folder.getRawLocation().toFile(), zipName);
            this.trace("Will copy " + sourceFile.getAbsolutePath() + " to " + destinationFile.getAbsolutePath());
            BufferedInputStream inputStream = null;
            FilterOutputStream outputStream = null;
            try {
                try {
                    int len;
                    inputStream = new BufferedInputStream(new FileInputStream(sourceFile));
                    outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
                    byte[] buf = new byte[1024];
                    while ((len = inputStream.read(buf)) > 0) {
                        ((BufferedOutputStream)outputStream).write(buf, 0, len);
                    }
                    inputStream.close();
                    outputStream.close();
                    folder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    new RuntimeException("Cannot copy " + sourceFile.getAbsolutePath() + " to " + destinationFile.getAbsolutePath(), e).printStackTrace();
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (outputStream == null) break block22;
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private IFolder getImporterZipsFolder(String importerName) {
        IProject importerProject = ResourcesPlugin.getWorkspace().getRoot().getProject(importerName);
        return importerProject.getFolder("zips");
    }

    private void zipProjects(ArrayList<IProject> projects, IFile featureFile, String zipName, String zipPath) {
        ZipFileExporter fileExporter = null;
        try {
            this.trace("Will publish zip " + zipPath);
            fileExporter = new ZipFileExporter(zipPath, true, true);
            ArrayList resourceList = new ArrayList();
            this.trace("Will visit project");
            for (IProject project : projects) {
                project.accept((IResourceVisitor)new ProjectVisitor(resourceList));
            }
            this.trace("Will write resources");
            for (IFile resource : resourceList) {
                fileExporter.write(resource, resource.getFullPath().toString().substring(1));
            }
            this.trace("Will finish");
            fileExporter.finished();
            System.out.println(String.valueOf(zipName) + " published");
        }
        catch (Exception e) {
            try {
                fileExporter.write(featureFile, FEATURE_XML);
                fileExporter.finished();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new File(zipPath).delete();
            new RuntimeException("Cannot publish " + zipName, e).printStackTrace();
        }
    }

    private void trace(String string) {
        System.out.println(string);
    }

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    private final class ProjectVisitor
    implements IResourceVisitor {
        private final ArrayList<IFile> resourceList;

        private ProjectVisitor(ArrayList<IFile> resourceList) {
            this.resourceList = resourceList;
        }

        public boolean visit(IResource resource) {
            if (".svn".equals(resource.getName())) {
                return false;
            }
            if (resource.getType() == 1) {
                System.out.println("Add file: " + resource.getName());
                this.resourceList.add((IFile)resource);
            }
            return true;
        }
    }
}

