/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.releng.sonar;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.model.pattern.Node;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.pattern.execution.InternalPatternContext;
import org.eclipse.egf.pattern.execution.OutputManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;

public class ProjectPattern {
    protected IProject project;

    public void generate(Object argument) throws Exception {
        InternalPatternContext ctx = (InternalPatternContext)argument;
        Object paramDesc = null;
        Object queryCtx = null;
        Node.Container currentNode = ctx.getNode();
        List projectList = null;
        for (Object projectParameter : projectList) {
            this.project = (IProject)projectParameter;
            if (!this.preCondition((PatternContext)ctx)) continue;
            ctx.setNode(new Node.Container(currentNode, this.getClass()));
            this.orchestration((PatternContext)argument);
        }
        if (ctx.useReporter()) {
            ctx.getReporter().executionFinished(OutputManager.computeExecutionOutput((PatternContext)ctx), (PatternContext)ctx);
        }
    }

    public String orchestration(PatternContext ctx) throws Exception {
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        Node.Container currentNode = ictx.getNode();
        this.method_body(new StringBuffer(), (PatternContext)ictx);
        ictx.setNode(currentNode);
        if (ictx.useReporter()) {
            HashMap<String, IProject> parameterValues = new HashMap<String, IProject>();
            parameterValues.put("project", this.project);
            String outputWithCallBack = OutputManager.computeLoopOutput((PatternContext)ictx);
            String loop = OutputManager.computeLoopOutputWithoutCallback((PatternContext)ictx);
            ictx.getReporter().loopFinished(loop, outputWithCallBack, (PatternContext)ictx, parameterValues);
        }
        return null;
    }

    protected void method_body(StringBuffer out, PatternContext ctx) throws Exception {
        IJavaProject proj = JavaCore.create((IProject)this.project);
        StringBuilder prop = (StringBuilder)ctx.getValue("properties");
        List modules = (List)ctx.getValue("modules");
        String name = this.project.getName();
        IPath location = this.project.getLocation();
        while (!location.segment(0).equals("git")) {
            if ((location = location.removeFirstSegments(1)).segmentCount() != 0) continue;
            return;
        }
        location = new Path("git").append(location.removeFirstSegments(2));
        String sources = "";
        IPackageFragmentRoot[] iPackageFragmentRootArray = proj.getAllPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1 && root.getParent().equals(proj) && "src".equals(root.getElementName())) {
                sources = "src";
            }
            ++n2;
        }
        if (!sources.isEmpty()) {
            prop.append(String.valueOf(name) + ".sonar.projectName=" + name).append("\n");
            prop.append(String.valueOf(name) + ".sonar.projectBaseDir=" + location).append("\n");
            modules.add(name);
        }
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        new Node.DataLeaf(ictx.getNode(), this.getClass(), "body", out.toString());
    }

    public boolean preCondition(PatternContext ctx) throws Exception {
        return this.project.isOpen() && this.project.hasNature("org.eclipse.jdt.core.javanature");
    }

    public void set_project(IProject project) {
        this.project = project;
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("project", this.project);
        return parameters;
    }
}

