/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.capella.core.commands.preferences.internalization.l10n.CustomPreferencesMessages;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferences;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferencesManager;
import org.polarsys.capella.core.commands.preferences.service.IItemDescriptor;
import org.polarsys.capella.core.commands.preferences.service.ItemChangeEvent;
import org.polarsys.capella.core.commands.preferences.service.ItemChangeEventType;
import org.polarsys.capella.core.commands.preferences.service.PreferencesItemsRegistry;
import org.polarsys.capella.core.preferences.Activator;

public abstract class AbstractItemDescriptor
implements IItemDescriptor {
    private final Set<CategoryPreferences> categories = new HashSet<CategoryPreferences>();
    private final Set<CategoryPreferences> unmodCategories = Collections.unmodifiableSet(this.categories);
    private Throwable exception;
    private static final String ITEM_INCOMPLETE = CustomPreferencesMessages.rule_incomplete_ERROR_;
    private boolean enabled = true;

    protected AbstractItemDescriptor() {
        this.categories.add(CategoryPreferencesManager.getInstance().getDefaultCategory());
    }

    public final boolean isError() {
        return this.getException() != null;
    }

    @Override
    public final Throwable getException() {
        return this.exception;
    }

    @Override
    public final void setError(Throwable exception) {
        assert (exception != null);
        this.exception = exception;
    }

    @Override
    public final boolean isEnabled() {
        return !this.isError() && this.enabled;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        if (!enabled) {
            enabled = this.isMandatory();
        }
        if (this.enabled != enabled) {
            this.enabled = enabled;
            ItemChangeEventType eventType = this.enabled ? ItemChangeEventType.ENABLED : ItemChangeEventType.DISABLED;
            PreferencesItemsRegistry.getInstance().broadcastItemChangeEvent(new ItemChangeEvent(this, eventType));
        }
    }

    private boolean isMandatory() {
        boolean result = false;
        Iterator<CategoryPreferences> iter = this.getCategories().iterator();
        while (!result && iter.hasNext()) {
            result = iter.next().isMandatory();
        }
        return result;
    }

    @Override
    public Set<CategoryPreferences> getCategories() {
        return this.unmodCategories;
    }

    @Override
    public void addCategory(CategoryPreferences category) {
        CategoryPreferences defaultCategory = CategoryPreferencesManager.getInstance().getDefaultCategory();
        if (category.equals(defaultCategory)) {
            throw new IllegalArgumentException();
        }
        if (this.categories.contains(defaultCategory)) {
            this.categories.remove(defaultCategory);
            PreferencesItemsRegistry.getInstance().broadcastItemChangeEvent(new ItemChangeEvent(this, ItemChangeEventType.REMOVED_CATEGORY, defaultCategory));
        }
        if (!this.categories.contains(category)) {
            this.categories.add(category);
            category.addItem(this);
            PreferencesItemsRegistry.getInstance().broadcastItemChangeEvent(new ItemChangeEvent(this, ItemChangeEventType.ADDED_CATEGORY, category));
        }
    }

    @Override
    public void removeCategory(CategoryPreferences category) {
        if (this.categories.contains(category)) {
            this.categories.remove(category);
            category.removeItem(this);
            PreferencesItemsRegistry.getInstance().broadcastItemChangeEvent(new ItemChangeEvent(this, ItemChangeEventType.REMOVED_CATEGORY, category));
        }
        if (this.categories.isEmpty()) {
            CategoryPreferences defaultCategory = CategoryPreferencesManager.getInstance().getDefaultCategory();
            this.categories.add(defaultCategory);
            PreferencesItemsRegistry.getInstance().broadcastItemChangeEvent(new ItemChangeEvent(this, ItemChangeEventType.ADDED_CATEGORY, defaultCategory));
        }
    }

    public final IItemDescriptor getDescriptor() {
        return this;
    }

    public int hashCode() {
        return this.getId() == null ? 0 : this.getId().hashCode();
    }

    protected void assertNotNull(Object value, String missingItem) throws CoreException {
        if (value == null) {
            CoreException ce = new CoreException((IStatus)new Status(4, "org.polarsys.capella.core.preferences", 70, Activator.getMessage(ITEM_INCOMPLETE, missingItem), null));
            throw ce;
        }
    }

    public boolean equals(Object other) {
        return other instanceof IItemDescriptor && ((IItemDescriptor)other).getId().equals(this.getId());
    }

    public String toString() {
        StringBuffer result = new StringBuffer(64);
        if (!this.isEnabled()) {
            result.append("Disabled ");
        }
        result.append("Command[id=");
        result.append(this.getId());
        result.append(']');
        return result.toString();
    }
}

