/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.preferences;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.polarsys.capella.core.commands.preferences.internalization.l10n.CustomPreferencesMessages;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferences;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferencesManager;
import org.polarsys.capella.core.commands.preferences.properties.PreferencesHandler;
import org.polarsys.capella.core.commands.preferences.service.PreferencesItemsRegistry;
import org.polarsys.capella.core.commands.preferences.service.PropertyStore;
import org.polarsys.capella.core.commands.preferences.service.ScopedCapellaPreferencesStore;
import org.polarsys.capella.core.commands.preferences.util.PreferencesExtensionHandler;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;

public class Activator
extends AbstractUIPlugin {
    private ExtensionTracker extensionTracker = new ExtensionTracker();
    private static final String LIST_SEPARATOR = CustomPreferencesMessages.list_separator;
    private static final String LIST_PREFIX = CustomPreferencesMessages.list_prefix;
    private static final String LIST_SUFFIX = CustomPreferencesMessages.list_suffix;
    private static final String DEFAULT_LIST_SEPARATOR = ", ";
    private static final String DEFAULT_LIST_PREFIX = "";
    private static final String DEFAULT_LIST_SUFFIX = "";
    public static final String PREFERENCES_PROVIDERS_EXT_P_NAME = "capellaPreferences";
    public static final String PLUGIN_ID = "org.polarsys.capella.core.preferences";
    private static Activator plugin;
    private static final String ICONS = "icons/";
    private PreferencesExtensionHandler extensionHandler;
    public static Map<IResource, IPreferenceStore> propertiesStore;
    IPreferenceStore preferenceStore = null;

    static {
        propertiesStore = new HashMap<IResource, IPreferenceStore>();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.extensionTracker = new ExtensionTracker();
        this.extensionHandler = new PreferencesExtensionHandler();
        plugin = this;
        PreferencesItemsRegistry.getInstance().getAllDescriptors();
        this.initializeExtensionsPointProvider();
        CategoryPreferencesManager.getInstance().loadUserProfile();
        PreferencesHandler.initializePreferenceCommands();
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        }
        return this.preferenceStore;
    }

    public IPreferenceStore getPropertyPreferenceStore(IResource project) {
        if (propertiesStore.get(project) != null) {
            return propertiesStore.get(project);
        }
        return propertiesStore.get(project);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.extensionTracker.close();
        this.extensionTracker = null;
    }

    private void initializeExtensionsPointProvider() {
        final CategoryPreferences globalCategory = CategoryPreferences.GLOBAL_NAMESPACE;
        IExtensionChangeHandler extensionHandler = new IExtensionChangeHandler(){

            public void addExtension(IExtensionTracker tracker, IExtension extension) {
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement next = iConfigurationElementArray[n2];
                    if (next.getName().equals("category")) {
                        CategoryPreferencesManager.getInstance().loadCategories(globalCategory, next);
                    } else if (next.getName().equals("projectNature")) {
                        CategoryPreferencesManager.getInstance().loadProjectsNature(globalCategory, next);
                    }
                    ++n2;
                }
            }

            public void removeExtension(IExtension extension, Object[] objects) {
            }
        };
        this.extensionTracker.registerHandler(extensionHandler, null);
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, PREFERENCES_PROVIDERS_EXT_P_NAME);
        IExtensionTracker extTracker = Activator.getExtensionTracker();
        if (extTracker != null) {
            extTracker.registerHandler(extensionHandler, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)extPoint));
            IExtension[] iExtensionArray = extPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                extensionHandler.addExtension(extTracker, extension);
                ++n2;
            }
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static IExtensionTracker getExtensionTracker() {
        return plugin == null ? null : Activator.plugin.extensionTracker;
    }

    public void loadCategories() {
        if (Platform.isRunning()) {
            IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, PREFERENCES_PROVIDERS_EXT_P_NAME);
            IExtensionTracker extTracker = Activator.getExtensionTracker();
            if (extTracker != null) {
                extTracker.registerHandler((IExtensionChangeHandler)this.extensionHandler, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)extPoint));
                IExtension[] iExtensionArray = extPoint.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    this.extensionHandler.addExtension(extTracker, extension);
                    ++n2;
                }
            }
        }
    }

    public static ImageDescriptor getImageDescriptor(String imageFile) {
        URL fullPath = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(ICONS + imageFile), null);
        if (fullPath != null) {
            return ImageDescriptor.createFromURL((URL)fullPath);
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public static String getMessage(String messagePattern, Object ... args) {
        return Activator.formatMessage(messagePattern, args);
    }

    private static String formatMessage(String messagePattern, Object ... args) {
        try {
            return NLS.bind((String)messagePattern, (Object[])args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return messagePattern;
        }
    }

    public static String formatList(Collection<?> items) {
        switch (items.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return String.valueOf(items.iterator().next());
            }
            case 2: {
                return Activator.formatPair(items);
            }
        }
        return Activator.formatList2(items);
    }

    private static String formatList2(Collection<?> items) {
        Iterator<?> iter = items.iterator();
        int max = items.size() - 1;
        String sep = Activator.getString(LIST_SEPARATOR, DEFAULT_LIST_SEPARATOR);
        StringBuffer result = new StringBuffer(32);
        result.append(Activator.getString(LIST_PREFIX, ""));
        int i = 0;
        while (i <= max) {
            if (i == 1) {
                result.append(Activator.getString(LIST_SEPARATOR, sep));
            } else if (i == max) {
                result.append(Activator.getString(LIST_SEPARATOR, sep));
            } else if (i > 1) {
                result.append(sep);
            }
            result.append(iter.next());
            ++i;
        }
        result.append(Activator.getString(LIST_SUFFIX, ""));
        return result.toString();
    }

    private static String getString(String message, String defaultResult) {
        return message != null ? message : defaultResult;
    }

    private static String formatPair(Collection<?> items) {
        Iterator<?> iter = items.iterator();
        StringBuffer result = new StringBuffer(32);
        result.append(iter.next());
        result.append(Activator.getString(LIST_SEPARATOR, DEFAULT_LIST_SEPARATOR));
        result.append(iter.next());
        return result.toString();
    }

    public void setPropertyStore(IResource iResource, IPreferenceStore propertiesStore) {
        Activator.propertiesStore.put(iResource, propertiesStore);
    }

    public void addProjectsPropertyChangeListener(IPropertyChangeListener capellaCommonNavigator) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (Activator.getDefault().getPropertyPreferenceStore((IResource)project) != null) {
                this.getPropertyPreferenceStore((IResource)project).addPropertyChangeListener(capellaCommonNavigator);
            } else {
                PropertyStore.addToGuestListener(capellaCommonNavigator);
            }
            ++n2;
        }
    }

    public boolean existPropertyStore(PropertyChangeEvent event) {
        IProject project = PreferencesHelper.getSelectedCapellaProject();
        if (!(project == null || event.getSource() != null && event.getSource() instanceof PropertyStore)) {
            ScopedCapellaPreferencesStore.getInstance(PLUGIN_ID);
            return ScopedCapellaPreferencesStore.getValueFromPresistentPropertyStore(project, event.getProperty()) != null;
        }
        return false;
    }
}

