/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.tools.dialogs;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.common.util.MDERichTextHelper;
import org.polarsys.kitalpha.richtext.widget.tools.dialogs.MDEOkCancelDialog;
import org.polarsys.kitalpha.richtext.widget.tools.manager.LinkManager;
import org.polarsys.kitalpha.richtext.widget.tools.messages.Messages;
import org.polarsys.kitalpha.richtext.widget.tools.utils.Tuple;

public class MDEAddLinkDialog
extends MDEOkCancelDialog {
    protected MDERichTextWidget richText;
    protected Text urlText;
    protected String basePath;
    protected Composite composite;
    protected Label urlLabel;
    protected Text urlDisplayNameText;
    protected Label urlDisplayNameLabel;
    protected Combo linkTypeCombo;
    protected Button browseButton;
    protected String linkType;
    protected LinkManager linkManager;

    public MDEAddLinkDialog(Shell parentShell, MDERichTextWidget richText, LinkManager linkManager) {
        super(parentShell);
        this.linkManager = linkManager;
        this.richText = richText;
        this.basePath = MDERichTextHelper.getProjectPath((EObject)richText.getElement());
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 3;
        this.createUrlLabel(composite);
        this.createDisplayTextURL(composite);
        this.createListLinksType(composite);
        this.createBrowserButton(composite);
        String selectedText = this.richText.getSelectedText();
        if (selectedText != null) {
            this.urlDisplayNameText.setText(selectedText);
        }
        super.getShell().setText(Messages.RichTextWidget_Dialog_Add_Link);
        return composite;
    }

    private void createBrowserButton(Composite composite) {
        this.browseButton = new Button(composite, 8);
        this.browseButton.setLayoutData((Object)new GridData());
        this.browseButton.setText(Messages.RichTextWidget_Dialog_Add_Link_Browse);
        this.browseButton.setEnabled(false);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Tuple<String, String> path = null;
                path = MDEAddLinkDialog.this.linkManager.getURI(MDEAddLinkDialog.this.linkType, MDEAddLinkDialog.this.basePath, MDEAddLinkDialog.this.richText.getElement());
                if (path != null) {
                    String path2Object = path.getFirst();
                    String objectLabel = path.getSecond();
                    if (path != null && path2Object != null) {
                        MDEAddLinkDialog.this.urlText.setText(path2Object);
                    }
                    MDEAddLinkDialog.this.urlDisplayNameText.setText(objectLabel != null ? objectLabel : "");
                }
            }
        });
        this.browseButton.moveAbove((Control)this.urlDisplayNameLabel);
    }

    private void createListLinksType(Composite composite) {
        this.linkTypeCombo = new Combo(composite, 2056);
        GridData comboGridData = new GridData(768);
        comboGridData.horizontalSpan = 2;
        this.linkTypeCombo.setLayoutData((Object)comboGridData);
        final String[] itemsLinkList = this.linkManager.getAllLinkLabels().toArray(new String[0]);
        this.linkTypeCombo.setItems(itemsLinkList);
        this.linkType = itemsLinkList[0];
        this.linkTypeCombo.setText(this.linkType);
        this.linkTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MDEAddLinkDialog.this.linkType = itemsLinkList[MDEAddLinkDialog.this.linkTypeCombo.getSelectionIndex()];
                MDEAddLinkDialog.this.browseButton.setEnabled(!"URL".equals(MDEAddLinkDialog.this.linkType));
                MDEAddLinkDialog.this.urlLabel.setEnabled("URL".equals(MDEAddLinkDialog.this.linkType) || "File (absolute path)".equals(MDEAddLinkDialog.this.linkType) || "File (project relative path)".equals(MDEAddLinkDialog.this.linkType));
                MDEAddLinkDialog.this.urlText.setEnabled("URL".equals(MDEAddLinkDialog.this.linkType) || "File (absolute path)".equals(MDEAddLinkDialog.this.linkType) || "File (project relative path)".equals(MDEAddLinkDialog.this.linkType));
                if ("URL".equals(MDEAddLinkDialog.this.linkType)) {
                    MDEAddLinkDialog.this.urlDisplayNameText.setText(MDEAddLinkDialog.this.richText.getSelectedText());
                } else {
                    MDEAddLinkDialog.this.urlDisplayNameText.setText("");
                }
                MDEAddLinkDialog.this.urlText.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.linkTypeCombo.moveAbove((Control)this.urlLabel);
    }

    private void createDisplayTextURL(Composite composite) {
        this.urlDisplayNameLabel = new Label(composite, 0);
        this.urlDisplayNameLabel.setText(Messages.RichTextWidget_Dialog_Add_Link_URL_Display);
        this.urlDisplayNameText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(300, -1).applyTo((Control)this.urlDisplayNameText);
        Label linkTypeLabel = new Label(composite, 0);
        linkTypeLabel.setText(Messages.RichTextWidget_Dialog_Add_Link);
        linkTypeLabel.moveAbove((Control)this.urlLabel);
    }

    private void createUrlLabel(Composite composite) {
        this.urlLabel = new Label(composite, 0);
        this.urlLabel.setText("URL");
        this.urlText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(300, -1).applyTo((Control)this.urlText);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MDEAddLinkDialog.this.getOK() != null) {
                    MDEAddLinkDialog.this.getOK().setEnabled(MDEAddLinkDialog.this.urlText.getText().trim().length() > 0);
                }
            }
        });
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        String url = this.urlText.getText();
        if (url != null && url.length() > 0) {
            String urlDisplayName = this.urlDisplayNameText.getText();
            if (urlDisplayName.trim().length() == 0) {
                urlDisplayName = url;
            }
            String encodedURL = this.linkManager.encode(this.linkType, url, urlDisplayName);
            this.richText.insertRawText(encodedURL);
        }
        this.urlText.setText("");
        super.okPressed();
        this.richText.forceFocus();
    }
}

