/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.generation.desc.task;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.portfolio.genchain.generationChain.FeatureAddition;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChainFactory;
import org.eclipse.egf.portfolio.genchain.tools.Activator;
import org.eclipse.egf.portfolio.genchain.tools.ui.actions.BuildApplicationHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.internal.editors.text.WorkspaceOperationRunner;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.ArchitectureFramework;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.Viewpoints;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.AbstractGenerationEvent;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.listener.GenerationAdapter;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.listener.IGenerationListener;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.manager.GenerationEventManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.event.type.ViewpointGenerationEndEvent;

public class CreateGenchainAndPackageAFTask
extends GenerationAdapter
implements ITaskProduction {
    private String projectId;
    private String shortName;
    private int waitFor = 0;
    private boolean packageAF = false;
    private EMFDomain domainModel;
    private IProgressMonitor monitor = new NullProgressMonitor();

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        this.waitFor = (Integer)productionContext.getInputValue((Object)"number.of.viewpoint.to.generate", Integer.class);
        this.monitor = monitor;
        GenerationEventManager.getInstance().addGenerationListener((IGenerationListener)this);
    }

    public void generationEnd(AbstractGenerationEvent event) {
        if (this.waitFor == -1) {
            return;
        }
        if (event instanceof ViewpointGenerationEndEvent) {
            --this.waitFor;
        }
        if (this.waitFor == 0 && this.packageAF) {
            try {
                this.buildAF();
            }
            catch (InvocationException e) {
                e.printStackTrace();
            }
        }
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        this.projectId = (String)productionContext.getInputValue((Object)"af.project.name", String.class);
        this.shortName = (String)productionContext.getInputValue((Object)"af.short.name", String.class);
        this.packageAF = (Boolean)productionContext.getInputValue((Object)"package.af", Boolean.class);
        this.domainModel = (EMFDomain)productionContext.getInputValue((Object)"af.description.model", EMFDomain.class);
        GenerationChain chain = this.createGenerationChain(this.shortName, this.projectId);
        URI uri = URI.createURI((String)("platform:/resource/" + this.projectId + "/" + "models" + "/" + this.shortName + ".generationchain"));
        ResourceSetImpl set = new ResourceSetImpl();
        Resource genchainResource = set.createResource(uri);
        genchainResource.getContents().add((Object)chain);
        try {
            genchainResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new InvocationException((Throwable)e);
        }
        if (this.waitFor == -1) {
            this.buildAF();
        }
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    private void buildAF() throws InvocationException {
        class AfdslOnlyBuildApplicationHelper
        extends BuildApplicationHelper {
            AfdslOnlyBuildApplicationHelper() {
            }

            public void onlyBuild(URI genchainURI) throws CoreException, InterruptedException {
                TargetPlatformResourceSet resourceSet = new TargetPlatformResourceSet();
                this.generationChain = (GenerationChain)resourceSet.getResource(genchainURI, true).getContents().get(0);
                String pluginName = this.getPluginName();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginName);
                if (!project.exists()) {
                    project.create(CreateGenchainAndPackageAFTask.this.monitor);
                    project.refreshLocal(2, CreateGenchainAndPackageAFTask.this.monitor);
                    project.open(CreateGenchainAndPackageAFTask.this.monitor);
                    WorkspaceOperationRunner runner = new WorkspaceOperationRunner();
                    runner.setProgressMonitor(CreateGenchainAndPackageAFTask.this.monitor);
                    try {
                        runner.run(true, false, (IRunnableWithProgress)new ConvertProjectOperation(project, false, false));
                    }
                    catch (Exception e) {
                        throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
                    }
                }
                WorkspaceJob createJob = super.createJob(this.generationChain, false);
                createJob.schedule();
                createJob.join();
                project.refreshLocal(2, CreateGenchainAndPackageAFTask.this.monitor);
                project.build(10, CreateGenchainAndPackageAFTask.this.monitor);
                WorkspaceJob createAfterJob = super.createAfterJob();
                Thread.sleep(2000L);
                createAfterJob.schedule();
            }

            protected String computeFcoreOutputPath(GenerationChain generationChain) {
                return String.valueOf(this.getPluginName()) + this.computeFcoreRelativePath(generationChain);
            }

            private String getPluginName() {
                return String.valueOf(this.generationChain.getFactoryComponentName()) + ".fc";
            }
        }
        AfdslOnlyBuildApplicationHelper onlyBuilder = new AfdslOnlyBuildApplicationHelper();
        try {
            try {
                URI uri = URI.createURI((String)("platform:/resource/" + this.projectId + "/" + "models" + "/" + this.shortName + ".generationchain"));
                onlyBuilder.onlyBuild(uri);
            }
            catch (CoreException e) {
                throw new InvocationException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new InvocationException((Throwable)e);
            }
        }
        finally {
            GenerationEventManager.getInstance().removeGenerationListener((IGenerationListener)this);
        }
    }

    protected GenerationChain createGenerationChain(String shortName, String projectName) {
        GenerationChain genchainRootElement = GenerationChainFactory.eINSTANCE.createGenerationChain();
        genchainRootElement.setName(shortName);
        genchainRootElement.setFactoryComponentName(projectName);
        GenerationChain chain = GenerationChainFactory.eINSTANCE.createGenerationChain();
        chain.setName(shortName);
        genchainRootElement.getElements().add((Object)chain);
        FeatureAddition featureAddition = GenerationChainFactory.eINSTANCE.createFeatureAddition();
        chain.getElements().add((Object)featureAddition);
        Object rootDomainElement = this.domainModel.getContent().get(0);
        if (rootDomainElement != null && rootDomainElement instanceof ArchitectureFramework) {
            ArchitectureFramework af = (ArchitectureFramework)rootDomainElement;
            Viewpoints af_viewpoints = af.getAf_viewpoints();
            for (Viewpoint viewpoint : af_viewpoints.getOwned_viewpoints()) {
                String rootProjectName = VpDslConfigurationHelper.getRootProjectName((Object)viewpoint);
                featureAddition.getAdditions().add((Object)(String.valueOf(rootProjectName) + ".feature"));
            }
        }
        return genchainRootElement;
    }
}

