/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.GenericTrace;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.KeyValue;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.la.ContextInterfaceRealization;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.LogicalArchitectureRealization;
import org.polarsys.capella.core.data.pa.LogicalInterfaceRealization;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.PhysicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;

public class LcToPcProjectionUtils {
    public static final String BREAK_DOWN_PROJECTION_STRATEGY = "BreakDown Strategy";
    public static final String LEAF_PROJECTION_STRATEGY = "Leaf Strategy";

    public static boolean existInterfaceCloneInPA(Interface srcItf_p) {
        EList traceList = srcItf_p.getIncomingTraces();
        for (AbstractTrace trace : traceList) {
            if (!(trace instanceof ContextInterfaceRealization) && !(trace instanceof LogicalInterfaceRealization) || !(trace.getSourceElement() instanceof Interface) || !CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((Interface)trace.getSourceElement()))) continue;
            return true;
        }
        return false;
    }

    public static Interface retrieveTransformedInterfaceInPA(Interface srcItf_p) {
        EList traceList = srcItf_p.getIncomingTraces();
        for (AbstractTrace trace : traceList) {
            if (!(trace instanceof ContextInterfaceRealization) && !(trace instanceof LogicalInterfaceRealization) || !(trace.getSourceElement() instanceof Interface) || !CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((Interface)trace.getSourceElement()))) continue;
            return (Interface)trace.getSourceElement();
        }
        return null;
    }

    public static boolean isBreakDownModel(PhysicalArchitecture pa_p) {
        List allPc = PhysicalArchitectureExt.getAllPhysicalComponents((PhysicalArchitecture)pa_p);
        for (PhysicalComponent pc : allPc) {
            for (Partition partition : pc.getOwnedPartitions()) {
                if (!(partition instanceof Part)) continue;
                EList traceList = partition.getOutgoingTraces();
                for (AbstractTrace abstractTrace : traceList) {
                    if (!(abstractTrace instanceof GenericTrace)) continue;
                    GenericTrace genericTrace = (GenericTrace)abstractTrace;
                    for (KeyValue keyValue : genericTrace.getKeyValuePairs()) {
                        String key = keyValue.getKey();
                        String value = keyValue.getValue();
                        if (!key.equals(BREAK_DOWN_PROJECTION_STRATEGY) || !value.equals(Boolean.TRUE.toString())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isLeafModel(PhysicalArchitecture pa_p) {
        List allPc = PhysicalArchitectureExt.getAllPhysicalComponents((PhysicalArchitecture)pa_p);
        PhysicalComponent pcRoot = null;
        for (PhysicalComponent pc : allPc) {
            if (!PhysicalComponentExt.isPhysicalComponentRoot((EObject)pc)) continue;
            pcRoot = pc;
            break;
        }
        if (pcRoot != null) {
            for (PhysicalComponent pc : allPc) {
                if (!LcToPcProjectionUtils.leafPartExist(pcRoot, pc)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean leafPartExist(PhysicalComponent pcRoot, PhysicalComponent pcCurrent) {
        for (AbstractTrace abstractTrace : pcCurrent.getOutgoingTraces()) {
            Part partLinked;
            if (!(abstractTrace instanceof GenericTrace) || !(abstractTrace.getTargetElement() instanceof Part) || !(partLinked = (Part)abstractTrace.getTargetElement()).eContainer().equals(pcRoot)) continue;
            for (KeyValue keyValue : ((GenericTrace)abstractTrace).getKeyValuePairs()) {
                String key = keyValue.getKey();
                String value = keyValue.getValue();
                if (!key.equals(LEAF_PROJECTION_STRATEGY) || !value.equals(Boolean.TRUE.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static ProjectionStrategy getModelProjectionStrategy(ModelElement modelElement_p) {
        LogicalArchitecture la = null;
        la = modelElement_p instanceof LogicalArchitecture ? (LogicalArchitecture)modelElement_p : (LogicalArchitecture)EcoreUtil2.getFirstContainer((EObject)modelElement_p, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE);
        for (AbstractTrace trace : la.getIncomingTraces()) {
            PhysicalArchitecture pa;
            if (!(trace instanceof LogicalArchitectureRealization) || !(trace.getSourceElement() instanceof PhysicalArchitecture) || (pa = (PhysicalArchitecture)trace.getSourceElement()) == null) continue;
            if (LcToPcProjectionUtils.isBreakDownModel(pa)) {
                return ProjectionStrategy.BREAKDOWN;
            }
            if (!LcToPcProjectionUtils.isLeafModel(pa)) continue;
            return ProjectionStrategy.LEAF;
        }
        return ProjectionStrategy.NONE;
    }

    public static enum ProjectionStrategy {
        LEAF,
        BREAKDOWN,
        NONE;

    }
}

