/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common.rules.fa;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.projection.common.ProjectionMessages;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.handlers.log.LogHelper;
import org.polarsys.capella.core.projection.common.rules.fa.Rule_AbstractFunction;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.helpers.Query;

public class Rule_Function
extends Rule_AbstractFunction {
    private HashMap<AbstractFunction, Integer> map = new HashMap();

    public Rule_Function(EClass source, EClass target) {
        super(source, target);
    }

    public Rule_Function() {
        super(FaPackage.Literals.ABSTRACT_FUNCTION, FaPackage.Literals.ABSTRACT_FUNCTION);
    }

    @Override
    public IStatus transformRequired(EObject element_p, IContext context_p) {
        AbstractFunction sourceElement = (AbstractFunction)element_p;
        if (this.isRootFunction(element_p) || element_p instanceof AbstractFunction && FunctionExt.isLeaf((AbstractFunction)((AbstractFunction)element_p)) || this.getNbUntransitionedSubFunctions(sourceElement, context_p.getTransfo()) > 0) {
            return Status.OK_STATUS;
        }
        return new Status(2, ProjectionMessages.Activity_Transformation, ProjectionMessages.SubFunctionAlreadyTransitioned);
    }

    protected int getNbUntransitionedSubFunctions(AbstractFunction function, ITransfo transfo_p) {
        if (!this.map.containsKey(function)) {
            int nb = 0;
            for (AbstractFunction sub : FunctionExt.getFirstLevelAbstractFunctions((AbstractFunction)function)) {
                boolean isTransform = Query.isElementTransformed((EObject)sub, (ITransfo)transfo_p);
                if (FunctionExt.isLeaf((AbstractFunction)sub) && !isTransform) {
                    ++nb;
                }
                nb += this.getNbUntransitionedSubFunctions(sub, transfo_p);
            }
            this.map.put(function, nb);
            return nb;
        }
        return this.map.get(function);
    }

    @Override
    protected void retrieveGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
        AbstractFunction sourceElement = (AbstractFunction)source_p;
        super.retrieveGoDeep(source_p, result_p, context_p);
        if (this.isRelatedToSource((EObject)sourceElement, context_p)) {
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedFunctions());
            result_p.addAll(FunctionExt.getOwnedFunctionPkgs((AbstractFunction)sourceElement));
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedFunctionalExchanges());
            result_p.addAll((Collection<EObject>)sourceElement.getInputs());
            result_p.addAll((Collection<EObject>)sourceElement.getOutputs());
            result_p.addAll((Collection<EObject>)sourceElement.getOwnedFunctionalChains());
        }
    }

    @Override
    protected EStructuralFeature getTargetContainementFeature(EObject element_p, EObject result_p, EObject container, IContext context_p) {
        if (container instanceof OperationalActivityPkg) {
            return OaPackage.Literals.OPERATIONAL_ACTIVITY_PKG__OWNED_OPERATIONAL_ACTIVITIES;
        }
        if (container instanceof SystemFunctionPkg) {
            return CtxPackage.Literals.SYSTEM_FUNCTION_PKG__OWNED_SYSTEM_FUNCTIONS;
        }
        if (container instanceof LogicalFunctionPkg) {
            return LaPackage.Literals.LOGICAL_FUNCTION_PKG__OWNED_LOGICAL_FUNCTIONS;
        }
        if (container instanceof PhysicalFunctionPkg) {
            return PaPackage.Literals.PHYSICAL_FUNCTION_PKG__OWNED_PHYSICAL_FUNCTIONS;
        }
        if (container instanceof AbstractFunction) {
            return FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTIONS;
        }
        return super.getTargetContainementFeature(element_p, result_p, container, context_p);
    }

    @Override
    protected EObject transformDirectElement(EObject element_p, IContext context_p) {
        AbstractFunction result;
        BlockArchitecture architecture;
        if (this.isRootFunction(element_p) && (architecture = (BlockArchitecture)context_p.get("transfoTargetContainer")) != null && (result = BlockArchitectureExt.getRootFunction((BlockArchitecture)architecture)) != null) {
            LogHelper.getInstance().info(NLS.bind((String)ProjectionMessages.ElementTransitionedToExistingElement, (Object)EObjectLabelProviderHelper.getText((EObject)element_p), (Object)EObjectLabelProviderHelper.getText((EObject)result)), new Object[]{element_p, result}, ProjectionMessages.Activity_Transformation);
            return result;
        }
        return super.transformDirectElement(element_p, context_p);
    }
}

