/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.libraries.policy;

import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.libraries.AccessPolicy;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.policy.Messages;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

public class ResourceAccessPolicyListener
extends ResourceSetListenerImpl {
    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        TransactionalEditingDomain domain = event.getEditingDomain();
        IModel sourceModel = ILibraryManager.INSTANCE.getModel(domain);
        HashSet<IModel> modifiedModels = new HashSet<IModel>();
        for (Notification notification : event.getNotifications()) {
            IModel model;
            Object notifier = notification.getNotifier();
            if (!CapellaResourceHelper.isSemanticElement((Object)notifier) || (model = ILibraryManager.INSTANCE.getModel((EObject)notifier)) == null) continue;
            if (!modifiedModels.contains(model) && sourceModel.getAccess(model) == AccessPolicy.READ_ONLY) {
                Logger.getLogger((String)"Model Management").error((Object)Messages.ResourceAccessPolicyListener_RollbackReadOnly);
                throw new RollbackException((IStatus)new Status(4, "org.polarsys.capella.common.libraries", Messages.ResourceAccessPolicyListener_RollbackReadOnly));
            }
            modifiedModels.add(model);
        }
        return null;
    }
}

