/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.processor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.refinement.processor.UpdateRealizationContributionProcessor;

public class DynamicRealizationContributionProcessor
extends UpdateRealizationContributionProcessor {
    public DynamicRealizationContributionProcessor() {
        super(UpdateRealizationContributionProcessor.Kind.DYNAMIC);
    }

    public DynamicRealizationContributionProcessor(NamedElement context) {
        super(UpdateRealizationContributionProcessor.Kind.DYNAMIC, context);
    }

    public Object getName() {
        return "realization contribution update based on dynamic informations";
    }

    @Override
    protected void updateInvolvements(AbstractCapability currentCapability, EClass target) {
        AbstractCapability updatedCapability = null;
        ArrayList<Component> involvedCpntSet = new ArrayList<Component>();
        for (CapellaElement elt : RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)currentCapability, (EClass)InteractionPackage.Literals.ABSTRACT_CAPABILITY)) {
            if (!EcoreUtil2.isContainedBy((EObject)elt, (EClass)target)) continue;
            updatedCapability = (AbstractCapability)elt;
        }
        if (updatedCapability != null) {
            for (Scenario sc : updatedCapability.getOwnedScenarios()) {
                List cpntSet = ScenarioExt.getOwnedComponents((Scenario)sc);
                for (Component cpnt : cpntSet) {
                    if (involvedCpntSet.contains(cpnt)) continue;
                    involvedCpntSet.add(cpnt);
                }
            }
            for (Component cpnt : involvedCpntSet) {
                if (AbstractCapabilityExt.getInvolvedComponents((AbstractCapability)updatedCapability).contains(cpnt)) continue;
                AbstractCapabilityExt.addInvolvedComponent((AbstractCapability)updatedCapability, (Component)cpnt);
            }
            for (Component cpnt : AbstractCapabilityExt.getInvolvedComponents((AbstractCapability)updatedCapability)) {
                if (involvedCpntSet.contains(cpnt)) continue;
                AbstractCapabilityExt.removeInvolvedComponent((AbstractCapability)updatedCapability, (Component)cpnt);
            }
        }
    }
}

