/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IMarkerSource;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.extpoint.ReportLogViewExtPointUtil;

public class MarkerViewHelper {
    public static final String ECORE_DIAGNOSTIC_SOURCE = "org.eclipse.emf.ecore";
    public static final Object OTHER_CATEGORY = new Object();
    public static final Object OTHER_RULES = new Object();
    private final IMarkerSource markerSource;
    private final String viewId;

    public MarkerViewHelper(IMarkerSource markerSource, String viewId) {
        this.markerSource = markerSource;
        this.viewId = viewId;
    }

    private void findMarkersFor(String markerType, Collection<IMarker> resultingCollection, IResource resource) {
        try {
            IMarker[] markers;
            if (resource != null && (markers = resource.findMarkers(markerType, false, 2)) != null) {
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    resultingCollection.add(marker);
                    ++n2;
                }
            }
            for (IMarker marker : this.markerSource.getMarkers()) {
                if (!markerType.equals(marker.getType())) continue;
                resultingCollection.add(marker);
            }
        }
        catch (CoreException e) {
            MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", e.getLocalizedMessage(), (Throwable)e));
        }
    }

    String[] getMarkersToMatchId(String viewId) {
        String[] markerIDs = ReportLogViewExtPointUtil.getMarkersID(viewId);
        if (markerIDs == null) {
            markerIDs = new String[]{"org.polarsys.capella.common.tools.report.appenders.reportlogview.logview"};
        }
        return markerIDs;
    }

    public Collection<IMarker> findMarkers(IResource resource) {
        return this.findMarkers(resource, null);
    }

    public Collection<IMarker> findMarkers(IResource resource, Comparator<IMarker> comparator) {
        AbstractSet result = null;
        result = comparator == null ? new HashSet() : new TreeSet<IMarker>(comparator);
        String[] stringArray = this.getMarkersToMatchId(this.viewId);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String markerType = stringArray[n2];
            this.findMarkersFor(markerType, result, resource);
            ++n2;
        }
        return result;
    }

    public static String getSource(IMarker marker) {
        String result = null;
        Diagnostic d = (Diagnostic)marker.getAdapter(Diagnostic.class);
        if (d != null) {
            result = d.getSource();
        }
        return result;
    }

    public static String getRuleID(IMarker marker, boolean qualified) {
        String result = null;
        Diagnostic diag = (Diagnostic)marker.getAdapter(Diagnostic.class);
        if (diag instanceof ConstraintStatusDiagnostic) {
            int lastDot;
            result = ((ConstraintStatusDiagnostic)diag).getConstraintStatus().getConstraint().getDescriptor().getId();
            if (!qualified && (lastDot = result.lastIndexOf(46)) >= 0 && lastDot < result.length() - 1) {
                result = result.substring(lastDot + 1);
            }
        }
        return result;
    }

    public static String getPreferenceFileName(IMarker marker) {
        return marker.getAttribute("preferenceFile", null);
    }

    @Deprecated
    public String getUnqualifiedRuleId(String ruleId) {
        String result = ruleId;
        int lastDot = result.lastIndexOf(46);
        if (lastDot >= 0 && lastDot < result.length() - 1) {
            result = result.substring(lastDot + 1, result.length());
        }
        return result;
    }

    public static IConstraintDescriptor getConstraintDescriptor(IMarker marker) {
        IConstraintDescriptor descriptor = null;
        Diagnostic d = (Diagnostic)marker.getAdapter(Diagnostic.class);
        if (d instanceof ConstraintStatusDiagnostic) {
            descriptor = ((ConstraintStatusDiagnostic)d).getConstraintStatus().getConstraint().getDescriptor();
        }
        return descriptor;
    }

    public static Diagnostic getDiagnostic(IMarker marker) {
        return (Diagnostic)marker.getAdapter(Diagnostic.class);
    }

    public static Category getCategory(IMarker marker) {
        Set cats;
        Category result = null;
        Diagnostic diag = MarkerViewHelper.getDiagnostic(marker);
        if (diag != null && diag instanceof ConstraintStatusDiagnostic && !(cats = ((ConstraintStatusDiagnostic)diag).getConstraintStatus().getConstraint().getDescriptor().getCategories()).isEmpty()) {
            result = (Category)cats.iterator().next();
        }
        return result;
    }

    public static List<EObject> getModelElementsFromMarker(IMarker marker) {
        Diagnostic diag = MarkerViewHelper.getDiagnostic(marker);
        if (diag != null && diag.getData() != null) {
            Object o;
            if (diag.getData().size() == 1 && (o = diag.getData().get(0)) instanceof EObject) {
                return Collections.singletonList((EObject)o);
            }
            LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
            for (Object o2 : diag.getData()) {
                if (!(o2 instanceof EObject)) continue;
                result.add((EObject)o2);
            }
            return new ArrayList<EObject>(result);
        }
        return Collections.emptyList();
    }

    public static boolean isEcore(IMarker marker) {
        boolean result = false;
        Diagnostic diag = MarkerViewHelper.getDiagnostic(marker);
        if (diag != null && diag.getSource() != null && diag.getSource().equals(ECORE_DIAGNOSTIC_SOURCE)) {
            result = true;
        }
        return result;
    }
}

