/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.ISelectInvokedOperationModel;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.algorithms.CompatibilityDefinition;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.algorithms.CreationAlgorithms;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.algorithms.OptionsDefinition;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.algorithms.SelectionAlgorithms;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.communications.AbstractCommunication;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.communications.InterfaceCommunication;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.communications.LinkCommunication;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.communications.UndefinedCommunication;

public class SelectInvokedOperationModel
implements ISelectInvokedOperationModel {
    protected CompatibilityDefinition compatibilityDef = CompatibilityDefinition.INSTANCE;
    protected CreationAlgorithms creationAlgos = CreationAlgorithms.INSTANCE;
    protected OptionsDefinition optionsDefinition = OptionsDefinition.INSTANCE;
    protected InstanceRole sourceIR;
    protected InstanceRole targetIR;
    protected Component source;
    protected Component target;
    protected List<AbstractCommunication> possibleElements;
    protected List<AbstractCommunication> selectableElements;
    protected List<EObject> selectableElementsContainers;
    protected List<AbstractCommunication> communications;
    protected List<InterfaceCommunication> interfaceCommunications;
    protected List<LinkCommunication> linkCommunications;
    protected List<UndefinedCommunication> undefinedCommunications;
    protected MessageKind messageKind;
    protected boolean withReturn;
    protected boolean hideTechnicalInterfaceNames = true;
    protected boolean restrictToExistingStaticCommunicationCompatibility = true;
    protected boolean allowSelectionOfExistingExchangeItems = false;
    protected boolean elementMustBeCreated = false;
    protected boolean portsMustBeCreated = false;
    protected boolean portsCreationCanBeToggled = false;
    protected boolean communicationLinksMustBeCreated = false;
    protected boolean communicationLinksCreationCanBeToggled = false;
    protected boolean validInterfaceName = true;
    protected AbstractCommunication selectedElement;
    protected AbstractCommunication oldSelectedElement;
    protected String createdElementName = "";
    protected ExchangeMechanism selectedExchangeMechanism;
    protected Interface selectedInterface;
    protected String selectedInterfaceName = "";
    protected boolean interfaceNameCanBeEdited = false;
    protected boolean interfaceCanBeChosen = false;
    protected Interface technicalInterface;
    protected String defaultInterfaceName;
    protected List<Interface> allInterfacesBetweenSourceAndTarget;
    protected List<Interface> allStructuralInterfaces;
    protected List<Interface> restrictedStructuralInterfaces;
    protected List<Interface> allTechnicalInterfaces;

    public SelectInvokedOperationModel(InstanceRole sourceIR, InstanceRole targetIR, boolean withReturn) {
        this.sourceIR = sourceIR;
        this.targetIR = targetIR;
        this.source = (Component)this.sourceIR.getRepresentedInstance().getAbstractType();
        this.target = (Component)this.targetIR.getRepresentedInstance().getAbstractType();
        this.withReturn = withReturn;
        this.messageKind = SelectionAlgorithms.getDefaultMessageKind(this.withReturn);
        this.selectedExchangeMechanism = this.getCompatibleExchangeMechanism().get(0);
        this.initializeModel();
        this.computePossibleElements();
        this.computeSelectableElements();
        this.elementMustBeCreated = this.elementMustBeCreated && this.selectableElements.size() == 0;
    }

    @Override
    public boolean isValid() {
        boolean createdElementNameSet;
        boolean interfaceSet = !this.selectedInterfaceName.equals("");
        boolean bl = createdElementNameSet = !this.createdElementName.equals("");
        return this.validInterfaceName && interfaceSet && (this.elementMustBeCreated && createdElementNameSet || !this.elementMustBeCreated && this.selectedElement != null);
    }

    @Override
    public AbstractCommunication getSelectedElement() {
        return this.selectedElement;
    }

    public void setSelectedElement(AbstractCommunication selectedElement) {
        this.selectedElement = selectedElement;
        if (selectedElement != this.oldSelectedElement || this.elementMustBeCreated) {
            this.portsMustBeCreated = this.optionsDefinition.getDefaultValueForOptionD(selectedElement);
            this.portsCreationCanBeToggled = this.optionsDefinition.doesOptionDIsTogglable(selectedElement);
            this.communicationLinksMustBeCreated = this.optionsDefinition.getDefaultValueForOptionE(selectedElement);
            this.communicationLinksCreationCanBeToggled = this.optionsDefinition.doesOptionEIsTogglable(selectedElement);
            if (selectedElement == null && !this.elementMustBeCreated) {
                this.interfaceNameCanBeEdited = false;
                this.interfaceCanBeChosen = false;
                this.selectedInterface = null;
                this.selectedInterfaceName = "";
            } else if (this.elementMustBeCreated || selectedElement instanceof UndefinedCommunication) {
                this.interfaceNameCanBeEdited = true;
                boolean bl = this.interfaceCanBeChosen = this.allStructuralInterfaces.size() > 0;
                if (this.restrictedStructuralInterfaces.size() > 0) {
                    Interface interfaze;
                    this.selectedInterface = interfaze = this.restrictedStructuralInterfaces.get(0);
                    this.selectedInterfaceName = interfaze.getName();
                } else {
                    this.selectedInterface = null;
                    this.selectedInterfaceName = this.creationAlgos.getDefaultInterfaceName(this.sourceIR, this.targetIR, this.allInterfacesBetweenSourceAndTarget);
                }
            } else if (selectedElement instanceof CommunicationLink) {
                this.interfaceNameCanBeEdited = true;
                this.interfaceCanBeChosen = false;
                if (this.technicalInterface != null) {
                    this.selectedInterface = this.technicalInterface;
                    this.selectedInterfaceName = this.selectedInterface.getName();
                } else {
                    this.selectedInterface = null;
                    this.selectedInterfaceName = this.defaultInterfaceName;
                }
            } else if (selectedElement instanceof ExchangeItemAllocation) {
                this.interfaceNameCanBeEdited = false;
                this.interfaceCanBeChosen = false;
                ExchangeItemAllocation allocation = (ExchangeItemAllocation)selectedElement;
                this.selectedInterface = allocation.getAllocatingInterface();
                this.selectedInterfaceName = this.selectedInterface.getName();
            }
        }
        this.oldSelectedElement = selectedElement;
    }

    private void initializeModel() {
        this.technicalInterface = SelectionAlgorithms.getTechnicalInterface(this.source, this.target);
        this.allInterfacesBetweenSourceAndTarget = this.getInterfaces(false, false);
        this.allStructuralInterfaces = this.getInterfaces(true, false);
        this.allTechnicalInterfaces = new ArrayList<Interface>(this.allInterfacesBetweenSourceAndTarget);
        this.allTechnicalInterfaces.removeAll(this.allStructuralInterfaces);
        this.restrictedStructuralInterfaces = this.getInterfaces(true, true);
        this.defaultInterfaceName = this.creationAlgos.getDefaultInterfaceName(this.sourceIR, this.targetIR, this.allInterfacesBetweenSourceAndTarget);
        this.interfaceCommunications = SelectionAlgorithms.getInterfaceCommunications(this.source, this.target);
        if (this.selectedElement != null && !this.selectableElements.contains(this.selectedElement)) {
            this.setSelectedElement(null);
        }
        this.linkCommunications = SelectionAlgorithms.getLinkCommunications(this.source, this.target);
        this.communications = new ArrayList<AbstractCommunication>();
        this.communications.addAll(this.interfaceCommunications);
        this.communications.addAll(this.linkCommunications);
        this.undefinedCommunications = SelectionAlgorithms.getUndefinedCommunications(this.source, this.target, this.communications);
        this.communications.addAll(this.undefinedCommunications);
    }

    private void computePossibleElements() {
        this.possibleElements = new ArrayList<AbstractCommunication>();
        for (AbstractCommunication com : this.communications) {
            this.possibleElements.add(com);
        }
    }

    private void computeSelectableElements() {
        this.selectableElements = new ArrayList<AbstractCommunication>();
        for (InterfaceCommunication interfaceCommunication : this.interfaceCommunications) {
            if (this.restrictToExistingStaticCommunicationCompatibility && (!this.restrictToExistingStaticCommunicationCompatibility || interfaceCommunication.isPartial) || !this.compatibilityDef.isCompatible(interfaceCommunication.toCommunicationInfo(), this.messageKind, this.withReturn)) continue;
            this.selectableElements.add(interfaceCommunication);
        }
        for (LinkCommunication linkCommunication : this.linkCommunications) {
            if (this.restrictToExistingStaticCommunicationCompatibility && (!this.restrictToExistingStaticCommunicationCompatibility || linkCommunication.isPartial) || !this.compatibilityDef.isCompatible(linkCommunication.toCommunicationInfo(), this.messageKind, this.withReturn)) continue;
            this.selectableElements.add(linkCommunication);
        }
        if (this.doesAllowSelectionOfExistingExchangeItems()) {
            for (UndefinedCommunication undefinedCommunication : this.undefinedCommunications) {
                if (!this.compatibilityDef.isCompatible(undefinedCommunication.toCommunicationInfo(), this.messageKind, this.withReturn)) continue;
                this.selectableElements.add(undefinedCommunication);
            }
        }
        if (this.selectedElement != null && !this.selectableElements.contains(this.selectedElement)) {
            this.setSelectedElement(null);
        }
        this.selectableElementsContainers = new ArrayList<EObject>();
        for (AbstractCommunication abstractCommunication : this.selectableElements) {
            CapellaElement object = abstractCommunication.getRepresentativeElement();
            EObject container = object.eContainer();
            while (container != null && !this.selectableElementsContainers.contains(container)) {
                this.selectableElementsContainers.add(container);
                container = container.eContainer();
            }
        }
    }

    @Override
    public boolean doesInterfaceNameCanBeEdited() {
        return this.interfaceNameCanBeEdited;
    }

    @Override
    public boolean doesInterfaceCanBeChosen() {
        return this.interfaceCanBeChosen;
    }

    @Override
    public boolean doesElementMustBeCreated() {
        return this.elementMustBeCreated;
    }

    public void setElementMustBeCreated(boolean state) {
        this.elementMustBeCreated = state;
    }

    @Override
    public boolean doesCommunicationLinksMustBeCreated() {
        return this.communicationLinksMustBeCreated;
    }

    @Override
    public boolean doesCommunicationLinksCreationCanBeToggled() {
        return this.communicationLinksCreationCanBeToggled;
    }

    public void setCommunicationLinksMustBeCreated(boolean state) {
        this.communicationLinksMustBeCreated = state;
    }

    @Override
    public boolean doesPortsMustBeCreated() {
        return this.portsMustBeCreated;
    }

    @Override
    public boolean doesPortsCreationCanBeToggled() {
        return this.elementMustBeCreated || this.selectedElement instanceof ExchangeItem;
    }

    public void setPortsMustBeCreated(boolean state) {
        this.portsMustBeCreated = state;
    }

    @Override
    public boolean doesTheMessageReturnAValue() {
        return this.withReturn;
    }

    @Override
    public boolean doesHideTechnicalInterfaceNames() {
        return this.hideTechnicalInterfaceNames;
    }

    public void setHideTechnicalInterfaceNames(boolean state) {
        this.hideTechnicalInterfaceNames = state;
    }

    @Override
    public boolean doesRestrictToExistingStaticCommunicationCompatibility() {
        return this.restrictToExistingStaticCommunicationCompatibility;
    }

    public void setMessageKind(MessageKind messageKind) {
        this.messageKind = messageKind;
        this.computeSelectableElements();
    }

    public void setRestrictToExistingStaticCommunicationCompatibility(boolean state) {
        this.restrictToExistingStaticCommunicationCompatibility = state;
        this.computeSelectableElements();
    }

    @Override
    public boolean doesAllowSelectionOfExistingExchangeItems() {
        return this.allowSelectionOfExistingExchangeItems;
    }

    public void setAllowSelectionOfExistingExchangeItems(boolean state) {
        this.allowSelectionOfExistingExchangeItems = state;
        this.computeSelectableElements();
    }

    public void setCreatedElementName(String createdElementName) {
        this.createdElementName = createdElementName;
    }

    public void setSelectedExchangeMechanism(ExchangeMechanism selectedExchangeMechanism) {
        this.selectedExchangeMechanism = selectedExchangeMechanism;
    }

    public void setSelectedInterfaceName(String selectedInterfaceName) {
        this.selectedInterfaceName = selectedInterfaceName;
        if (this.selectedInterface != null && !selectedInterfaceName.equals(this.selectedInterface.getName())) {
            this.selectedInterface = null;
        }
        this.validInterfaceName = true;
        if (this.elementMustBeCreated || this.selectedElement instanceof UndefinedCommunication) {
            this.validInterfaceName = !this.creationAlgos.interfaceExistWithName(selectedInterfaceName, this.allTechnicalInterfaces);
        }
    }

    public boolean doesInterfaceExist() {
        return this.creationAlgos.interfaceExistWithName(this.selectedInterfaceName, this.allInterfacesBetweenSourceAndTarget);
    }

    @Override
    public String getSelectedInterfaceName() {
        return this.selectedInterfaceName;
    }

    public void setSelectedInterface(Interface selectedInterface) {
        this.selectedInterface = selectedInterface;
    }

    @Override
    public List<AbstractCommunication> getSelectableElements() {
        return this.selectableElements;
    }

    @Override
    public List<EObject> getSelectableElementContainers() {
        return this.selectableElementsContainers;
    }

    @Override
    public List<AbstractCommunication> getPossibleElements() {
        return this.possibleElements;
    }

    @Override
    public MessageKind getMessageKind() {
        return this.messageKind;
    }

    @Override
    public List<Interface> getInterfaces(boolean onlyStructural, boolean restrictToStaticCommunications) {
        ArrayList<Interface> res = new ArrayList<Interface>();
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(InteractionPackage.Literals.SEQUENCE_MESSAGE, (EStructuralFeature)InteractionPackage.Literals.SEQUENCE_MESSAGE__RECEIVING_END);
        for (EObject capellaElement : query.getAvailableElements((EObject)this.sourceIR)) {
            Interface interface_ = (Interface)capellaElement;
            if (onlyStructural && !interface_.isStructural() || restrictToStaticCommunications && !this.creationAlgos.isGoodInterface((CapellaElement)interface_, this.sourceIR, this.targetIR)) continue;
            res.add(interface_);
        }
        return res;
    }

    public boolean doesInterfaceToCreateIsStructural() {
        return !(this.selectedElement instanceof CommunicationLink);
    }

    @Override
    public List<ExchangeMechanism> getCompatibleExchangeMechanism() {
        return this.compatibilityDef.getCompatibleExchangeMechanismFor(this.withReturn);
    }

    @Override
    public CapellaElement createOrUpdateElement() {
        if (this.selectedInterface == null) {
            this.selectedInterface = this.creationAlgos.createInterface(this.selectedInterfaceName, this.sourceIR, this.targetIR, this.doesInterfaceToCreateIsStructural());
        } else if (!this.selectedInterface.getName().equals(this.selectedInterfaceName)) {
            this.selectedInterface.setName(this.selectedInterfaceName);
        }
        AbstractCommunication com = this.selectedElement;
        if (this.elementMustBeCreated) {
            ExchangeItem item = this.creationAlgos.createExchangeItem(this.createdElementName, this.selectedInterface, this.selectedExchangeMechanism);
            com = new UndefinedCommunication(item);
        }
        com.source = this.source;
        com.target = this.target;
        com.interfaze = this.selectedInterface;
        if (com.exchangeItemAllocation == null) {
            com.exchangeItemAllocation = this.creationAlgos.getOrCreateAllocation(com, this.messageKind, this.withReturn);
        }
        if (!this.portsMustBeCreated) {
            this.creationAlgos.updateInterfaceCommunication(com);
        }
        if (this.communicationLinksMustBeCreated) {
            this.creationAlgos.updateLinkCommunication(com, this.messageKind, this.withReturn);
        }
        return com.exchangeItemAllocation;
    }

    public ExchangeMechanism getSelectedExchangeMechanism() {
        return this.selectedExchangeMechanism;
    }

    public boolean isValidInterfaceName() {
        return this.validInterfaceName;
    }
}

