/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.properties;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.flexibility.properties.property.AbstractProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IEditableProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.properties.LibraryManagerModel;

public class ReferencesProperty
extends AbstractProperty
implements IEditableProperty {
    LibraryManagerModel model = null;

    public Object getValue(IPropertyContext context_p) {
        if (this.model == null) {
            this.model = (LibraryManagerModel)context_p.getSource();
        }
        return this.model;
    }

    public IStatus validate(Object newValue_p, IPropertyContext context_p) {
        Collection<IModel> unsavedSessions = this.model.getUnsavedModels();
        if (!unsavedSessions.isEmpty()) {
            StringBuffer b = new StringBuffer();
            for (IModel modelX : unsavedSessions) {
                b.append(String.valueOf(modelX.getIdentifier().getName()) + ",");
            }
            b.deleteCharAt(b.length() - 1);
            return new Status(4, "org.polarsys.capella.core.libraries", NLS.bind((String)"There is other unsaved session(s) ({0}), this may lead to inconsistencies,\n You should save others sessions before manage references.", (Object)b));
        }
        boolean unsavedModel = this.model.isUnsavedRootModel();
        if (unsavedModel) {
            return new Status(2, "org.polarsys.capella.core.libraries", "The session is unsaved. Manage references will save the session.");
        }
        Collection<Collection<IModel>> cycles = this.model.getCycles();
        if (cycles.size() > 0) {
            Collection<IModel> cycle = cycles.iterator().next();
            StringBuffer b = new StringBuffer();
            for (IModel pathElement : cycle) {
                b.append(String.valueOf(pathElement.getIdentifier().getName()) + " ");
            }
            return new Status(4, "org.polarsys.capella.core.libraries", String.valueOf(cycles.size()) + " cycles found. First one is [" + b + "]");
        }
        return Status.OK_STATUS;
    }

    public Object getType() {
        return Object.class;
    }

    public Object toType(Object value_p, IPropertyContext context_p) {
        return value_p;
    }

    public void setValue(IPropertyContext context_p) {
        IModel.Edit rootModel = this.model.getRootModel();
        Collection<IModel> newReferencedLibraries = this.model.getReferencedLibrariesByRootModel();
        Collection<IModel> initialReferencedLibraries = this.model.getInitialReferencedLibrariesByRootModel();
        for (IModel library : newReferencedLibraries) {
            if (initialReferencedLibraries.contains(library)) continue;
            rootModel.addReference(library);
        }
        for (IModel library : initialReferencedLibraries) {
            if (newReferencedLibraries.contains(library)) continue;
            rootModel.removeReference(library);
        }
    }
}

