/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;

public class BooleanValueGroup
extends AbstractSemanticField {
    protected CCombo _valueField;
    protected String[] _comboItems = new String[]{Boolean.TRUE.toString().toUpperCase(), Boolean.FALSE.toString().toUpperCase()};

    public BooleanValueGroup(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(widgetFactory);
        Group comboGroup = this._widgetFactory.createGroup(parent, "");
        comboGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        comboGroup.setLayoutData((Object)gd);
        this.createValueComboField(comboGroup, label);
    }

    private void createValueComboField(Group comboGroup, String label) {
        this._widgetFactory.createCLabel((Composite)comboGroup, label);
        this._valueField = this._widgetFactory.createCCombo((Composite)comboGroup, 2048);
        this._valueField.addSelectionListener((SelectionListener)this);
        this._valueField.setLayoutData((Object)new GridData(768));
        this._valueField.setItems(this._comboItems);
        this._valueField.setEditable(false);
    }

    @Override
    public void loadData(EObject semanticElement, EStructuralFeature semanticFeature) {
        super.loadData(semanticElement, semanticFeature);
        this.loadComboValue();
    }

    @Override
    public void loadData(EObject semanticElement) {
        this.loadComboValue();
    }

    public void loadComboValue() {
        Object value;
        if (this._valueField != null && this._semanticElement != null && this._semanticFeature != null && (value = this._semanticElement.eGet(this._semanticFeature)) instanceof Boolean) {
            this._valueField.select((Boolean)value != false ? 0 : 1);
        }
    }

    @Override
    protected void fillComboField(CCombo comboField) {
        if (comboField.equals(this._valueField)) {
            Boolean value = Boolean.valueOf(this._comboItems[this._valueField.getSelectionIndex()]);
            this.setDataValue(this._semanticElement, this._semanticFeature, value);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this._valueField != null && !this._valueField.isDisposed()) {
            this._valueField.setEnabled(enabled);
        }
    }
}

