/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.sections;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaReadOnlyHelper;
import org.polarsys.capella.core.model.handler.provider.IReadOnlyListener;
import org.polarsys.capella.core.ui.properties.controllers.RepresentationContextualElementsController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.RepresentationContextualElementsField;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.core.ui.properties.sections.Messages;

public class DiagramRepresentationPropertySection
extends AbstractSection {
    private WeakReference<DRepresentation> _representation;
    private Text _nameTextField;
    private FocusAdapter _focusAdapter;
    private KeyAdapter _keyAdapter;
    private RepresentationContextualElementsField _contextualElementsField;

    protected void commitNameChanged() {
        if (this._nameTextField.getText().equals(((DRepresentation)this._representation.get()).getName())) {
            return;
        }
        this.executeCommmand((ICommand)new AbstractReadWriteCommand(){

            public Collection<?> getAffectedObjects() {
                return Collections.singleton(DiagramRepresentationPropertySection.this._representation);
            }

            public String getName() {
                return Messages.RepresentationSection_SetCommand_Representation_Name_Label;
            }

            public void run() {
                ((DRepresentation)DiagramRepresentationPropertySection.this._representation.get()).setName(DiagramRepresentationPropertySection.this._nameTextField.getText());
            }
        });
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
        TabbedPropertySheetWidgetFactory widgetFactory = this.getWidgetFactory();
        this.rootParentComposite.setLayout((Layout)new GridLayout());
        Group textGroup = widgetFactory.createGroup(this.rootParentComposite, "");
        textGroup.setLayout((Layout)new GridLayout(2, false));
        textGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this._focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (e.widget == DiagramRepresentationPropertySection.this._nameTextField) {
                    DiagramRepresentationPropertySection.this.commitNameChanged();
                }
            }
        };
        this._keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event != null && event.character == '\r' && event.widget == DiagramRepresentationPropertySection.this._nameTextField) {
                    DiagramRepresentationPropertySection.this.commitNameChanged();
                }
            }
        };
        this.createNameWidget(widgetFactory, textGroup);
        this.createContextualElementsWidget(widgetFactory, this.rootParentComposite);
    }

    protected void createNameWidget(TabbedPropertySheetWidgetFactory widgetFactory, Group textGroup) {
        widgetFactory.createCLabel((Composite)textGroup, Messages.RepresentationSection_Name_Title);
        this._nameTextField = widgetFactory.createText((Composite)textGroup, "");
        this._nameTextField.setLayoutData((Object)new GridData(4, 4, true, false));
        this._nameTextField.addFocusListener((FocusListener)this._focusAdapter);
        this._nameTextField.addKeyListener((KeyListener)this._keyAdapter);
    }

    protected void createContextualElementsWidget(TabbedPropertySheetWidgetFactory widgetFactory, Composite rootParentComposite) {
        boolean displayedInWizard = this.isDisplayedInWizard();
        this._contextualElementsField = new RepresentationContextualElementsField((Composite)this.getReferencesGroup(), Messages.ContextualElements_Label, this.getWidgetFactory(), new RepresentationContextualElementsController());
        this._contextualElementsField.setDisplayedInWizard(displayedInWizard);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._representation != null) {
            CapellaReadOnlyHelper.unregister((EObject)((EObject)this._representation.get()), (IReadOnlyListener)this);
            this._representation.clear();
            this._representation = null;
        }
    }

    @Override
    public void historyNotification(OperationHistoryEvent event) {
        Command command;
        IUndoableOperation operation;
        int eventType = event.getEventType();
        if ((10 == eventType || 9 == eventType) && (operation = event.getOperation()) instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()).getAffectedObjects().contains(this._representation)) {
            this.refresh();
        }
    }

    protected void loadData() {
        String name = "";
        if (this._representation != null) {
            name = ((DRepresentation)this._representation.get()).getName();
        }
        this._nameTextField.setText(name);
        if (this._contextualElementsField != null) {
            this._contextualElementsField.loadData((DRepresentation)this._representation.get());
            boolean isContextual = ContextualDiagramHelper.getService().isContextualRepresentation((DRepresentation)this._representation.get());
            this._contextualElementsField.setEnabled(isContextual);
        }
    }

    @Override
    public void refresh() {
        this.loadData();
    }

    @Override
    public boolean select(Object toTest) {
        return toTest instanceof DRepresentationDescriptor || toTest instanceof DRepresentation || toTest instanceof IDDiagramEditPart;
    }

    @Override
    protected ExecutionManager getExecutionManager() {
        return TransactionHelper.getExecutionManager((EObject)((EObject)this._representation.get()));
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (!selection.isEmpty()) {
            if (this._representation != null) {
                CapellaReadOnlyHelper.unregister((EObject)((EObject)this._representation.get()), (IReadOnlyListener)this);
            }
            if (selection instanceof IStructuredSelection) {
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof DRepresentationDescriptor) {
                    firstElement = ((DRepresentationDescriptor)firstElement).getRepresentation();
                }
                if (firstElement instanceof DRepresentation) {
                    this._representation = new WeakReference<DRepresentation>((DRepresentation)firstElement);
                } else if (firstElement instanceof IDDiagramEditPart) {
                    IDDiagramEditPart diagramEditPart = (IDDiagramEditPart)firstElement;
                    this._representation = new WeakReference<DRepresentation>((DRepresentation)((Diagram)diagramEditPart.getModel()).getElement());
                } else {
                    this._representation = null;
                }
            }
            this.loadData();
            if (this._representation != null) {
                this.register((EObject)this._representation.get());
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._nameTextField != null && !this._nameTextField.isDisposed()) {
            this._nameTextField.setEnabled(enabled);
        }
        if (this._contextualElementsField != null) {
            this._contextualElementsField.setEnabled(enabled);
        }
    }

    @Override
    public List<AbstractSemanticField> getSemanticFields() {
        return Collections.emptyList();
    }
}

