/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.internal.views.properties.tabbed.TabbedPropertyViewPlugin;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyGroup;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.ui.tabbed.PropertiesSectionDescriptor;
import org.polarsys.capella.common.flexibility.wizards.ui.tabbed.PropertiesTabDescriptor;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.core.ui.properties.sections.CapellaPropertySection;
import org.polarsys.capella.core.ui.properties.sections.IAbstractSection;
import org.polarsys.capella.core.ui.properties.tabbed.SubPropertiesTabDescriptorProvider;

public class CustomPropertyHelper {
    private static final String EXTPT_SECTIONS = "propertySections";
    private static final String ATT_CONTRIBUTOR_ID = "contributorId";
    private static final String ELEMENT_SECTION = "propertySection";
    private static final String ELEMENT_INPUT = "input";
    private static final String ELEMENT_TAB = "tab";
    private static final String ATT_INPUT_TYPE = "type";

    public static Map<String, IAbstractSection> getCustomPropertySection(EObject object, String contributorId) {
        return CustomPropertyHelper.getCustomPropertySection(object, contributorId, true);
    }

    public static Map<String, IAbstractSection> getCustomPropertySection(EObject object, String contributorId, boolean strict) {
        HashMap<String, IAbstractSection> result = new HashMap<String, IAbstractSection>(0);
        if (object == null || contributorId == null) {
            return result;
        }
        Map<String, List<Object>> map = CustomPropertyHelper.getAllPropertySections(object, contributorId, strict);
        for (String key : map.keySet()) {
            List<Object> values = map.get(key);
            if (values.size() <= 0) continue;
            for (Object value : values) {
                if (!(value instanceof IAbstractSection) || !((IAbstractSection)value).select(object)) continue;
                result.put(key, (IAbstractSection)value);
            }
        }
        return new TreeMap<String, IAbstractSection>(result);
    }

    public static AbstractPropertySection getDescriptionSection(EClass metaclass, String contributorId, String key) {
        Object value;
        Map<String, List<Object>> map;
        List<Object> values;
        if (contributorId != null && (values = (map = CustomPropertyHelper.getAllPropertySections((EObject)metaclass, contributorId, false)).get(key)).size() > 0 && (value = values.get(0)) instanceof AbstractPropertySection) {
            return (AbstractPropertySection)value;
        }
        return null;
    }

    private static Map<String, List<Object>> getAllPropertySections(EObject object, String contributorId, boolean strict) {
        ITabDescriptor[] descriptors;
        IConfigurationElement[] propertySectionsElements;
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        String metaClassName = object.eClass().getInstanceClassName();
        List<String> allMetaClassNames = CustomPropertyHelper.getAllMetaClassNames(object.eClass());
        IConfigurationElement[] iConfigurationElementArray = propertySectionsElements = ExtensionPointHelper.getConfigurationElements((String)TabbedPropertyViewPlugin.getPlugin().getBundle().getSymbolicName(), (String)EXTPT_SECTIONS);
        int n = propertySectionsElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement propertySectionsElement = iConfigurationElementArray[n2];
            String id = propertySectionsElement.getAttribute(ATT_CONTRIBUTOR_ID);
            if (contributorId.equals(id)) {
                IConfigurationElement[] sections;
                IConfigurationElement[] iConfigurationElementArray2 = sections = propertySectionsElement.getChildren(ELEMENT_SECTION);
                int n3 = sections.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement[] elements;
                    IConfigurationElement propertySectionElement = iConfigurationElementArray2[n4];
                    String key = propertySectionElement.getAttribute(ELEMENT_TAB);
                    IConfigurationElement[] iConfigurationElementArray3 = elements = propertySectionElement.getChildren(ELEMENT_INPUT);
                    int n5 = elements.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement element = iConfigurationElementArray3[n6];
                        String readMetaClass = element.getAttribute(ATT_INPUT_TYPE);
                        if (strict && metaClassName.equals(readMetaClass) || !strict && allMetaClassNames.contains(readMetaClass)) {
                            Object section = ExtensionPointHelper.createInstance((IConfigurationElement)propertySectionElement, (String)"class");
                            ArrayList<Object> lst = (ArrayList<Object>)result.get(key);
                            if (lst == null) {
                                lst = new ArrayList<Object>();
                            }
                            if (metaClassName.equals(readMetaClass)) {
                                lst.add(0, section);
                            } else {
                                lst.add(section);
                            }
                            result.put(key, lst);
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        SubPropertiesTabDescriptorProvider provider = new SubPropertiesTabDescriptorProvider(){

            protected ITabDescriptor createTabDescriptor(IPropertyContext context, IRendererContext rendererContext, IPropertyGroup mainGroup) {
                return new PropertiesTabDescriptor(context, rendererContext, mainGroup){

                    protected ISectionDescriptor createSectionDescriptor(IPropertyContext context, IRendererContext rendererContext, IPropertyGroup group) {
                        return new PropertiesSectionDescriptor(context, rendererContext, group){

                            protected ISection createSection(IPropertyContext context, IRendererContext renderers, IPropertyGroup group) {
                                return new CapellaPropertySection(context, renderers, group);
                            }
                        };
                    }
                };
            }
        };
        StructuredSelection selection = new StructuredSelection((Object)object);
        ITabDescriptor[] iTabDescriptorArray = descriptors = provider.getTabDescriptors(null, (ISelection)selection);
        int n7 = descriptors.length;
        int n8 = 0;
        while (n8 < n7) {
            ITabDescriptor descriptor = iTabDescriptorArray[n8];
            for (Object obj : descriptor.getSectionDescriptors()) {
                if (!(obj instanceof ISectionDescriptor)) continue;
                ISectionDescriptor sectionDescriptor = (ISectionDescriptor)obj;
                ISection section = sectionDescriptor.getSectionClass();
                ArrayList<ISection> lst = (ArrayList<ISection>)result.get(descriptor.getText());
                if (lst == null) {
                    lst = new ArrayList<ISection>();
                }
                lst.add(section);
                result.put(descriptor.getText(), lst);
            }
            ++n8;
        }
        return result;
    }

    protected static List<String> getAllMetaClassNames(EClass eclass) {
        ArrayList<String> allNames = new ArrayList<String>();
        for (EClass ecls : eclass.getEAllSuperTypes()) {
            allNames.add(ecls.getInstanceClassName());
        }
        allNames.add(eclass.getInstanceClassName());
        return allNames;
    }
}

