/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.postgeneration.egf;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.polarsys.capella.core.postgeneration.egf.UpdateIconsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelLoader
implements IRunnableWithProgress {
    private Collection<IFile> _metamodelFiles;
    private boolean _verbose;
    private ResourceSet _resourceSet;
    private Map<EClass, Set<EReference>> _crossRefs;

    public MetamodelLoader(Collection<IFile> metamodelFiles_p, boolean verbose_p) {
        Assert.isNotNull(metamodelFiles_p);
        this._metamodelFiles = metamodelFiles_p;
        this._verbose = verbose_p;
        this._resourceSet = null;
        this._crossRefs = null;
    }

    public ResourceSet getResultingResourceSet() {
        return this._resourceSet;
    }

    public Map<EClass, Set<EReference>> getResultingContainmentIncomingReferences() {
        return this._crossRefs;
    }

    public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
        try {
            int nb = this._metamodelFiles.size();
            monitor_p.beginTask("Loading metamodel fragments...", nb);
            this._resourceSet = new ResourceSetImpl();
            for (IFile file : this._metamodelFiles) {
                UpdateIconsUtil.getResourceFrom(file, this._resourceSet, this._verbose);
                monitor_p.worked(1);
                if (!monitor_p.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            monitor_p.beginTask("Computing external cross-references...", 1);
            monitor_p.worked(1);
            this._crossRefs = this.buildContainmentCrossReferences(this._resourceSet);
        }
        finally {
            monitor_p.done();
        }
    }

    Map<EClass, Set<EReference>> buildContainmentCrossReferences(ResourceSet rs_p) {
        HashMap<EClass, Set<EReference>> result = new HashMap<EClass, Set<EReference>>();
        TreeIterator it = rs_p.getAllContents();
        while (it.hasNext()) {
            EReference ref;
            Notifier current = (Notifier)it.next();
            if (!(current instanceof EReference) || !(ref = (EReference)current).isContainment()) continue;
            EClass targetClass = ref.getEReferenceType();
            HashSet<EReference> value = (HashSet<EReference>)result.get(targetClass);
            if (value == null) {
                value = new HashSet<EReference>();
                result.put(targetClass, value);
            }
            value.add(ref);
        }
        return result;
    }
}

