/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.postgeneration.egf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;

public class RemoveSourceFeatures
implements ITaskProduction {
    private static final String SOURCE_FEATURE_SUFFIX = ".source";
    private static final String FEATURE_FILE = "feature.xml";

    protected void execute(File feature_p) throws InvocationException {
        ExternalFeatureModel featureModel = new ExternalFeatureModel(){
            private static final long serialVersionUID = 1L;

            public boolean isEditable() {
                return true;
            }
        };
        try {
            FileInputStream inputStream = new FileInputStream(feature_p);
            featureModel.load((InputStream)inputStream, false);
            ((InputStream)inputStream).close();
            IFeature feature = featureModel.getFeature();
            String featureId = feature.getId();
            IFeatureChild[] includedFeatures = feature.getIncludedFeatures();
            ArrayList<IFeatureChild> featuresToRemove = new ArrayList<IFeatureChild>(0);
            IFeatureChild[] iFeatureChildArray = includedFeatures;
            int n = includedFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureChild currentIncludedFeature = iFeatureChildArray[n2];
                String currentFeatureId = currentIncludedFeature.getId();
                if (currentFeatureId.endsWith(SOURCE_FEATURE_SUFFIX)) {
                    featuresToRemove.add(currentIncludedFeature);
                    System.out.println("Source feature:" + currentFeatureId + " will be removed from " + featureId);
                }
                ++n2;
            }
            if (!featuresToRemove.isEmpty()) {
                feature.removeIncludedFeatures(featuresToRemove.toArray(new IFeatureChild[featuresToRemove.size()]));
                String contents = this.getContents(feature);
                FileOutputStream outputStream = new FileOutputStream(feature_p);
                outputStream.write(contents.getBytes("UTF8"));
                outputStream.close();
            }
        }
        catch (Exception exception_p) {
            throw new InvocationException((Throwable)exception_p);
        }
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IResource xml = project.findMember(FEATURE_FILE);
            if (xml instanceof IFile) {
                this.execute(((IFile)xml).getRawLocation().toFile());
            }
            ++n2;
        }
    }

    protected String getContents(IFeature feature_p) throws IOException {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        feature_p.write("", writer);
        writer.flush();
        swriter.close();
        return swriter.toString();
    }

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

