/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sequencediag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.query.legacy.ecore.factories.EFactory;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.ActorCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentAllocation;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.SystemComponent;
import org.polarsys.capella.core.data.ctx.ActorCapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.RefinementLink;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.SystemActorRealization;
import org.polarsys.capella.core.data.pa.LogicalActorRealization;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class InteractionAspectService {
    public List<AbstractActor> getAllActors(EObject any) {
        return ScenarioExt.getAllActors((EObject)any);
    }

    public Collection<Part> getAllComponents(EObject any, Collection<Part> filter) {
        return ScenarioExt.getAllComponents((EObject)any, filter);
    }

    public EObject getAncestor(EObject context, String type) {
        EObject current = context.eContainer();
        while (current != null && !EFactory.eInstanceOf((EObject)current, (String)type)) {
            current = current.eContainer();
        }
        return current;
    }

    public Collection<Part> getAvailableParts(EObject any, Collection<Part> filter) {
        ArrayList<Part> result = new ArrayList<Part>();
        EObject component = this.getAncestor(any, "Component");
        if (component != null) {
            Component comp = (Component)component;
            this.getOwnedPart(result, comp, filter);
        } else {
            EObject arch = this.getAncestor(any, "BlockArchitecture");
            BlockArchitecture architecture = (BlockArchitecture)arch;
            LogicalComponent rootComponent = null;
            if (arch != null) {
                if (architecture instanceof LogicalArchitecture) {
                    rootComponent = ((LogicalArchitecture)architecture).getOwnedLogicalComponent();
                    if (rootComponent != null) {
                        this.getOwnedPart(result, (Component)rootComponent, filter);
                        if (!rootComponent.getRepresentingPartitions().isEmpty()) {
                            result.add((Part)rootComponent.getRepresentingPartitions().get(0));
                        }
                        return result;
                    }
                } else if (architecture instanceof PhysicalArchitecture) {
                    rootComponent = ((PhysicalArchitecture)architecture).getOwnedPhysicalComponent();
                } else if (architecture instanceof EPBSArchitecture) {
                    rootComponent = ((EPBSArchitecture)architecture).getOwnedConfigurationItem();
                }
                if (rootComponent != null) {
                    this.getOwnedPart(result, (Component)rootComponent, filter);
                }
            }
        }
        return result;
    }

    public Collection<Part> getAllAvailableParts(EObject any, Collection<Part> filter) {
        return ScenarioExt.getAllAvailableParts((EObject)any, filter);
    }

    public Collection<Part> getAllAvailablePartsIncludingSystem(EObject any, Collection<Part> filter) {
        return ScenarioExt.getAllAvailablePartsIncludingSystem((EObject)any, filter);
    }

    private void getOwnedPart(Collection<Part> result, Component rootComponent, Collection<Part> filter) {
        EList ownedPartitions = rootComponent.getOwnedPartitions();
        for (Partition partition : ownedPartitions) {
            if (!(partition instanceof Part) || filter.contains(partition)) continue;
            result.add((Part)partition);
            AbstractType type = partition.getAbstractType();
            if (!(type instanceof PhysicalComponent)) continue;
            PhysicalComponent pc = (PhysicalComponent)type;
            this.getOwnedPart(result, (Component)pc, filter);
        }
    }

    public Collection<Part> getChildren(Part part, Collection<Part> filter) {
        if (CsPackage.eINSTANCE.getComponent().isInstance((Object)part.getAbstractType())) {
            Component component = (Component)part.getAbstractType();
            Collection<Part> allChildren = InteractionAspectService.filter(component.getOwnedFeatures(), Part.class);
            LinkedList<Part> result = new LinkedList<Part>(allChildren);
            LinkedList<Part> filteredChildren = new LinkedList<Part>(filter);
            filteredChildren.retainAll(result);
            result.removeAll(filter);
            for (Part filteredChild : filteredChildren) {
                result.addAll(this.getChildren(filteredChild, filter));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public ModellingArchitecture findArchitecture(EObject ownedElement) {
        ModellingArchitecture result = null;
        EObject current = ownedElement;
        while (result == null && current != null) {
            if (CapellacorePackage.eINSTANCE.getModellingArchitecture().isInstance((Object)current)) {
                result = (ModellingArchitecture)current;
            }
            current = current.eContainer();
        }
        return result;
    }

    private static <T> Collection<T> filter(Collection<?> collection, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>(collection.size());
        for (Object o : collection) {
            if (!type.isInstance(o)) continue;
            result.add(type.cast(o));
        }
        result.trimToSize();
        return result;
    }

    public TraceableElement getRefinedCapabilityRealization(CapabilityRealization context) {
        EList outgoingTraces = context.getOutgoingTraces();
        for (AbstractTrace abstractTrace : outgoingTraces) {
            TraceableElement targetElement;
            if (!(abstractTrace instanceof RefinementLink) || !((targetElement = abstractTrace.getTargetElement()) instanceof CapabilityRealization)) continue;
            return targetElement;
        }
        return null;
    }

    public TraceableElement getRefinedCapabality(CapabilityRealization context) {
        EList outgoingTraces = context.getOutgoingTraces();
        for (AbstractTrace abstractTrace : outgoingTraces) {
            if (!(abstractTrace instanceof RefinementLink)) continue;
            TraceableElement targetElement = abstractTrace.getTargetElement();
            if (targetElement instanceof Capability) {
                return targetElement;
            }
            if (!(targetElement instanceof CapabilityRealization)) continue;
            return this.getRefinedCapabality((CapabilityRealization)targetElement);
        }
        return null;
    }

    public List<CapabilityRealization> getRefinedCapabilityRealizations(CapabilityRealization context) {
        ArrayList<CapabilityRealization> result = new ArrayList<CapabilityRealization>(4);
        result.add(context);
        EList outgoingTraces = context.getOutgoingTraces();
        for (AbstractTrace abstractTrace : outgoingTraces) {
            if (!(abstractTrace instanceof RefinementLink)) continue;
            TraceableElement targetElement = abstractTrace.getTargetElement();
            if (targetElement instanceof Capability) {
                return result;
            }
            if (!(targetElement instanceof CapabilityRealization)) continue;
            result.addAll(this.getRefinedCapabilityRealizations((CapabilityRealization)targetElement));
            return result;
        }
        return null;
    }

    public List<AbstractActor> getAllRefinedActors(CapabilityRealization context) {
        Capability capa;
        ArrayList<AbstractActor> result = new ArrayList<AbstractActor>();
        List<CapabilityRealization> capabilities = this.getRefinedCapabilityRealizations(context);
        if (capabilities != null) {
            for (CapabilityRealization capabilityRealization : capabilities) {
                result.addAll((Collection<AbstractActor>)capabilityRealization.getParticipatingActors());
            }
        }
        if ((capa = (Capability)this.getRefinedCapabality(context)) != null) {
            result.addAll((Collection<AbstractActor>)capa.getParticipatingActors());
        }
        return result;
    }

    public List<ActorCapabilityInvolvement> getRefinedInvolvedActors(CapabilityRealization context) {
        EList outgoingTraces = context.getOutgoingTraces();
        for (AbstractTrace abstractTrace : outgoingTraces) {
            if (!(abstractTrace instanceof RefinementLink)) continue;
            TraceableElement targetElement = abstractTrace.getTargetElement();
            if (targetElement instanceof Capability) {
                Capability cap = (Capability)targetElement;
                return cap.getInvolvedActors();
            }
            if (!(targetElement instanceof CapabilityRealization)) continue;
            return this.getRefinedInvolvedActors((CapabilityRealization)targetElement);
        }
        return null;
    }

    public List<SystemComponent> getOwnedSystemComponents(SystemComponent context) {
        ArrayList<SystemComponent> list = new ArrayList<SystemComponent>();
        ModellingArchitecture architecture = SystemEngineeringExt.findArchitecture((EObject)context);
        if (architecture != null && (architecture instanceof LogicalArchitecture && context instanceof LogicalComponent || architecture instanceof PhysicalArchitecture && context instanceof PhysicalComponent)) {
            for (Component component : ComponentExt.getSubDefinedComponents((Component)context)) {
                if (!(component instanceof SystemComponent)) continue;
                list.add((SystemComponent)component);
            }
        }
        return list;
    }

    public List<ActorCapabilityRealizationInvolvement> getInvolvedActorsForCapabilityRealizations(CapabilityRealization context) {
        ArrayList<ActorCapabilityRealizationInvolvement> result = new ArrayList<ActorCapabilityRealizationInvolvement>();
        List<CapabilityRealization> capabilities = this.getRefinedCapabilityRealizations(context);
        if (capabilities != null) {
            for (CapabilityRealization capabilityRealization : capabilities) {
                result.addAll((Collection<ActorCapabilityRealizationInvolvement>)capabilityRealization.getOwnedActorCapabilityRealizations());
            }
        }
        return result;
    }

    public List<RefinementLink> getRefinementLinksChain(CapabilityRealization context) {
        ArrayList<RefinementLink> result = new ArrayList<RefinementLink>(4);
        CapabilityRealization current = context;
        while (current instanceof CapabilityRealization) {
            EList outgoingTraces = current.getOutgoingTraces();
            if (outgoingTraces.isEmpty()) {
                return result;
            }
            for (AbstractTrace trace : outgoingTraces) {
                if (!(trace instanceof RefinementLink)) continue;
                RefinementLink refinementLink = (RefinementLink)trace;
                result.add(refinementLink);
                TraceableElement targetElement = refinementLink.getTargetElement();
                if (targetElement == null || !(targetElement instanceof AbstractCapability)) continue;
                current = (AbstractCapability)targetElement;
            }
            if (!current.equals(context)) continue;
            return result;
        }
        return result;
    }

    public List<ComponentAllocation> getActorsAllocationLinks(CapabilityRealization context) {
        ArrayList<ComponentAllocation> result = new ArrayList<ComponentAllocation>();
        List<AbstractActor> actors = this.getAllRefinedActors(context);
        for (AbstractActor abstractActor : actors) {
            if (abstractActor instanceof PhysicalActor) {
                PhysicalActor pa = (PhysicalActor)abstractActor;
                for (LogicalActorRealization lar : pa.getOwnedLogicalActorRealizations()) {
                    if (!actors.contains(lar.getAllocatedComponent())) continue;
                    result.add((ComponentAllocation)lar);
                }
                continue;
            }
            if (!(abstractActor instanceof LogicalActor)) continue;
            LogicalActor la = (LogicalActor)abstractActor;
            for (SystemActorRealization sar : la.getOwnedSystemActorRealizations()) {
                if (!actors.contains(sar.getAllocatedComponent())) continue;
                result.add((ComponentAllocation)sar);
            }
        }
        return result;
    }
}

