/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.style.BorderedStyleDescription;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.tools.api.command.view.RefreshSiriusElement;
import org.eclipse.sirius.viewpoint.DRefreshable;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.graphics.RGB;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.SimpleOrientedGraph;
import org.polarsys.capella.core.commands.preferences.service.ScopedCapellaPreferencesStore;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalChainContainer;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.FunctionalChainAbstractCapabilityInvolvement;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalProcess;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.ShapeUtil;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class FunctionalChainServices {
    private static final Integer THICK_BORDER_SOURCE_FUNCTION = 4;
    private static final Integer THICK_BORDER_TARGET_FUNCTION = 4;
    private static final Integer THICK_EDGE_FUNCTIONAL_CHAIN = 4;
    private static final String INCOMPLETE_FUNCTIONAL_CHAIN_LABEL = "incomplete";
    private static final String INVALID_FUNCTIONAL_CHAIN_LABEL = "invalid";
    private static FunctionalChainServices singleton = null;

    public static FunctionalChainServices getFunctionalChainServices() {
        if (singleton == null) {
            singleton = new FunctionalChainServices();
        }
        return singleton;
    }

    public Collection<EObject> getFunctionalChainSources(FunctionalChain chain) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (FunctionalExchange exchange : FunctionalChainExt.getFlatFunctionalExchanges((FunctionalChain)chain)) {
            result.add((EObject)exchange.getTarget());
        }
        return result;
    }

    public Collection<EObject> getFunctionalChainTargets(FunctionalChain chain) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (FunctionalExchange exchange : FunctionalChainExt.getFlatFunctionalExchanges((FunctionalChain)chain)) {
            result.add((EObject)exchange.getSource());
        }
        return result;
    }

    public AbstractFunction getBestFunction(AbstractFunction element, Collection<? extends EObject> elements) {
        AbstractFunction current = element;
        while (current != null) {
            if (current instanceof AbstractFunction && elements.contains(current)) {
                return current;
            }
            current = current.eContainer();
        }
        return null;
    }

    public List<FunctionalChain> getFunctionalChainsToInsert(EObject context, DDiagram currentDiagram, List<FunctionalChain> allFunctionalChains) {
        ArrayList<FunctionalChain> returnedList = new ArrayList<FunctionalChain>();
        for (DDiagramElement anObject : DiagramServices.getDiagramServices().getDiagramElements((EObject)currentDiagram)) {
            if (!(anObject.getTarget() instanceof AbstractFunction)) continue;
            AbstractFunction aFunction = (AbstractFunction)anObject.getTarget();
            for (FunctionalChain aFunctionalChain : allFunctionalChains) {
                Set involvedFunctions = FunctionalChainExt.getFlatInvolvedElements((FunctionalChain)aFunctionalChain, (EClass)FaPackage.Literals.ABSTRACT_FUNCTION);
                if (returnedList.contains(aFunctionalChain)) continue;
                if (involvedFunctions.contains(aFunction)) {
                    returnedList.add(aFunctionalChain);
                    continue;
                }
                for (AbstractFunction aSubFunction : FunctionExt.getAllAbstractFunctions((AbstractFunction)aFunction)) {
                    if (!involvedFunctions.contains(aSubFunction)) continue;
                    returnedList.add(aFunctionalChain);
                }
            }
        }
        return returnedList;
    }

    public void updateInternalFunctionalChains(DDiagram diagram) {
        HashMap<FunctionalChain, DNode> functionalChainToNodeMap = this.computeFunctionalChainToNodeMap(diagram);
        HashMap<FunctionalExchange, Set<DEdge>> functionalExchangeToEdgesMap = this.computeFunctionalExchangeToEdgesMap(diagram);
        HashMap<FunctionalChain, Set<DEdge>> functionalChainToEdgesMap = this.computeFunctionalChainToEdgesMap(diagram);
        for (Map.Entry<FunctionalChain, Set<DEdge>> entry : functionalChainToEdgesMap.entrySet()) {
            FunctionalChain functionalChain = entry.getKey();
            if (functionalChainToNodeMap.containsKey(functionalChain)) continue;
            Set<DEdge> edges = entry.getValue();
            for (Object edge : edges) {
                DiagramServices.getDiagramServices().removeEdgeView((DEdge)edge);
            }
        }
        boolean isInOperationalAnalysis = BlockArchitectureExt.getRootBlockArchitecture((EObject)((DSemanticDiagram)diagram).getTarget()) instanceof OperationalAnalysis;
        if (!isInOperationalAnalysis) {
            for (Map.Entry<FunctionalChain, Object> entry : functionalChainToNodeMap.entrySet()) {
                Object edge;
                FunctionalChain functionalChain = entry.getKey();
                edge = this.createNecessaryInternalLinks(functionalChain, functionalExchangeToEdgesMap);
            }
        }
        for (Map.Entry<FunctionalChain, Object> entry : functionalChainToEdgesMap.entrySet()) {
            FunctionalChain chain = entry.getKey();
            Set edges = (Set)entry.getValue();
            for (DEdge edge : edges) {
                if (this.isValidInternalLinkEdge(chain, edge.getSourceNode(), edge.getTargetNode())) continue;
                DiagramServices.getDiagramServices().removeEdgeView(edge);
            }
        }
    }

    public void updateFunctionalChainStyles(DDiagram diagram) {
        HashMap<FunctionalChain, DNode> functionalChainToNodeMap = this.computeFunctionalChainToNodeMap(diagram);
        HashMap<FunctionalChain, Set<DEdge>> functionalChainToEdgesMap = this.computeFunctionalChainToEdgesMap(diagram);
        HashMap<AbstractFunction, Set<DDiagramElement>> functionToDiagramElementsMap = this.computeFunctionToDiagramElementsMap(diagram);
        HashMap<FunctionalExchange, Set<DEdge>> functionalExchangeToEdgesMap = this.computeFunctionalExchangeToEdgesMap(diagram);
        HashMap<DDiagramElement, Set<FunctionalChain>> coloredNodeToFunctionalChainsMap = this.computeColoredNodeToFunctionalChainsMap(functionalChainToNodeMap, functionToDiagramElementsMap);
        HashMap<DEdge, Set<FunctionalChain>> coloredEdgeToFunctionalChainsMap = this.computeColoredEdgeToFunctionalChainsMap(functionalChainToNodeMap, functionalExchangeToEdgesMap);
        for (Map.Entry<AbstractFunction, Set<DDiagramElement>> entry : functionToDiagramElementsMap.entrySet()) {
            Set<DDiagramElement> functionNodes = entry.getValue();
            for (DDiagramElement functionNode : functionNodes) {
                if (coloredNodeToFunctionalChainsMap.containsKey(functionNode)) continue;
                this.resetFunctionStyle(functionNode);
            }
        }
        for (Map.Entry<AbstractFunction, Set<DDiagramElement>> entry : functionalChainToNodeMap.entrySet()) {
            RGBValues color;
            Set<Object> functionNodes;
            FunctionalChain functionalChain = (FunctionalChain)entry.getKey();
            DNode functionalChainNode = (DNode)entry.getValue();
            this.updateFunctionalChainNodeColor(functionalChainNode, functionalChainToNodeMap.values());
            RGBValues functionalChainColor = ShapeUtil.getNodeColorStyle(functionalChainNode);
            if (functionalChainColor == null) continue;
            for (AbstractFunction function : FunctionalChainExt.getFlatFunctionalChainFirstFunctions((FunctionalChain)functionalChain)) {
                functionNodes = this.getBestDisplayedFunctionNode(function, functionToDiagramElementsMap);
                functionNodes = functionNodes == null ? new HashSet() : functionNodes;
                for (Object functionNode : functionNodes) {
                    color = coloredNodeToFunctionalChainsMap.get(functionNode).size() == 1 ? functionalChainColor : ShapeUtil.getBlackColor();
                    this.customizeSourceFunctionStyle((DDiagramElement)functionNode, color);
                }
            }
            for (AbstractFunction function : FunctionalChainExt.getFlatFunctionalChainLastFunctions((FunctionalChain)functionalChain)) {
                functionNodes = this.getBestDisplayedFunctionNode(function, functionToDiagramElementsMap);
                functionNodes = functionNodes == null ? new HashSet() : functionNodes;
                for (Object functionNode : functionNodes) {
                    color = coloredNodeToFunctionalChainsMap.get(functionNode).size() == 1 ? functionalChainColor : ShapeUtil.getBlackColor();
                    this.customizeTargetFunctionStyle((DDiagramElement)functionNode, color);
                }
            }
            boolean isInOperationalAnalysis = BlockArchitectureExt.getRootBlockArchitecture((EObject)((DSemanticDiagram)diagram).getTarget()) instanceof OperationalAnalysis;
            if (!isInOperationalAnalysis) {
                Object functionNode;
                HashSet internalLinks = functionalChainToEdgesMap.get(functionalChain);
                internalLinks = internalLinks == null ? new HashSet() : internalLinks;
                internalLinks.remove(null);
                functionNode = internalLinks.iterator();
                while (functionNode.hasNext()) {
                    DEdge internalLink = (DEdge)functionNode.next();
                    this.customizeInternalLinksEdgeStyle(internalLink, functionalChainColor);
                }
            }
            for (FunctionalExchange functionalExchange : FunctionalChainExt.getFlatFunctionalExchanges((FunctionalChain)functionalChain)) {
                if (!functionalExchangeToEdgesMap.containsKey(functionalExchange)) continue;
                Set<DEdge> edges = functionalExchangeToEdgesMap.get(functionalExchange);
                for (DEdge edge : edges) {
                    RGBValues color2 = coloredEdgeToFunctionalChainsMap.get(edge).size() == 1 ? functionalChainColor : ShapeUtil.getBlackColor();
                    this.customizeFunctionalExchangeEdgeStyle(edge, color2);
                }
            }
            RefreshSiriusElement.refresh((DRefreshable)functionalChainNode);
        }
        for (Set set : functionalExchangeToEdgesMap.values()) {
            for (DEdge edge : set) {
                if (coloredEdgeToFunctionalChainsMap.containsKey(edge)) continue;
                this.resetFunctionalExchangeStyle(edge);
            }
        }
    }

    private HashMap<DEdge, Set<FunctionalChain>> computeColoredEdgeToFunctionalChainsMap(HashMap<FunctionalChain, DNode> functionalChainToNodeMap, HashMap<FunctionalExchange, Set<DEdge>> functionalExchangeToEdgesMap) {
        HashMap<DEdge, Set<FunctionalChain>> coloredEdgeToFunctionalChainsMap = new HashMap<DEdge, Set<FunctionalChain>>();
        for (Map.Entry<FunctionalChain, DNode> entry : functionalChainToNodeMap.entrySet()) {
            FunctionalChain functionalChain = entry.getKey();
            for (FunctionalExchange anExchange : FunctionalChainExt.getFlatFunctionalExchanges((FunctionalChain)functionalChain)) {
                if (!functionalExchangeToEdgesMap.containsKey(anExchange)) continue;
                Set<DEdge> exchangeEdges = functionalExchangeToEdgesMap.get(anExchange);
                for (DEdge exchangeEdge : exchangeEdges) {
                    Set<FunctionalChain> functionalChains = coloredEdgeToFunctionalChainsMap.get(exchangeEdge);
                    if (functionalChains == null) {
                        functionalChains = new HashSet<FunctionalChain>();
                        coloredEdgeToFunctionalChainsMap.put(exchangeEdge, functionalChains);
                    }
                    functionalChains.add(functionalChain);
                }
            }
        }
        return coloredEdgeToFunctionalChainsMap;
    }

    private HashMap<DDiagramElement, Set<FunctionalChain>> computeColoredNodeToFunctionalChainsMap(HashMap<FunctionalChain, DNode> functionalChainToNodeMap, HashMap<AbstractFunction, Set<DDiagramElement>> functionToDiagramElementsMap) {
        HashMap<DDiagramElement, Set<FunctionalChain>> coloredElementToFunctionalChainsMap = new HashMap<DDiagramElement, Set<FunctionalChain>>();
        for (Map.Entry<FunctionalChain, DNode> entry : functionalChainToNodeMap.entrySet()) {
            FunctionalChain functionalChain = entry.getKey();
            HashSet fcFunctions = new HashSet();
            Set fcSourceFunctions = FunctionalChainExt.getFlatFunctionalChainFirstFunctions((FunctionalChain)functionalChain);
            Set fcTargetFunctions = FunctionalChainExt.getFlatFunctionalChainLastFunctions((FunctionalChain)functionalChain);
            fcFunctions.addAll(fcSourceFunctions);
            fcFunctions.addAll(fcTargetFunctions);
            for (AbstractFunction function : fcFunctions) {
                Set<DDiagramElement> functionNodes = this.getBestDisplayedFunctionNode(function, functionToDiagramElementsMap);
                if (functionNodes == null) continue;
                for (DDiagramElement functionNode : functionNodes) {
                    Set<FunctionalChain> functionalChains = coloredElementToFunctionalChainsMap.get(functionNode);
                    if (functionalChains == null) {
                        functionalChains = new HashSet<FunctionalChain>();
                        coloredElementToFunctionalChainsMap.put(functionNode, functionalChains);
                    }
                    functionalChains.add(functionalChain);
                }
            }
        }
        return coloredElementToFunctionalChainsMap;
    }

    private HashMap<FunctionalChain, Set<DEdge>> computeFunctionalChainToEdgesMap(DDiagram diagram) {
        HashMap<FunctionalChain, Set<DEdge>> functionalChainToEdgesMap = new HashMap<FunctionalChain, Set<DEdge>>();
        for (DEdge edge : diagram.getEdges()) {
            EObject edgeTarget = edge.getTarget();
            if (!(edgeTarget instanceof FunctionalChain)) continue;
            FunctionalChain fc = (FunctionalChain)edgeTarget;
            Set<DEdge> edges = functionalChainToEdgesMap.get(fc);
            if (edges == null) {
                edges = new HashSet<DEdge>();
                functionalChainToEdgesMap.put(fc, edges);
            }
            edges.add(edge);
        }
        return functionalChainToEdgesMap;
    }

    private HashMap<FunctionalExchange, Set<DEdge>> computeFunctionalExchangeToEdgesMap(DDiagram diagram) {
        HashMap<FunctionalExchange, Set<DEdge>> functionalExchangeToEdgesMap = new HashMap<FunctionalExchange, Set<DEdge>>();
        for (DEdge edge : diagram.getEdges()) {
            EObject edgeTarget = edge.getTarget();
            if (!(edgeTarget instanceof FunctionalExchange)) continue;
            FunctionalExchange fe = (FunctionalExchange)edgeTarget;
            Set<DEdge> edges = functionalExchangeToEdgesMap.get(fe);
            if (edges == null) {
                edges = new HashSet<DEdge>();
                functionalExchangeToEdgesMap.put(fe, edges);
            }
            edges.add(edge);
        }
        return functionalExchangeToEdgesMap;
    }

    private HashMap<AbstractFunction, Set<DDiagramElement>> computeFunctionToDiagramElementsMap(DDiagram diagram) {
        Set<DDiagramElement> set;
        EObject target;
        HashMap<AbstractFunction, Set<DDiagramElement>> functionToDiagramElementsMap = new HashMap<AbstractFunction, Set<DDiagramElement>>();
        for (DNode aNode : diagram.getNodes()) {
            target = aNode.getTarget();
            if (!(target instanceof AbstractFunction)) continue;
            set = functionToDiagramElementsMap.get(target);
            if (set == null) {
                set = new HashSet<DDiagramElement>();
                functionToDiagramElementsMap.put((AbstractFunction)target, set);
            }
            set.add((DDiagramElement)aNode);
        }
        for (DDiagramElement aContainer : diagram.getContainers()) {
            target = aContainer.getTarget();
            if (!(target instanceof AbstractFunction)) continue;
            set = functionToDiagramElementsMap.get(target);
            if (set == null) {
                set = new HashSet<DDiagramElement>();
                functionToDiagramElementsMap.put((AbstractFunction)target, set);
            }
            set.add(aContainer);
        }
        return functionToDiagramElementsMap;
    }

    private HashMap<FunctionalChain, DNode> computeFunctionalChainToNodeMap(DDiagram diagram) {
        HashMap<FunctionalChain, DNode> functionalChainToNodeMap = new HashMap<FunctionalChain, DNode>();
        for (DDiagramElement aNode : diagram.getOwnedDiagramElements()) {
            if (!(aNode instanceof DNode) || !(aNode.getTarget() instanceof FunctionalChain)) continue;
            functionalChainToNodeMap.put((FunctionalChain)aNode.getTarget(), (DNode)aNode);
        }
        return functionalChainToNodeMap;
    }

    private boolean isValidNodeForInternalLink(EdgeTarget currentNode) {
        if (!(currentNode instanceof DNode)) {
            return false;
        }
        return DiagramServices.getDiagramServices().isABorderedNode((AbstractDNode)((DNode)currentNode));
    }

    private Set<DEdge> createNecessaryInternalLinks(FunctionalChain functionalChain, Map<FunctionalExchange, Set<DEdge>> displayedFunctionalExchanges) {
        HashSet<DEdge> newInternalLinks = new HashSet<DEdge>();
        for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvementsOf((FunctionalChain)functionalChain, (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE)) {
            FunctionalExchange functionalExchange = (FunctionalExchange)involvement.getInvolved();
            Collection<FunctionalExchange> previousExchanges = this.getFlatPreviousFunctionalExchanges(functionalChain, involvement);
            Collection<FunctionalExchange> nextExchanges = this.getFlatNextFunctionalExchanges(functionalChain, involvement);
            HashSet currentEdges = displayedFunctionalExchanges.get(functionalExchange);
            currentEdges = currentEdges == null ? new HashSet() : currentEdges;
            for (DEdge currentEdge : currentEdges) {
                EdgeTarget currentTargetNode;
                EdgeTarget internalLinkTargetNode;
                if (currentEdge == null) continue;
                EdgeTarget currentSourceNode = currentEdge.getSourceNode();
                if (this.isValidNodeForInternalLink(currentSourceNode)) {
                    for (FunctionalExchange prevFE : previousExchanges) {
                        HashSet prevEdges = displayedFunctionalExchanges.get(prevFE);
                        prevEdges = prevEdges == null ? new HashSet() : prevEdges;
                        prevEdges.remove(null);
                        for (DEdge prevEdge : prevEdges) {
                            DEdge internalLink;
                            EdgeTarget internalLinkSourceNode = prevEdge.getTargetNode();
                            internalLinkTargetNode = currentSourceNode;
                            if (!this.isValidNodeForInternalLink(internalLinkSourceNode) || !this.isValidInternalLinkEdge(functionalChain, internalLinkSourceNode, internalLinkTargetNode) || (internalLink = this.getExistingInternalLink(internalLinkSourceNode, internalLinkTargetNode, functionalChain)) != null) continue;
                            internalLink = this.createInternalLink(internalLinkSourceNode, internalLinkTargetNode, functionalChain);
                            newInternalLinks.add(internalLink);
                        }
                    }
                }
                if (!this.isValidNodeForInternalLink(currentTargetNode = currentEdge.getTargetNode())) continue;
                for (FunctionalExchange nextFE : nextExchanges) {
                    HashSet nextEdges = displayedFunctionalExchanges.get(nextFE);
                    nextEdges = nextEdges == null ? new HashSet() : nextEdges;
                    nextEdges.remove(null);
                    for (DEdge nextEdge : nextEdges) {
                        DEdge internalLink;
                        internalLinkTargetNode = nextEdge.getSourceNode();
                        EdgeTarget internalLinkSourceNode = currentTargetNode;
                        if (!this.isValidNodeForInternalLink(internalLinkTargetNode) || !this.isValidInternalLinkEdge(functionalChain, internalLinkSourceNode, internalLinkTargetNode) || (internalLink = this.getExistingInternalLink(internalLinkSourceNode, internalLinkTargetNode, functionalChain)) != null) continue;
                        internalLink = this.createInternalLink(internalLinkSourceNode, internalLinkTargetNode, functionalChain);
                        newInternalLinks.add(internalLink);
                    }
                }
            }
        }
        return newInternalLinks;
    }

    public boolean isValidInternalLinkEdge(FunctionalChain chain, EdgeTarget currentSourceNode, EdgeTarget currentTargetNode) {
        if (currentSourceNode == null || currentSourceNode.getIncomingEdges().isEmpty()) {
            return false;
        }
        if (currentTargetNode == null || currentTargetNode.getOutgoingEdges().isEmpty()) {
            return false;
        }
        if (!this.hasVisibleEdge((EList<DEdge>)currentSourceNode.getIncomingEdges())) {
            return false;
        }
        if (!this.hasVisibleEdge((EList<DEdge>)currentTargetNode.getOutgoingEdges())) {
            return false;
        }
        EObject sourceParent = currentSourceNode.eContainer();
        EObject targetParent = currentTargetNode.eContainer();
        if (sourceParent != null && targetParent != null) {
            return sourceParent.equals(targetParent);
        }
        return false;
    }

    private boolean hasVisibleEdge(EList<DEdge> edges) {
        for (DEdge edge : edges) {
            if (DiagramServices.getDiagramServices().isHidden((DDiagramElement)edge)) continue;
            return true;
        }
        return false;
    }

    protected DEdge getExistingInternalLink(EdgeTarget sourceNode, EdgeTarget targetNode, FunctionalChain fc) {
        DEdge internalLink = null;
        for (DEdge edge : DiagramServices.getDiagramServices().getOutgoingEdges(sourceNode)) {
            if (!(edge.getTarget() instanceof FunctionalChain) || !edge.getTarget().equals(fc) || !targetNode.equals(edge.getTargetNode())) continue;
            internalLink = edge;
            break;
        }
        return internalLink;
    }

    protected Collection<FunctionalExchange> getFlatPreviousFunctionalExchanges(FunctionalChain fc, FunctionalChainInvolvement fci) {
        HashSet<FunctionalExchange> result = new HashSet<FunctionalExchange>();
        for (FunctionalChainInvolvement involvment : FunctionalChainExt.getFlatPreviousExchangeInvolvements((FunctionalChainInvolvement)fci)) {
            if (involvment.getInvolved() == null || !(involvment.getInvolved() instanceof FunctionalExchange)) continue;
            result.add((FunctionalExchange)involvment.getInvolved());
        }
        return result;
    }

    protected Collection<FunctionalExchange> getFlatNextFunctionalExchanges(FunctionalChain fc, FunctionalChainInvolvement fci) {
        HashSet<FunctionalExchange> result = new HashSet<FunctionalExchange>();
        for (FunctionalChainInvolvement involvment : FunctionalChainExt.getFlatNextExchangeInvolvements((FunctionalChainInvolvement)fci)) {
            if (involvment.getInvolved() == null || !(involvment.getInvolved() instanceof FunctionalExchange)) continue;
            result.add((FunctionalExchange)involvment.getInvolved());
        }
        return result;
    }

    public DEdge createInternalLink(EdgeTarget sourceNode, EdgeTarget targetNode, FunctionalChain fc) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceNode);
        EdgeMapping mapping = this.getInternLinkEdgeMapping(diagram);
        DEdge newEdge = DiagramServices.getDiagramServices().findDEdgeElement(diagram, sourceNode, targetNode, (EObject)fc, mapping);
        if (newEdge == null) {
            DiagramServices.getDiagramServices().createEdge(mapping, sourceNode, targetNode, (EObject)fc);
            newEdge = DiagramServices.getDiagramServices().findDEdgeElement(diagram, sourceNode, targetNode, (EObject)fc, mapping);
        }
        return newEdge;
    }

    public EdgeMapping getInternLinkEdgeMapping(DDiagram diagram) {
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, MappingConstantsHelper.getInternLinkEdgeMapping(diagram));
    }

    public void resetFunctionalExchangeStyle(DEdge aEdge) {
        DiagramElementMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(aEdge);
        if (mapping != null) {
            EdgeStyleDescription desc = (EdgeStyleDescription)this.getMappingHelper((DSemanticDecorator)aEdge).getBestStyleDescription(mapping, aEdge.getTarget(), (EObject)aEdge, aEdge.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)aEdge));
            String defaultStyleSize = desc.getSizeComputationExpression();
            EdgeStyle edgeStyle = aEdge.getOwnedStyle();
            Integer currentSize = edgeStyle.getSize();
            if (currentSize != null && defaultStyleSize != null && (currentSize.equals(THICK_EDGE_FUNCTIONAL_CHAIN) || currentSize.equals(defaultStyleSize)) && ShapeUtil.resetEdgeThickStyle(aEdge, Integer.valueOf(defaultStyleSize))) {
                ShapeUtil.resetEdgeColorStyle(aEdge, ShapeUtil.getDefaultColor((DSemanticDecorator)aEdge, (EObject)desc, desc.getStrokeColor()));
            }
        }
    }

    public boolean resetFunctionStyle(DDiagramElement functionNode) {
        boolean result = false;
        String defaultStyleSize = null;
        Integer currentSize = null;
        BorderedStyle style = null;
        if (functionNode instanceof AbstractDNode) {
            AbstractDNode node = (AbstractDNode)functionNode;
            BorderedStyleDescription desc = (BorderedStyleDescription)this.getMappingHelper((DSemanticDecorator)functionNode).getBestStyleDescription(functionNode.getDiagramElementMapping(), functionNode.getTarget(), (EObject)functionNode, functionNode.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)functionNode));
            if (desc != null) {
                defaultStyleSize = desc.getBorderSizeComputationExpression();
                style = (BorderedStyle)ShapeUtil.getCurrentStyle((DDiagramElement)node);
                if (style != null) {
                    currentSize = style.getBorderSize();
                }
                if (currentSize != null && defaultStyleSize != null && (currentSize.equals(THICK_BORDER_SOURCE_FUNCTION) || currentSize.equals(THICK_BORDER_TARGET_FUNCTION) || currentSize.equals(defaultStyleSize)) && ShapeUtil.resetBorderStyle(node, Integer.valueOf(desc.getBorderSizeComputationExpression())) && ShapeUtil.resetBorderColorStyle(node, ShapeUtil.getDefaultColor((DSemanticDecorator)node, (EObject)desc, desc.getBorderColor()))) {
                    result = true;
                }
            }
        }
        return result;
    }

    public void customizeFunctionalExchangeEdgeStyle(DEdge edge, RGBValues color) {
        String defaultSize;
        EdgeStyleDescription desc;
        EdgeStyle edgeStyle = edge.getOwnedStyle();
        Integer currentSize = edgeStyle.getSize();
        DiagramElementMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(edge);
        if (mapping != null && (desc = (EdgeStyleDescription)this.getMappingHelper((DSemanticDecorator)edge).getBestStyleDescription(mapping, edge.getTarget(), (EObject)edge, edge.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)edge))) != null && (defaultSize = desc.getSizeComputationExpression()) != null && currentSize != null && (currentSize.equals(Integer.valueOf(defaultSize)) || currentSize.equals(THICK_EDGE_FUNCTIONAL_CHAIN))) {
            this.customizeEdgeStyle(edge, color);
        }
    }

    public void customizeInternalLinksEdgeStyle(DEdge edge, RGBValues color) {
        this.customizeEdgeStyle(edge, color);
    }

    public void customizeEdgeStyle(DEdge edge, RGBValues color) {
        RGB rgbColor = new RGB(color.getRed(), color.getGreen(), color.getBlue());
        ShapeUtil.setEdgeColorStyle(edge, rgbColor);
        ShapeUtil.setEdgeThickStyle(edge, THICK_EDGE_FUNCTIONAL_CHAIN);
    }

    public void customizeFunctionStyle(DDiagramElement functionNode, RGBValues color) {
        RGB rgbColor = new RGB(color.getRed(), color.getGreen(), color.getBlue());
        if (functionNode instanceof AbstractDNode) {
            ShapeUtil.setBorderColorStyle((AbstractDNode)functionNode, rgbColor);
        }
    }

    public void customizeSourceFunctionStyle(DDiagramElement functionNode, RGBValues color) {
        this.customizeFunctionStyle(functionNode, color);
        if (functionNode instanceof AbstractDNode) {
            ShapeUtil.setBorderStyle((AbstractDNode)functionNode, THICK_BORDER_SOURCE_FUNCTION);
        }
    }

    public void customizeTargetFunctionStyle(DDiagramElement functionNode, RGBValues color) {
        this.customizeFunctionStyle(functionNode, color);
        if (functionNode instanceof AbstractDNode) {
            ShapeUtil.setBorderStyle((AbstractDNode)functionNode, THICK_BORDER_TARGET_FUNCTION);
        }
    }

    public Set<DDiagramElement> getBestDisplayedFunctionNode(AbstractFunction function, Map<AbstractFunction, Set<DDiagramElement>> displayedFunctions) {
        if (displayedFunctions.containsKey(function)) {
            return displayedFunctions.get(function);
        }
        EObject ancestor = function.eContainer();
        while (ancestor != null && ancestor instanceof AbstractFunction) {
            if (displayedFunctions.containsKey(ancestor)) {
                return displayedFunctions.get(ancestor);
            }
            ancestor = ancestor.eContainer();
        }
        return null;
    }

    public boolean isCompleteFunctionalChain(FunctionalChain fc, DDiagram diagram) {
        Set functionalExchangesOnTheChain = FunctionalChainExt.getFlatFunctionalExchanges((FunctionalChain)fc);
        int numberOfVisibleRelatedFEEdges = 0;
        for (DEdge anEdge : diagram.getEdges()) {
            EObject edgeTarget;
            if (!anEdge.isVisible() || !((edgeTarget = anEdge.getTarget()) instanceof FunctionalExchange) || !functionalExchangesOnTheChain.contains(edgeTarget)) continue;
            ++numberOfVisibleRelatedFEEdges;
        }
        return numberOfVisibleRelatedFEEdges == functionalExchangesOnTheChain.size();
    }

    public String getFunctionalChainLabel(FunctionalChain fc, DDiagram diagram) {
        boolean displayInvalidLabel;
        String label = EObjectExt.getText((EObject)fc);
        boolean isComplete = this.isCompleteFunctionalChain(fc, diagram);
        boolean isValid = FunctionalChainExt.isFunctionalChainValid((FunctionalChain)fc);
        boolean displayIncompleteLabel = !isComplete;
        boolean bl = displayInvalidLabel = !isValid;
        if (fc instanceof OperationalProcess) {
            displayIncompleteLabel &= ScopedCapellaPreferencesStore.getBoolean((String)"org.polarsys.capella.core.sirius.analysis.preferences.diagrams.operationalprocess.label.incomplete", (IProject)PreferencesHelper.getProject((EObject)fc));
            displayInvalidLabel &= ScopedCapellaPreferencesStore.getBoolean((String)"org.polarsys.capella.core.sirius.analysis.preferences.diagrams.operationalprocess.label.invalid", (IProject)PreferencesHelper.getProject((EObject)fc));
        } else {
            displayIncompleteLabel &= ScopedCapellaPreferencesStore.getBoolean((String)"org.polarsys.capella.core.sirius.analysis.preferences.diagrams.functionalchain.label.incomplete", (IProject)PreferencesHelper.getProject((EObject)fc));
            displayInvalidLabel &= ScopedCapellaPreferencesStore.getBoolean((String)"org.polarsys.capella.core.sirius.analysis.preferences.diagrams.functionalchain.label.invalid", (IProject)PreferencesHelper.getProject((EObject)fc));
        }
        if (displayIncompleteLabel || displayInvalidLabel) {
            label = String.valueOf(label) + " (";
        }
        if (displayIncompleteLabel) {
            label = String.valueOf(label) + INCOMPLETE_FUNCTIONAL_CHAIN_LABEL;
        }
        if (displayIncompleteLabel && displayInvalidLabel) {
            label = String.valueOf(label) + ", ";
        }
        if (displayInvalidLabel) {
            label = String.valueOf(label) + INVALID_FUNCTIONAL_CHAIN_LABEL;
        }
        if (displayIncompleteLabel || displayInvalidLabel) {
            label = String.valueOf(label) + ")";
        }
        return label;
    }

    public void updateFunctionalChainNodeColor(DNode fcNode, Collection<DNode> visibleFunctionalChains) {
        RGBValues color = ShapeUtil.getNodeColorStyle(fcNode);
        LinkedList<RGB> colorList = new LinkedList<RGB>();
        RGB blue = new RGB(24, 114, 248);
        RGB yellow = new RGB(249, 252, 103);
        RGB purple = new RGB(160, 32, 240);
        RGB gray = new RGB(136, 136, 136);
        RGB orange = new RGB(255, 165, 0);
        RGB green = new RGB(34, 139, 34);
        RGB brown = new RGB(165, 42, 42);
        colorList.addLast(blue);
        colorList.addLast(brown);
        colorList.addLast(orange);
        colorList.addLast(green);
        colorList.addLast(purple);
        colorList.addLast(yellow);
        colorList.addLast(gray);
        boolean changeColor = false;
        if (ShapeUtil.isSameColor(color, gray)) {
            changeColor = true;
        }
        for (DNode aFc : visibleFunctionalChains) {
            if (aFc.equals(fcNode)) continue;
            RGBValues nodeColor = ShapeUtil.getNodeColorStyle(aFc);
            if (ShapeUtil.isSameColor(nodeColor, color)) {
                changeColor = true;
            }
            ShapeUtil.removeColorFromList(nodeColor, colorList);
        }
        if (!changeColor) {
            return;
        }
        if (!colorList.isEmpty()) {
            ShapeUtil.setColorStyle(fcNode, (RGB)colorList.get(0));
        }
    }

    public List<FunctionalExchange> getAvailableExchanges(EObject context, AbstractFunction source, AbstractFunction target) {
        ArrayList<FunctionalExchange> returnedFunctionalExchanges = new ArrayList<FunctionalExchange>();
        List incoming = FunctionExt.getIncomingExchange((AbstractFunction)target);
        List outgoing = FunctionExt.getOutGoingExchange((AbstractFunction)source);
        for (FunctionalExchange aFunctionalExchange : incoming) {
            if (!outgoing.contains(aFunctionalExchange)) continue;
            returnedFunctionalExchanges.add(aFunctionalExchange);
        }
        return returnedFunctionalExchanges;
    }

    public List<FunctionalChainInvolvement> getPreviousInvolvements(FunctionalChainInvolvement involvement) {
        return involvement.getPreviousFunctionalChainInvolvements();
    }

    public EObject createFunctionalChain(EObject context, List<EObject> views) {
        if (!views.isEmpty()) {
            ArrayList<EObject> newList = new ArrayList<EObject>();
            AbstractFunction aFunction = null;
            for (EObject aSelectedElement : views) {
                if (!(aSelectedElement instanceof DDiagramElement) || ((DDiagramElement)aSelectedElement).getTarget() == null) continue;
                newList.add(((DDiagramElement)aSelectedElement).getTarget());
                if (aFunction != null || !(((DDiagramElement)aSelectedElement).getTarget() instanceof FunctionalExchange)) continue;
                AbstractFunction aSourceFunction = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)((FunctionalExchange)((DDiagramElement)aSelectedElement).getTarget()));
                aFunction = FunctionExt.getRootFunction((AbstractFunction)aSourceFunction);
            }
            if (aFunction != null) {
                EObject diagramContainer = ((DSemanticDiagram)CapellaServices.getService().getDiagramContainer(views.get(0))).getTarget();
                FunctionalChain newFC = diagramContainer instanceof AbstractFunctionalChainContainer ? FunctionalChainExt.createFunctionalChain((AbstractFunctionalChainContainer)((AbstractFunctionalChainContainer)diagramContainer), newList) : FunctionalChainExt.createFunctionalChain(aFunction, newList);
                return newFC;
            }
        }
        return context;
    }

    public void removeFunctionalChainAbstractCapabilityInvolvement(AbstractCapability capability, EObject target) {
        HashSet<FunctionalChainAbstractCapabilityInvolvement> toRemove = new HashSet<FunctionalChainAbstractCapabilityInvolvement>();
        for (FunctionalChainAbstractCapabilityInvolvement inv : capability.getOwnedFunctionalChainAbstractCapabilityInvolvements()) {
            if (!inv.getInvolved().equals(target)) continue;
            toRemove.add(inv);
        }
        for (FunctionalChainAbstractCapabilityInvolvement involvement : toRemove) {
            involvement.destroy();
        }
    }

    public FunctionalChainAbstractCapabilityInvolvement createFunctionalChainAbstractCapabilityInvolvement(AbstractCapability capability, FunctionalChain target) {
        return FunctionalChainExt.createFunctionalChainAbstractCapabilityInvolvement((AbstractCapability)capability, (FunctionalChain)target);
    }

    public boolean isValidFunctionalChainSelection(EObject context, List<EObject> views) {
        SimpleOrientedGraph graph = new SimpleOrientedGraph();
        if (!views.isEmpty()) {
            for (EObject aSelectedElement : views) {
                if (!(aSelectedElement instanceof DEdge) || ((DEdge)aSelectedElement).getTarget() == null || !(((DEdge)aSelectedElement).getTarget() instanceof FunctionalExchange)) continue;
                FunctionalExchange aSelectedExchange = (FunctionalExchange)((DEdge)aSelectedElement).getTarget();
                AbstractFunction sourceFunction = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)aSelectedExchange);
                AbstractFunction targetFunction = FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)aSelectedExchange);
                graph.addNode((Object)sourceFunction, (Object)targetFunction);
            }
            if (!graph.isEmpty()) {
                return graph.isValid();
            }
            return false;
        }
        return false;
    }

    public List<AbstractFunction> getFCDInvolveFunctionScope(EObject container) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)container);
        return FunctionExt.getAllAbstractFunctions((BlockArchitecture)architecture);
    }

    protected List<FunctionalExchange> getOutgoingEdgeFunctionalExchanges(DNode node) {
        ArrayList<FunctionalExchange> existingInvolvedFE = new ArrayList<FunctionalExchange>();
        for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)node)) {
            FunctionalChainInvolvement currentInv;
            if (anEdge.getTarget() == null || !(anEdge.getTarget() instanceof FunctionalChainInvolvement) || (currentInv = (FunctionalChainInvolvement)anEdge.getTarget()).getInvolved() == null || !(currentInv.getInvolved() instanceof FunctionalExchange)) continue;
            existingInvolvedFE.add((FunctionalExchange)currentInv.getInvolved());
        }
        return existingInvolvedFE;
    }

    public List<FunctionalExchange> getFCDInvolveFunctionalExchangeAndFunctionScope(DNode node) {
        ArrayList<FunctionalExchange> returnedList = new ArrayList<FunctionalExchange>();
        List<FunctionalExchange> existingInvolvedFE = this.getOutgoingEdgeFunctionalExchanges(node);
        FunctionalChainInvolvement selectedInvolvement = (FunctionalChainInvolvement)node.getTarget();
        for (FunctionalExchange aFE : FunctionalChainExt.getFlatOutgoingExchanges((FunctionalChainInvolvement)selectedInvolvement)) {
            if (existingInvolvedFE.contains(aFE)) continue;
            returnedList.add(aFE);
        }
        return returnedList;
    }

    public HashMapSet<FunctionalExchange, FunctionalChain> getFCDInvolveFunctionalExchangeAndFunctionalChainScope(DNode node) {
        HashMapSet<FunctionalExchange, FunctionalChain> set = new HashMapSet<FunctionalExchange, FunctionalChain>();
        if (node == null || node.getTarget() == null || node.getTarget().eIsProxy()) {
            return set;
        }
        EObject target = node.getTarget();
        if (!(target instanceof FunctionalChainInvolvement)) {
            return set;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)node);
        if (!(diagram instanceof DSemanticDecorator)) {
            return set;
        }
        List<FunctionalExchange> existingInvolvedFE = this.getOutgoingEdgeFunctionalExchanges(node);
        FunctionalChainInvolvement involvement = (FunctionalChainInvolvement)target;
        Collection outgoing = FunctionalChainExt.getFlatOutgoingExchanges((FunctionalChainInvolvement)involvement);
        Collection<FunctionalChain> chains = this.getFCDInvolveFunctionalChainScope((DSemanticDecorator)diagram);
        for (FunctionalChain chain : chains) {
            Collection incoming = FunctionalChainExt.getFlatIncomingExchanges((FunctionalChain)chain);
            incoming.retainAll(outgoing);
            for (FunctionalExchange exchange : incoming) {
                if (existingInvolvedFE.contains(exchange)) continue;
                set.put(exchange, chain);
            }
        }
        return set;
    }

    public HashMapSet<FunctionalExchange, FunctionalChain> getFCDInvolveFunctionalExchangeAndFunctionalChainInitialSelection(AbstractDNode context) {
        return new HashMapSet<FunctionalExchange, FunctionalChain>();
    }

    public void involvedFCDFunctionalExchangeFunctionalChain(AbstractDNode context, HashMapSet<FunctionalExchange, FunctionalChain> scope, HashMapSet<FunctionalExchange, FunctionalChain> initialSelection, HashMapSet<FunctionalExchange, FunctionalChain> selection) {
        if (context == null) {
            return;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        if (diagram == null || !(diagram instanceof DSemanticDecorator)) {
            return;
        }
        FunctionalChain sourceFC = (FunctionalChain)((DSemanticDecorator)diagram).getTarget();
        EObject target = context.getTarget();
        if (target == null || target.eIsProxy() || !(target instanceof FunctionalChainInvolvement)) {
            return;
        }
        FunctionalChainInvolvement iSource = (FunctionalChainInvolvement)context.getTarget();
        for (FunctionalExchange exchange : selection.keySet()) {
            Iterator iterator = selection.get(exchange).iterator();
            while (iterator.hasNext()) {
                FunctionalChain chain = (FunctionalChain)iterator.next();
                FunctionalChainInvolvement iExchange = FaFactory.eINSTANCE.createFunctionalChainInvolvement();
                iExchange.setInvolved((InvolvedElement)exchange);
                sourceFC.getOwnedFunctionalChainInvolvements().add((Object)iExchange);
                iSource.getNextFunctionalChainInvolvements().add((Object)iExchange);
                FunctionalChainReference iChain = FaFactory.eINSTANCE.createFunctionalChainReference();
                iChain.setInvolved((InvolvedElement)chain);
                sourceFC.getOwnedFunctionalChainInvolvements().add((Object)iChain);
                iExchange.getNextFunctionalChainInvolvements().add((Object)iChain);
                AbstractNodeMapping nodeMapping = DiagramServices.getDiagramServices().getAbstractNodeMapping(diagram, "FC_FunctionalChain");
                if (nodeMapping == null) {
                    return;
                }
                AbstractDNode node = DiagramServices.getDiagramServices().createAbstractDNode(nodeMapping, (EObject)iChain, (DragAndDropTarget)diagram, diagram);
                if (node == null) {
                    return;
                }
                EdgeMapping edgeMapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, "FC_Exchange");
                if (edgeMapping == null) {
                    return;
                }
                DiagramServices.getDiagramServices().createEdge(edgeMapping, (EdgeTarget)context, (EdgeTarget)node, (EObject)iExchange);
            }
        }
    }

    @Deprecated
    public List<FunctionalExchange> getAvailableFunctionalExchangeToInsertInFCD(DNode node) {
        return this.getFCDInvolveFunctionalExchangeAndFunctionScope(node);
    }

    public boolean isValidFCDInvolveFunctionalExchange(EObject context, FunctionalChainInvolvement source, FunctionalChainInvolvement target) {
        boolean result;
        Collection<FunctionalExchange> commonExchanges = this.getFCDCommonFunctionalExchanges(source, target);
        boolean bl = result = !commonExchanges.isEmpty();
        return result && !this.findInvolvementInNext(target, source, new HashSet<FunctionalChainInvolvement>());
    }

    public boolean isValidFCDInvolveFunctionalChain(DSemanticDecorator context) {
        return true;
    }

    public boolean isValidFCDInvolveFunction(DSemanticDecorator context) {
        return true;
    }

    public boolean isValidFCDInvolveFunctionalExchangeAndFunctionalChain(DSemanticDecorator context) {
        return context != null && !(context instanceof DDiagram);
    }

    public boolean isValidFCDInvolveFunctionalExchangeAndFunction(DSemanticDecorator context) {
        return context != null && !(context instanceof DDiagram);
    }

    @Deprecated
    public boolean isAnEdgeInvolvementAvailableInFCD(EObject context, FunctionalChainInvolvement source, FunctionalChainInvolvement target) {
        return this.isValidFCDInvolveFunctionalExchange(context, source, target);
    }

    private Collection<FunctionalExchange> getFCDCommonFunctionalExchanges(FunctionalChainInvolvement source, FunctionalChainInvolvement target) {
        return FunctionalChainExt.getFlatCommonFunctionalExchanges((FunctionalChainInvolvement)source, (FunctionalChainInvolvement)target);
    }

    public Collection<FunctionalExchange> getFCDInvolveFunctionalExchangeScope(EObject context, EObject source, EObject target) {
        Collection<FunctionalExchange> commonExchanges = this.getFCDCommonFunctionalExchanges((FunctionalChainInvolvement)source, (FunctionalChainInvolvement)target);
        return commonExchanges;
    }

    public Collection<FunctionalChain> getFCDInvolveFunctionalChainScope(DSemanticDecorator diagram) {
        EObject chain = diagram.getTarget();
        if (!(chain instanceof FunctionalChain)) {
            return Collections.emptyList();
        }
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)chain);
        List chains = FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)architecture);
        LinkedList<FunctionalChain> result = new LinkedList<FunctionalChain>();
        for (FunctionalChain definedChain : chains) {
            boolean toAdd = true;
            if (definedChain.equals(chain)) {
                toAdd = false;
            }
            if (toAdd) {
                for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvementsOf((FunctionalChain)definedChain, (EClass)FaPackage.Literals.FUNCTIONAL_CHAIN)) {
                    if (!chain.equals(involvement.getInvolved())) continue;
                    toAdd = false;
                    break;
                }
            }
            if (!toAdd) continue;
            result.add(definedChain);
        }
        return result;
    }

    public boolean findInvolvementInNext(FunctionalChainInvolvement currentInvolvement, FunctionalChainInvolvement involvementToFind, Set<FunctionalChainInvolvement> visitedInvolvements) {
        if (visitedInvolvements.contains(currentInvolvement)) {
            return false;
        }
        if (currentInvolvement.equals(involvementToFind)) {
            return true;
        }
        HashSet<FunctionalChainInvolvement> involvements = new HashSet<FunctionalChainInvolvement>(visitedInvolvements);
        involvements.add(currentInvolvement);
        for (FunctionalChainInvolvement aNext : currentInvolvement.getNextFunctionalChainInvolvements()) {
            if (!this.findInvolvementInNext(aNext, involvementToFind, involvements)) continue;
            return true;
        }
        return false;
    }

    public MappingHelper getMappingHelper(DSemanticDecorator semanticDecorator) {
        return new MappingHelper(SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticDecorator.getTarget()));
    }
}

