/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.actions.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataLabelProvider;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.AbstractExternalJavaAction;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.Messages;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.properties.providers.CapellaTransfertViewerLabelProvider;

public class SelectElementFromListWizard
extends AbstractExternalJavaAction {
    public Object execute(EObject context, Collection scope_p, String wizardMessage_p, boolean multiple, boolean displayDialog) {
        String wizardMessage = wizardMessage_p;
        List scope = scope_p;
        if (wizardMessage == null) {
            wizardMessage = "";
        }
        if (scope == null) {
            scope = Collections.emptyList();
        }
        if (scope.size() == 1 && !displayDialog) {
            return scope.iterator().next();
        }
        boolean expandViewer = CapellaUIPropertiesPlugin.getDefault().isAllowedExpandSingleViewerContent();
        int viewerExpandLevel = expandViewer ? -1 : 0;
        SelectElementsDialog selectionDialog = new SelectElementsDialog(this.getShell(), (DataLabelProvider)new CapellaTransfertViewerLabelProvider(TransactionHelper.getEditingDomain((EObject)context)), Messages.SelectElementFromListWizard_Title, wizardMessage, new ArrayList(scope), multiple, null, viewerExpandLevel);
        Object result = "WIZARD_CANCELED";
        if (selectionDialog.open() == 0) {
            List selectedElements = selectionDialog.getResult();
            result = selectedElements;
            if (!multiple && !selectedElements.isEmpty()) {
                result = selectedElements.get(0);
            }
        }
        if (result.equals("WIZARD_CANCELED")) {
            throw new OperationCanceledException();
        }
        return result;
    }

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        boolean multiple;
        EObject context = (EObject)parameters.get("context");
        Collection scope = (Collection)parameters.get("scope");
        String wizardMessage = (String)parameters.get("wizardMessage");
        String resultVariable = (String)parameters.get("resultVariable");
        String sMultiple = (String)parameters.get("multiple");
        String sDisplayDialog = (String)parameters.get("displayDialogForOneElement");
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)resultVariable);
        boolean bl = multiple = "true".equals(sMultiple);
        boolean displayDialog = sDisplayDialog == null ? true : "true".equals(sDisplayDialog);
        Object result = this.execute(context, scope, wizardMessage, multiple, displayDialog);
        InterpreterUtil.getInterpreter((EObject)context).setVariable(resultVariable, result);
    }
}

