/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.InformationServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractRefreshExtension;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.Messages;

public class ClassDiagramRefreshExtension
extends AbstractRefreshExtension
implements IRefreshExtension {
    @Override
    protected List<AbstractNodeMapping> getListOfMappingsToMove(DDiagram diagram) {
        ArrayList<AbstractNodeMapping> returnedList = new ArrayList<AbstractNodeMapping>();
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_DataPkg"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_InterfacePkg"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_Class"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_Enumeration"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_Collection"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_DataType"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_BooleanType"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getNodeMapping(diagram, "DT_ExchangeItem"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "FullInterface1"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getNodeMapping(diagram, "DT_DataValue"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getNodeMapping(diagram, "DT_Unit"));
        return returnedList;
    }

    public void beforeRefresh(DDiagram diagram) {
        try {
            DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
            List contextualElements = ContextualDiagramHelper.getService().getContextualElements(descriptor);
            InformationServices.getService().showCDBContextualElements(diagram, contextualElements);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnContextualElements, (Throwable)e);
        }
        this.reorderElements(diagram);
    }

    public void postRefresh(DDiagram diagram) {
    }
}

