/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkExchanger;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractRefreshExtension;

public class ContextualComponentExternalInterfacesRefreshExtension
extends AbstractRefreshExtension
implements IRefreshExtension {
    public void beforeRefresh(DDiagram diagram) {
        if (((DSemanticDecorator)diagram).getTarget() == null) {
            return;
        }
        Component component = (Component)((DSemanticDecorator)diagram).getTarget();
        HashSet<Component> components = new HashSet<Component>();
        Map<EObject, DragAndDropTarget> elements = DiagramServices.getDiagramServices().getMapOfDiagramNodes(diagram);
        NodeMapping interfaceMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "CA_Interface");
        for (Interface itf : CsServices.getService().getRelatedInterfaces(component)) {
            List usedAndRequiredInterfaces;
            Object implementedAndProvidedInterfaces;
            if (!elements.containsKey(itf)) {
                DiagramServices.getDiagramServices().createAbstractDNode((AbstractNodeMapping)interfaceMapping, (EObject)itf, (DragAndDropTarget)diagram, diagram);
            }
            if (!(implementedAndProvidedInterfaces = ComponentExt.getImplementedAndProvidedInterfaces((Component)component)).isEmpty()) {
                Iterator iterator = implementedAndProvidedInterfaces.iterator();
                while (iterator.hasNext()) {
                    Interface implProInterface = (Interface)iterator.next();
                    if (!implProInterface.equals(itf)) continue;
                    List relatedComponents = InterfaceExt.getRequireComponent((Interface)itf);
                    relatedComponents.addAll(itf.getUserComponents());
                    for (Component component2 : relatedComponents) {
                        components.add(component2);
                    }
                }
            }
            if ((usedAndRequiredInterfaces = ComponentExt.getUsedAndRequiredInterfaces((Component)component)).isEmpty()) continue;
            for (Interface useReqInterface : usedAndRequiredInterfaces) {
                if (!useReqInterface.equals(itf)) continue;
                List relatedComponents = InterfaceExt.getProviderComponent((Interface)itf);
                relatedComponents.addAll(itf.getImplementorComponents());
                for (Component component2 : relatedComponents) {
                    components.add(component2);
                }
            }
        }
        NodeMapping exchangeItemMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "CCEI_ExchangeItem");
        for (CommunicationLink link : CsServices.getService().getRelatedCommunicationLinks(component)) {
            ExchangeItem item = link.getExchangeItem();
            if (item == null || elements.containsKey(item)) continue;
            DiagramServices.getDiagramServices().createNode(exchangeItemMapping, (EObject)item, (DragAndDropTarget)diagram, diagram);
            for (CommunicationLinkExchanger related : CsServices.getService().getRelatedExchangers((AbstractExchangeItem)item)) {
                if (!(related instanceof Component)) continue;
                components.add((Component)related);
            }
        }
        ContainerMapping componentMapping = DiagramServices.getDiagramServices().getContainerMapping(diagram, "CA_Component");
        components.removeAll(CsServices.getService().getParentContainersByParts(component));
        Collection<EObject> namespace = CsServices.getService().getAvailableComponentsByNamespaceOfParts(component);
        components.add(component);
        namespace.add((EObject)component);
        for (Component current : components) {
            if (!namespace.contains(current) || elements.containsKey(current)) continue;
            DiagramServices.getDiagramServices().createContainer(componentMapping, (EObject)current, (DragAndDropTarget)diagram, diagram);
        }
    }

    public void postRefresh(DDiagram diagram) {
    }
}

