/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.semantic.browser.view;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.ui.services.helper.ViewerHelper;
import org.polarsys.capella.common.ui.services.swt.events.AbstractKeyAdapter;
import org.polarsys.capella.common.ui.toolkit.browser.action.BrowserActionFactory;
import org.polarsys.capella.common.ui.toolkit.browser.action.BrowserHistory;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.factory.AbstractContentProviderFactory;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.impl.AbstractContentProvider;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.BrowserElementWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.CategoryWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.label.provider.factory.AbstractLabelProviderFactory;
import org.polarsys.capella.common.ui.toolkit.browser.model.ISemanticBrowserModel;
import org.polarsys.capella.common.ui.toolkit.browser.view.ISemanticBrowserViewPart;
import org.polarsys.capella.common.ui.toolkit.viewers.DelegateSelectionProviderWrapper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.model.handler.provider.CapellaReadOnlyHelper;
import org.polarsys.capella.core.model.handler.provider.IReadOnlyListener;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.CapellaNavigatorLabelProvider;
import org.polarsys.capella.core.ui.properties.CapellaTabbedPropertySheetPage;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.semantic.browser.CapellaBrowserActivator;
import org.polarsys.capella.core.ui.semantic.browser.model.SemanticBrowserModel;
import org.polarsys.capella.core.ui.semantic.browser.view.BrowserComposite;
import org.polarsys.capella.core.ui.semantic.browser.view.Messages;

public abstract class SemanticBrowserView
extends ViewPart
implements ISemanticBrowserViewPart,
ITabbedPropertySheetPageContributor,
IEditingDomainProvider,
IReadOnlyListener {
    private static volatile boolean isListeningToPageSelectionEvents;
    private static final Logger logger;
    private static final String ALL_RELATED_DIAGRAMS = "All Related Diagrams";
    private static final String ALL_RELATED_TABLES = "All Related Tables";
    private static final String LISTENING_TO_WORKBENCH_PAGE_SELECTION_EVENTS = "listeningToWorkbenchPageSelectionEvents";
    private static final String REFERENCING_ELEMENTS_LABEL_TXT;
    public static final String SEMANTIC_BROWSER_ID = "org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID";
    private static final String TAG_MEMENTO = "memento";
    private ActionFactory.IWorkbenchAction backAction;
    private TreeViewer currentViewer;
    private DelegateSelectionProviderWrapper delegateSelectionProvider;
    private ActionFactory.IWorkbenchAction forwardAction;
    private BrowserHistory history;
    private boolean isCtrlKeyPressed;
    private IMemento memento;
    private SessionManagerListener semCloseSessionListener;
    private TabbedPropertySheetPage propertySheetPage;
    private TreeViewer referencedViewer;
    private TreeViewer referencingViewer;
    private ISelectionListener selectionListener;
    private TabbedPropertyTitle semanticBrowserTitle;
    private boolean shouldSetFocus;
    private IDoubleClickListener viewerDoubleClickListener;
    private ISelectionChangedListener viewerSelectionListener;
    private IDialogSettings viewSettings = this.getDialogSettingsSection();
    protected ISemanticBrowserModel model = new SemanticBrowserModel();
    protected IAction showPatternsAction;
    protected IAction showDiagramsAction;
    protected IAction limitateTreeExpansionAction;

    static {
        logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
        REFERENCING_ELEMENTS_LABEL_TXT = Messages.SemanticBrowserView_Referencing_Elements_Title;
    }

    public ISemanticBrowserModel getModel() {
        return this.model;
    }

    public void activateListeningToPageSelectionEvents() {
        this.selectionListener = this.getSelectionListener();
        if (this.selectionListener != null) {
            this.getSite().getPage().addSelectionListener(this.selectionListener);
        }
        isListeningToPageSelectionEvents = true;
    }

    protected void addDndDragSupport(final TreeViewer viewer) {
        int operations = 3;
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        viewer.addDragSupport(operations, transferTypes, new DragSourceListener(){

            public void dragSetData(DragSourceEvent event) {
                event.data = LocalSelectionTransfer.getTransfer().getSelection();
            }

            public void dragStart(DragSourceEvent event) {
                ISelection selection = viewer.getSelection();
                if (selection != null && selection instanceof IStructuredSelection && CapellaResourceHelper.isSemanticElements((Collection)((IStructuredSelection)selection).toList())) {
                    LocalSelectionTransfer.getTransfer().setSelection(selection);
                    LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
                    event.doit = true;
                } else {
                    event.doit = false;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
                LocalSelectionTransfer.getTransfer().setSelectionSetTime(0L);
            }
        });
    }

    protected void addListeners(TreeViewer viewer) {
        if (this.viewerSelectionListener == null) {
            this.viewerSelectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelectionProvider provider = event.getSelectionProvider();
                    SemanticBrowserView.this.updateSelectionProvider(provider);
                    SemanticBrowserView.this.refreshPropertyPage(provider);
                    SemanticBrowserView.this.updateStatusLine(provider.getSelection());
                }
            };
        }
        viewer.addSelectionChangedListener(this.viewerSelectionListener);
        viewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                Object source = event.getSource();
                TreeViewer newSelectionProvider = null;
                if (source.equals(SemanticBrowserView.this.currentViewer.getControl())) {
                    newSelectionProvider = SemanticBrowserView.this.currentViewer;
                } else if (source.equals(SemanticBrowserView.this.referencedViewer.getControl())) {
                    newSelectionProvider = SemanticBrowserView.this.referencedViewer;
                } else if (source.equals(SemanticBrowserView.this.referencingViewer.getControl())) {
                    newSelectionProvider = SemanticBrowserView.this.referencingViewer;
                }
                if (newSelectionProvider != null) {
                    SemanticBrowserView.this.updateSelectionProvider((ISelectionProvider)newSelectionProvider);
                    SemanticBrowserView.this.refreshPropertyPage((ISelectionProvider)newSelectionProvider);
                    try {
                        SemanticBrowserView.this.getViewSite().getPage().showView(SemanticBrowserView.SEMANTIC_BROWSER_ID, null, 3);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        if (this.viewerDoubleClickListener == null) {
            this.viewerDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    try {
                        SemanticBrowserView.this.handleDoubleClick(event);
                    }
                    catch (RuntimeException exception) {
                        StringBuilder loggerMessage = new StringBuilder("SemanticBrowserView.addListeners(..) _ ");
                        loggerMessage.append(exception.getMessage());
                        logger.error((Object)new EmbeddedMessage(loggerMessage.toString(), "User Interface"), (Throwable)exception);
                    }
                }
            };
        }
        viewer.addDoubleClickListener(this.viewerDoubleClickListener);
        viewer.getControl().addKeyListener((KeyListener)new AbstractKeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (this.isCtrlPressed(keyEvent)) {
                    SemanticBrowserView.this.isCtrlKeyPressed = true;
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (this.isCtrlPressed(keyEvent)) {
                    SemanticBrowserView.this.isCtrlKeyPressed = false;
                }
            }
        });
    }

    public void clean() {
        boolean restoreState = this.shouldSetFocus;
        this.shouldSetFocus = false;
        this.setInput(null);
        if (restoreState) {
            this.shouldSetFocus = true;
        }
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.semanticBrowserTitle = new TabbedPropertyTitle(parent, new TabbedPropertySheetWidgetFactory());
        GridData titleLayoutData = new GridData(768);
        titleLayoutData.grabExcessVerticalSpace = false;
        this.semanticBrowserTitle.setLayoutData((Object)titleLayoutData);
        this.semanticBrowserTitle.setTitle(Messages.SemanticBrowserView_Default_Name, null);
        SashForm mainSashForm = new SashForm(parent, 256);
        GridLayout gridLayoutTop = new GridLayout(3, true);
        mainSashForm.setLayout((Layout)gridLayoutTop);
        mainSashForm.setLayoutData((Object)new GridData(1808));
        AbstractContentProviderFactory.getInstance().setModel(this.model);
        ViewerSorter sorter = new ViewerSorter();
        AbstractContentProvider treeProvider = (AbstractContentProvider)AbstractContentProviderFactory.getInstance().getReferencingContentProvider();
        this.referencingViewer = this.createViewer((Composite)mainSashForm, REFERENCING_ELEMENTS_LABEL_TXT, 3, treeProvider.getBrowserId());
        this.initializeViewer(this.referencingViewer, (IContentProvider)treeProvider, (IBaseLabelProvider)AbstractLabelProviderFactory.getInstance().getReferencingLabelProvider(), sorter);
        treeProvider = (AbstractContentProvider)AbstractContentProviderFactory.getInstance().getCurrentContentProvider();
        this.currentViewer = this.createViewer((Composite)mainSashForm, Messages.SemanticBrowserView_Current_Element_Title, 3, treeProvider.getBrowserId());
        this.initializeViewer(this.currentViewer, (IContentProvider)treeProvider, (IBaseLabelProvider)AbstractLabelProviderFactory.getInstance().getCurrentLabelProvider(), new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof CategoryWrapper && this.isRepresentationCategory((CategoryWrapper)e1)) {
                    return 1;
                }
                if (e2 instanceof CategoryWrapper && this.isRepresentationCategory((CategoryWrapper)e2)) {
                    return -1;
                }
                return super.compare(viewer, e1, e2);
            }

            private boolean isRepresentationCategory(CategoryWrapper categoryWrapper) {
                ICategory category = (ICategory)categoryWrapper.getElement();
                String categoryName = category.getName();
                return categoryName.equals(SemanticBrowserView.ALL_RELATED_DIAGRAMS) || categoryName.equals(SemanticBrowserView.ALL_RELATED_TABLES);
            }
        });
        treeProvider = (AbstractContentProvider)AbstractContentProviderFactory.getInstance().getReferencedContentProvider();
        this.referencedViewer = this.createViewer((Composite)mainSashForm, Messages.SemanticBrowserView_Referenced_Elements_Title, 3, treeProvider.getBrowserId());
        this.initializeViewer(this.referencedViewer, (IContentProvider)treeProvider, (IBaseLabelProvider)AbstractLabelProviderFactory.getInstance().getReferencedLabelProvider(), sorter);
        this.initializeContextMenus();
        ArrayList<TreeViewer> lstProvider = new ArrayList<TreeViewer>();
        lstProvider.add(this.currentViewer);
        lstProvider.add(this.referencedViewer);
        lstProvider.add(this.referencingViewer);
        this.delegateSelectionProvider = new DelegateSelectionProviderWrapper(lstProvider);
        this.delegateSelectionProvider.setActiveDelegate((ISelectionProvider)this.currentViewer);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.delegateSelectionProvider);
        this.makeActions();
        this.semCloseSessionListener = new SemCloseSessionListener();
        SessionManager.INSTANCE.addSessionsListener(this.semCloseSessionListener);
    }

    protected TreeViewer createViewer(Composite parent, String label, int autoExpandLevel, String browserID) {
        BrowserComposite composite = new BrowserComposite(parent, this.model, 770, label, browserID);
        TreeViewer treeViewer = composite.getTreeviewer();
        treeViewer.setUseHashlookup(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer, (int)1);
        this.addListeners(treeViewer);
        this.addDndDragSupport(treeViewer);
        return treeViewer;
    }

    public void deactivateListeningToPageSelectionEvents() {
        if (this.selectionListener != null) {
            this.getSite().getPage().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
        isListeningToPageSelectionEvents = false;
    }

    public void dispose() {
        Object currentInput;
        TreeViewer currentViewer = this.getCurrentViewer();
        if (currentViewer != null && (currentInput = currentViewer.getInput()) != null) {
            CapellaReadOnlyHelper.unregister((EObject)((EObject)currentInput), (IReadOnlyListener)this);
        }
        this.saveViewSettings();
        this.deactivateListeningToPageSelectionEvents();
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
            this.propertySheetPage = null;
        }
        if (this.referencingViewer != null) {
            this.removeListeners(this.referencingViewer);
            this.referencingViewer = null;
        }
        if (this.referencedViewer != null) {
            this.removeListeners(this.referencedViewer);
            this.referencedViewer = null;
        }
        if (this.currentViewer != null) {
            this.removeListeners(this.currentViewer);
        }
        this.viewerSelectionListener = null;
        this.viewerDoubleClickListener = null;
        if (this.history != null) {
            this.history.dispose();
            this.history = null;
        }
        SessionManager.INSTANCE.removeSessionsListener(this.semCloseSessionListener);
        this.semCloseSessionListener = null;
        this.model = null;
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class.equals((Object)adapter)) {
            return this.getPropertySheetPage();
        }
        if (Control.class.equals((Object)adapter)) {
            return this.getParentControl();
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return "org.polarsys.capella.core.data.capellamodeller.properties";
    }

    public TreeViewer getCurrentViewer() {
        return this.currentViewer;
    }

    private IDialogSettings getDialogSettingsSection() {
        String sectionName;
        IDialogSettings dialogSettings = CapellaBrowserActivator.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(sectionName = ((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = dialogSettings.addNewSection(sectionName);
        }
        return section;
    }

    public EditingDomain getEditingDomain() {
        Object elt;
        ISelection selection = this.getCurrentViewer().getSelection();
        if (selection instanceof IStructuredSelection && (elt = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            return TransactionHelper.getEditingDomain((EObject)((EObject)elt));
        }
        return null;
    }

    public BrowserHistory getHistory() {
        if (this.history == null) {
            this.history = new BrowserHistory();
        }
        return this.history;
    }

    protected Control getParentControl() {
        if (this.semanticBrowserTitle != null) {
            return this.semanticBrowserTitle.getParent();
        }
        return null;
    }

    protected TabbedPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new CapellaTabbedPropertySheetPage(this){

                public void dispose() {
                    super.dispose();
                    SemanticBrowserView.this.propertySheetPage = null;
                }

                public void init(IPageSite pageSite) {
                    super.init(pageSite);
                    pageSite.setSelectionProvider(SemanticBrowserView.this.getViewSite().getSelectionProvider());
                }
            };
        }
        return this.propertySheetPage;
    }

    public TreeViewer getReferencedViewer() {
        return this.referencedViewer;
    }

    public TreeViewer getReferencingViewer() {
        return this.referencingViewer;
    }

    public EObject getRootElement() {
        return ((AbstractContentProvider)this.currentViewer.getContentProvider()).getRootElement();
    }

    protected ISelectionListener getSelectionListener() {
        return new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                Object newInput = SemanticBrowserView.this.handleWorkbenchPageSelectionEvent(part, selection);
                if (newInput != null && newInput instanceof EObject) {
                    if ("org.eclipse.ui.views.PropertySheet".equals(part.getSite().getId())) {
                        return;
                    }
                    try {
                        SemanticBrowserView.this.shouldSetFocus = false;
                        SemanticBrowserView.this.setInput(newInput);
                    }
                    finally {
                        SemanticBrowserView.this.shouldSetFocus = true;
                    }
                } else if (part != SemanticBrowserView.this && !"org.eclipse.ui.views.PropertySheet".equals(part.getSite().getId())) {
                    SemanticBrowserView.this.clean();
                }
            }
        };
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        ITreeSelection selection = (ITreeSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object doubleClickedElement = selection.getFirstElement();
            if (doubleClickedElement instanceof BrowserElementWrapper) {
                doubleClickedElement = ((BrowserElementWrapper)doubleClickedElement).getElement();
            }
            if (doubleClickedElement instanceof EObject) {
                if (this.isCtrlKeyPressed) {
                    if (this.getRootElement() != doubleClickedElement) {
                        this.setInput(doubleClickedElement);
                        this.currentViewer.setSelection((ISelection)new StructuredSelection(doubleClickedElement), true);
                    }
                } else {
                    CapellaUIPropertiesPlugin.getDefault().openWizard(event, (EObject)doubleClickedElement);
                }
            }
        }
    }

    protected Object handleWorkbenchPageSelectionEvent(IWorkbenchPart part, ISelection selection) {
        return null;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        boolean isListeningOnStartup;
        this.memento = this.restoreViewSettings(memento);
        super.init(site, this.memento);
        Integer value = null;
        if (this.memento != null) {
            value = this.memento.getInteger(LISTENING_TO_WORKBENCH_PAGE_SELECTION_EVENTS);
        }
        boolean bl = isListeningOnStartup = !CapellaBrowserActivator.getDefault().getPreferenceStore().getBoolean("disable.semantic.browser.sync");
        isListeningToPageSelectionEvents = value != null ? value == 1 : isListeningOnStartup;
    }

    private void initializeContextMenu(String menuManagerText, String menuManagerId, TreeViewer viewer) {
        MenuManager menuManager = new MenuManager(menuManagerText, menuManagerId);
        menuManager.setRemoveAllWhenShown(true);
        Tree tree = viewer.getTree();
        Menu currentMenu = menuManager.createContextMenu((Control)tree);
        tree.setMenu(currentMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)viewer);
    }

    private void initializeContextMenus() {
        this.initializeContextMenu("current#PopupMenu", null, this.currentViewer);
        this.initializeContextMenu("referenced#PopupMenu", null, this.referencedViewer);
        this.initializeContextMenu("referencing#PopupMenu", null, this.referencingViewer);
    }

    private void initializeViewer(TreeViewer viewer, IContentProvider contentProvider, IBaseLabelProvider labelProvider, ViewerSorter sorter) {
        viewer.getControl().setLayoutData((Object)new GridData(1808));
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider(labelProvider);
        viewer.setSorter(sorter);
    }

    protected boolean isCtrlKeyPressed() {
        return this.isCtrlKeyPressed;
    }

    private ImageDescriptor getImage(EObject object) {
        IItemLabelProvider l = (IItemLabelProvider)CapellaAdapterFactoryProvider.getInstance().getAdapterFactory().adapt((Notifier)object, IItemLabelProvider.class);
        URL imageUrl = (URL)l.getImage((Object)object);
        return ImageDescriptor.createFromURL((URL)imageUrl);
    }

    protected void makeActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        this.backAction = BrowserActionFactory.BACKWARD_HISTORY.create(this.getViewSite().getWorkbenchWindow(), (ISemanticBrowserViewPart)this);
        this.backAction.setActionDefinitionId("org.polarsys.capella.core.ui.semantic.browser.backwardNavigation");
        toolBarManager.add((IAction)this.backAction);
        this.forwardAction = BrowserActionFactory.FORWARD_HISTORY.create(this.getViewSite().getWorkbenchWindow(), (ISemanticBrowserViewPart)this);
        this.forwardAction.setActionDefinitionId("org.polarsys.capella.core.ui.semantic.browser.forwardNavigation");
        toolBarManager.add((IAction)this.forwardAction);
        this.showDiagramsAction = new Action(null, 2){

            public void run() {
                SemanticBrowserView.this.model.setShowDiagrams(this.isChecked());
                Object input = SemanticBrowserView.this.getCurrentViewer().getInput();
                SemanticBrowserView.this.setInputOnViewers(input);
            }
        };
        this.showDiagramsAction.setChecked(this.model.doesShowDiagrams());
        this.showDiagramsAction.setToolTipText(Messages.SemanticBrowserView_ShowDiagramsAction_Tooltip);
        this.showDiagramsAction.setImageDescriptor(this.getImage((EObject)ViewpointFactory.eINSTANCE.createDAnalysis()));
        toolBarManager.add(this.showDiagramsAction);
        this.limitateTreeExpansionAction = new Action(null, 2){

            public void run() {
                SemanticBrowserView.this.model.setLimitateTreeExpansion(this.isChecked());
                Object input = SemanticBrowserView.this.getCurrentViewer().getInput();
                SemanticBrowserView.this.setInputOnViewers(input);
            }
        };
        this.limitateTreeExpansionAction.setChecked(this.model.doesLimitateTreeExpansion());
        this.limitateTreeExpansionAction.setToolTipText(Messages.SemanticBrowserView_LimitateTreeExpansionAction_Tooltip);
        this.limitateTreeExpansionAction.setImageDescriptor(CapellaBrowserActivator.getDefault().getImageDescriptor("full/clcl16/collapseCategories.gif"));
        toolBarManager.add(this.limitateTreeExpansionAction);
        Action refreshAction = new Action(null, CapellaBrowserActivator.getDefault().getImageDescriptor("full/clcl16/refresh.gif")){

            public void run() {
                SemanticBrowserView.this.refreshTitleBar();
            }
        };
        toolBarManager.add((IAction)refreshAction);
        Action listeningToPageSelectionEventsAction = new Action(null, 2){

            private ISelection getSelection(IWorkbenchPart part) {
                return part.getSite().getSelectionProvider().getSelection();
            }

            private boolean isSomethingSelectable(ISelection selection) {
                return selection != null && !selection.isEmpty();
            }

            public void run() {
                if (this.isChecked()) {
                    SemanticBrowserView.this.activateListeningToPageSelectionEvents();
                    IWorkbenchPage activePage = SemanticBrowserView.this.getSite().getPage();
                    IWorkbenchPart activePart = activePage.getActivePart();
                    IViewPart part = null;
                    ISelection selection = null;
                    if (activePart != null && SemanticBrowserView.this != activePart) {
                        ISelectionProvider selectionProvider = activePart.getSite().getSelectionProvider();
                        if (selectionProvider != null && this.isSomethingSelectable(selection = selectionProvider.getSelection())) {
                            part = activePart;
                        }
                    } else {
                        IEditorPart activeEditor;
                        IViewPart capellaExplorer = activePage.findView("capella.project.explorer");
                        if (capellaExplorer != null && this.isSomethingSelectable(selection = this.getSelection((IWorkbenchPart)capellaExplorer))) {
                            part = capellaExplorer;
                        }
                        if (part == null && (activeEditor = activePage.getActiveEditor()) != null && this.isSomethingSelectable(selection = this.getSelection((IWorkbenchPart)activeEditor))) {
                            part = activeEditor;
                        }
                    }
                    if (part != null) {
                        SemanticBrowserView.this.selectionListener.selectionChanged((IWorkbenchPart)part, selection);
                    }
                } else {
                    SemanticBrowserView.this.deactivateListeningToPageSelectionEvents();
                }
            }
        };
        listeningToPageSelectionEventsAction.setText(Messages.SemanticBrowserView_ListeningToPageSelectionEventsAction_Title);
        listeningToPageSelectionEventsAction.setToolTipText(Messages.SemanticBrowserView_ListeningToPageSelectionEventsAction_Tooltip);
        listeningToPageSelectionEventsAction.setImageDescriptor(CapellaBrowserActivator.getDefault().getImageDescriptor("full/clcl16/synced.gif"));
        toolBarManager.add((IAction)listeningToPageSelectionEventsAction);
        listeningToPageSelectionEventsAction.setChecked(isListeningToPageSelectionEvents);
        if (isListeningToPageSelectionEvents) {
            listeningToPageSelectionEventsAction.run();
        }
    }

    public void refresh() {
        ViewerHelper.refresh((StructuredViewer)this.referencingViewer);
        ViewerHelper.refresh((StructuredViewer)this.referencedViewer);
        ViewerHelper.refresh((StructuredViewer)this.currentViewer);
    }

    protected void refreshPropertyPage(ISelectionProvider selectionProvider) {
        IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
        if (this.propertySheetPage != null && !this.propertySheetPage.getControl().isDisposed()) {
            ISelectionProvider pageSelectionProvider = this.propertySheetPage.getSite().getSelectionProvider();
            if (pageSelectionProvider == null || pageSelectionProvider != selectionProvider) {
                this.propertySheetPage.getSite().setSelectionProvider(selectionProvider);
            }
            this.propertySheetPage.selectionChanged((IWorkbenchPart)this, (ISelection)selection);
        }
    }

    public void updateStatusLine(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
            if (selectedElement != null && selectedElement instanceof EObject) {
                CapellaNavigatorLabelProvider semanticBrowserLabelProvider = new CapellaNavigatorLabelProvider(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory());
                Image image = semanticBrowserLabelProvider.getImage(selectedElement);
                String text = semanticBrowserLabelProvider.getDescription(selectedElement);
                statusLineManager.setMessage(image, text);
            } else {
                statusLineManager.setMessage(null, "");
            }
        }
    }

    public void setEnabled(boolean enabled) {
    }

    public void refreshTitleBar() {
        Object input = this.getCurrentViewer().getInput();
        this.refreshTitleBar(input);
        this.setInputOnViewers(input);
    }

    public void setInputOnViewers(final Object input) {
        TreeViewer currentViewer = this.getCurrentViewer();
        if (currentViewer != null && currentViewer.getControl() != null && !currentViewer.getControl().isDisposed()) {
            Display display = currentViewer.getControl().getDisplay();
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ViewerHelper.run((StructuredViewer)SemanticBrowserView.this.referencingViewer, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (SemanticBrowserView.this.referencingViewer.getControl() != null && !SemanticBrowserView.this.referencingViewer.getControl().isDisposed()) {
                                SemanticBrowserView.this.referencingViewer.setInput(input);
                            }
                        }
                    });
                    ViewerHelper.run((StructuredViewer)SemanticBrowserView.this.referencedViewer, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (SemanticBrowserView.this.referencedViewer.getControl() != null && !SemanticBrowserView.this.referencedViewer.getControl().isDisposed()) {
                                SemanticBrowserView.this.referencedViewer.setInput(input);
                            }
                        }
                    });
                    ViewerHelper.run((StructuredViewer)SemanticBrowserView.this.currentViewer, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (SemanticBrowserView.this.currentViewer.getControl() != null && !SemanticBrowserView.this.currentViewer.getControl().isDisposed()) {
                                SemanticBrowserView.this.currentViewer.setInput(input);
                            }
                        }
                    });
                }
            });
        }
    }

    private void refreshTitleBar(Object selectedElement) {
        String title = Messages.SemanticBrowserView_Default_Name;
        Image image = null;
        if (selectedElement != null) {
            title = AbstractLabelProviderFactory.getInstance().getCurrentLabelProvider().getText(selectedElement);
            String metaclassLabel = EObjectLabelProviderHelper.getMetaclassLabel((EObject)((EObject)selectedElement), (boolean)true);
            if (metaclassLabel != null && !title.startsWith(metaclassLabel)) {
                title = String.valueOf(metaclassLabel) + title;
            }
            image = AbstractLabelProviderFactory.getInstance().getCurrentLabelProvider().getImage(selectedElement);
        }
        if (!this.semanticBrowserTitle.isDisposed()) {
            this.semanticBrowserTitle.setRedraw(false);
            this.semanticBrowserTitle.setTitle(title, image);
            this.semanticBrowserTitle.setRedraw(true);
        }
    }

    protected void removeListeners(TreeViewer viewer) {
        viewer.removeDoubleClickListener(this.viewerDoubleClickListener);
        viewer.removeSelectionChangedListener(this.viewerSelectionListener);
    }

    private IMemento restoreViewSettings(IMemento memento) {
        String persistedMemento;
        IMemento mementol = memento;
        if (mementol == null && (persistedMemento = this.viewSettings.get(TAG_MEMENTO)) != null) {
            try {
                mementol = XMLMemento.createReadRoot((Reader)new StringReader(persistedMemento));
            }
            catch (WorkbenchException workbenchException) {
                // empty catch block
            }
        }
        return mementol;
    }

    public void saveState(IMemento memento) {
        memento.putInteger(LISTENING_TO_WORKBENCH_PAGE_SELECTION_EVENTS, isListeningToPageSelectionEvents ? 1 : 0);
    }

    private void saveViewSettings() {
        String rootName = ((Object)((Object)this)).getClass().getSimpleName();
        XMLMemento memento = XMLMemento.createWriteRoot((String)rootName);
        this.saveState((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            this.viewSettings.put(TAG_MEMENTO, writer.getBuffer().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setFocus() {
        ISelectionProvider selectionProvider = this.delegateSelectionProvider.getActiveDelegate();
        if (selectionProvider != null && selectionProvider instanceof TreeViewer) {
            ((TreeViewer)selectionProvider).getControl().setFocus();
        } else {
            this.currentViewer.getControl().setFocus();
        }
    }

    public final void setInput(Object input) {
        TreeViewer currentViewer = this.getCurrentViewer();
        Object lastInput = currentViewer.getInput();
        if (lastInput != null && lastInput.equals(input)) {
            return;
        }
        this.refreshTitleBar(input);
        this.delegateSelectionProvider.setActiveDelegate((ISelectionProvider)this.currentViewer);
        this.setInputOnViewers(input);
        CapellaReadOnlyHelper.unregister((EObject)((EObject)lastInput), (IReadOnlyListener)this);
        CapellaReadOnlyHelper.register((EObject)((EObject)input), (IReadOnlyListener)this);
        this.getHistory().update(input);
        if (this.shouldSetFocus) {
            this.setFocus();
        }
    }

    protected void updateSelectionProvider(ISelectionProvider newSelectionProvider) {
        ISelectionProvider currentSelectionProvider = this.delegateSelectionProvider.getActiveDelegate();
        if (currentSelectionProvider == null || currentSelectionProvider != newSelectionProvider) {
            this.delegateSelectionProvider.setActiveDelegate(newSelectionProvider);
        }
    }

    public static boolean isListeningToPageSelectionEvents() {
        return isListeningToPageSelectionEvents;
    }

    protected class SemCloseSessionListener
    extends SessionManagerListener.Stub {
        protected SemCloseSessionListener() {
        }

        public void notify(Session updated, int notification) {
            switch (notification) {
                case 8: {
                    Session session;
                    Object currentInput = SemanticBrowserView.this.getCurrentViewer().getInput();
                    if (currentInput instanceof EObject && updated.equals(session = SessionManager.INSTANCE.getSession((EObject)currentInput))) {
                        SemanticBrowserView.this.clean();
                    }
                    for (BrowserHistory.BrowserNavigationHistoryEntry entry : SemanticBrowserView.this.getHistory().getAllNavigationEntries()) {
                        if (!(entry.getRealObject() instanceof EObject) || updated != SessionManager.INSTANCE.getSession((EObject)entry.getRealObject())) continue;
                        entry.invalidate();
                    }
                    break;
                }
                case 9: {
                    SemanticBrowserView.this.getHistory().update(null);
                }
            }
        }
    }
}

