/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.libraries.AccessPolicy;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.IModelIdentifier;
import org.polarsys.capella.common.libraries.LibraryReference;
import org.polarsys.capella.common.libraries.ModelInformation;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.libraries.model.AbstractUriModel;
import org.polarsys.capella.core.data.capellamodeller.Library;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.libraries.model.CapellaLibraryExt;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.model.ICapellaModel;
import org.polarsys.capella.core.libraries.model.ModelIdentifier;

public abstract class AbstractCapellaModel
extends AbstractUriModel
implements ICapellaModel {
    protected boolean _initializedAttributes = false;
    protected ModelIdentifier _identifier = null;
    protected boolean _isLibrary = true;
    protected TransactionalEditingDomain _domain;

    public TransactionalEditingDomain getEditingDomain() {
        return this._domain;
    }

    public AbstractCapellaModel(ModelIdentifier identifier_p, TransactionalEditingDomain domain_p) {
        super(identifier_p.getUri());
        this._domain = domain_p;
        this._identifier = identifier_p;
    }

    public IModelIdentifier getIdentifier() {
        return this._identifier;
    }

    @Override
    public boolean isLibrary() {
        if (!this._initializedAttributes) {
            this.initializeAttributes();
        }
        return this._isLibrary;
    }

    protected boolean resolve() {
        return true;
    }

    protected Resource getResource(TransactionalEditingDomain domain, URI uri) {
        return this.getResource(domain, uri, this.resolve());
    }

    protected Resource getResource(TransactionalEditingDomain domain, URI uri, boolean resolve) {
        try {
            return domain.getResourceSet().getResource(uri, this.resolve());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void initializeAttributes() {
        Resource resource = this.getResource(this._domain, this.uriSemanticFile);
        Project project = CapellaLibraryExt.getProject(resource);
        this._isLibrary = project instanceof Library;
        this._initializedAttributes = true;
    }

    public AccessPolicy getAccess(IModel library_p) {
        if (this.equals(library_p)) {
            return AccessPolicy.READ_AND_WRITE;
        }
        ArrayList<AccessInfo> accessInfos = new ArrayList<AccessInfo>();
        this.calculateAccessPolicy(this, library_p, accessInfos, 0);
        if (!accessInfos.isEmpty()) {
            Iterator itInfo = accessInfos.iterator();
            AccessInfo accessInfo = (AccessInfo)itInfo.next();
            int currentLevel = accessInfo.level;
            AccessPolicy result = accessInfo.accessPolicy;
            while (itInfo.hasNext()) {
                AccessInfo elt = (AccessInfo)itInfo.next();
                if (elt.level != currentLevel) break;
                result = this.resolveAccessPolicy(result, elt.accessPolicy);
            }
            return result;
        }
        return this.getDefaultAccess(library_p);
    }

    public AccessPolicy resolveAccessPolicy(AccessPolicy policy1, AccessPolicy policy2) {
        if (policy1 == AccessPolicy.READ_AND_WRITE || policy2 == AccessPolicy.READ_AND_WRITE) {
            return AccessPolicy.READ_AND_WRITE;
        }
        return AccessPolicy.READ_ONLY;
    }

    protected void calculateAccessPolicy(IModel model_p, IModel library_p, List<AccessInfo> policies, int level) {
        this.calculateAccessPolicy(model_p, library_p, policies, level, AccessPolicy.READ_AND_WRITE);
    }

    protected void calculateAccessPolicy(IModel model_p, IModel library_p, List<AccessInfo> policies, int level, AccessPolicy policy) {
        IModel model = model_p;
        IModel library = library_p;
        ModelInformation source = this.getModelInformation(model_p, false);
        ModelInformation target = this.getModelInformation(library_p, false);
        if (source != null && target != null) {
            for (LibraryReference reference : source.getOwnedReferences()) {
                if (reference.getLibrary() == null || !reference.getLibrary().equals(target)) continue;
                policies.add(new AccessInfo(level, this.mergePolicies(policy, reference.getAccessPolicy())));
                return;
            }
        }
        Collection referencedLibraries = LibraryManagerExt.getReferences((IModel)model);
        for (IModel referencedLibrary : referencedLibraries) {
            this.calculateAccessPolicy(referencedLibrary, library, policies, level + 1, this.mergePolicies(policy, model.getAccess(referencedLibrary)));
        }
    }

    protected AccessPolicy mergePolicies(AccessPolicy p1, AccessPolicy p2) {
        return AccessPolicy.READ_ONLY.equals((Object)p1) || AccessPolicy.READ_ONLY.equals((Object)p2) ? AccessPolicy.READ_ONLY : AccessPolicy.READ_AND_WRITE;
    }

    protected ModelInformation getModelInformation(IModel model_p, boolean create_p) {
        if (model_p instanceof CapellaModel) {
            Resource target = this.getResource(this._domain, ((CapellaModel)model_p).getUriSemanticFile(), create_p && this.resolve());
            ModelInformation targetObject = CapellaLibraryExt.getModelInformation(target, create_p);
            return targetObject;
        }
        return null;
    }

    @Override
    public Project getProject(TransactionalEditingDomain domain_p) {
        Resource target = this.getResource(domain_p, this.uriSemanticFile);
        return CapellaLibraryExt.getProject(target);
    }

    protected class AccessInfo {
        public int level;
        public AccessPolicy accessPolicy;

        public AccessInfo(int level_p, AccessPolicy accessPolicy_p) {
            this.level = level_p;
            this.accessPolicy = accessPolicy_p;
        }
    }
}

