/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.copyformat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.formatdata.AbstractFormatData;
import org.eclipse.sirius.diagram.formatdata.EdgeFormatData;
import org.eclipse.sirius.diagram.formatdata.NodeFormatData;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.tools.api.format.AbstractSiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManager;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.sirius.ui.copyformat.AbstractCapellaFormatDataKey;
import org.polarsys.capella.core.sirius.ui.copyformat.CapellaDecoratorFormatDataKey;
import org.polarsys.capella.core.sirius.ui.copyformat.CapellaEdgeFormatDataKey;
import org.polarsys.capella.core.sirius.ui.copyformat.CapellaNodeFormatDataKey;
import org.polarsys.capella.core.sirius.ui.copyformat.keyproviders.IKeyProvider;

public class CapellaFormatDataManager
extends AbstractSiriusFormatDataManager
implements SiriusFormatDataManager {
    protected final Map<AbstractCapellaFormatDataKey, Map<String, AbstractFormatData>> formatDataMap = new HashMap<AbstractCapellaFormatDataKey, Map<String, AbstractFormatData>>();
    protected Collection<IKeyProvider> keyProviders = null;

    public Collection<IKeyProvider> getKeyProviders() {
        if (this.keyProviders == null) {
            this.keyProviders = new ArrayList<IKeyProvider>();
            try {
                IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.capella.core.sirius.ui.copyformatProvider");
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    try {
                        IKeyProvider provider = (IKeyProvider)element.createExecutableExtension("class");
                        this.keyProviders.add(provider);
                    }
                    catch (Exception e) {
                        System.out.println("Cannot load a copy format provider");
                        e.printStackTrace();
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                System.out.println("Cannot load copy format providers");
                e.printStackTrace();
            }
        }
        return this.keyProviders;
    }

    public void storeFormatData(IGraphicalEditPart rootEditPart) {
        if (rootEditPart != null) {
            boolean isValid = true;
            EditPart parentView = rootEditPart.getParent();
            if (parentView != null) {
                Node labelNode;
                Object currentModel = rootEditPart.getModel();
                Object parentModel = parentView.getModel();
                if (currentModel != null && parentModel != null && parentModel instanceof View && (labelNode = SiriusGMFHelper.getLabelNode((View)((View)parentModel))) != null && currentModel.equals(labelNode)) {
                    isValid = false;
                }
            }
            if (isValid) {
                super.storeFormatData(rootEditPart);
            }
        }
    }

    protected void addEdgeFormatData(NodeFormatData parentFormatData, DEdge edge, EditPartViewer editPartViewer) {
        try {
            super.addEdgeFormatData(parentFormatData, edge, editPartViewer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addNodeChildren(DNode parentNode, NodeFormatData parentFormatData, IGraphicalEditPart parentEditPart, View gmfView, Collection<FormatDataKey> discoveredKeys) {
        try {
            super.addNodeChildren(parentNode, parentFormatData, parentEditPart, gmfView, discoveredKeys);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addNodeContainerChildren(DNodeContainer container, NodeFormatData parentFormatData, IGraphicalEditPart parentEditPart, Collection<FormatDataKey> discoveredKeys) {
        try {
            super.addNodeContainerChildren(container, parentFormatData, parentEditPart, discoveredKeys);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addNodeListChildren(DNodeList nodeList, NodeFormatData parentFormatData, IGraphicalEditPart parentEditPart, Collection<FormatDataKey> discoveredKeys) {
        try {
            super.addNodeListChildren(nodeList, parentFormatData, parentEditPart, discoveredKeys);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addOutgoingEdge(NodeFormatData parentFormatData, EdgeTarget sourceOfEdge, EditPartViewer editPartViewer) {
        try {
            super.addOutgoingEdge(parentFormatData, sourceOfEdge, editPartViewer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AbstractFormatData getFormatData(FormatDataKey key, RepresentationElementMapping mapping) {
        AbstractFormatData formatData = null;
        if (key instanceof AbstractCapellaFormatDataKey && this.validateKey((AbstractCapellaFormatDataKey)key)) {
            formatData = this.getLinkedFormatData((AbstractCapellaFormatDataKey)key, mapping);
        }
        if (formatData != null) {
            if (key instanceof CapellaNodeFormatDataKey && !(formatData instanceof NodeFormatData)) {
                formatData = null;
            }
            if (key instanceof CapellaEdgeFormatDataKey && !(formatData instanceof EdgeFormatData)) {
                formatData = null;
            }
        }
        return formatData;
    }

    public void addFormatData(FormatDataKey key, RepresentationElementMapping mapping, AbstractFormatData formatData) {
        if (key instanceof AbstractCapellaFormatDataKey && this.validateKey((AbstractCapellaFormatDataKey)key)) {
            if (key instanceof CapellaDecoratorFormatDataKey) {
                this.updateFormatDataMap(((CapellaDecoratorFormatDataKey)key).getParent(), mapping, formatData);
            }
            this.updateFormatDataMap((AbstractCapellaFormatDataKey)key, mapping, formatData);
        }
    }

    private void updateFormatDataMap(AbstractCapellaFormatDataKey key, RepresentationElementMapping mapping, AbstractFormatData formatData) {
        Map formatsMap = this.formatDataMap.computeIfAbsent(key, x -> new TreeMap());
        formatsMap.put(mapping.getName(), formatData);
    }

    protected EObject getSemanticElement(DSemanticDecorator decorator) {
        Entity entity;
        if (decorator == null) {
            return null;
        }
        EObject result = decorator.getTarget();
        if (result == null) {
            return result;
        }
        if (result instanceof Entity && !(entity = (Entity)result).getRepresentingPartitions().isEmpty()) {
            result = (EObject)entity.getRepresentingPartitions().get(0);
        }
        return result;
    }

    public FormatDataKey createKey(DSemanticDecorator semanticDecorator) {
        CapellaDecoratorFormatDataKey result = null;
        EObject realSemanticElement = this.getSemanticElement(semanticDecorator);
        if (realSemanticElement == null) {
            return AbstractCapellaFormatDataKey.INVALID_KEY;
        }
        AbstractCapellaFormatDataKey semanticKey = new AbstractCapellaFormatDataKey(realSemanticElement);
        if (semanticDecorator instanceof DEdge) {
            result = new CapellaEdgeFormatDataKey((DEdge)semanticDecorator, semanticKey);
        } else if (semanticDecorator instanceof AbstractDNode) {
            result = new CapellaNodeFormatDataKey(semanticDecorator, semanticKey);
        } else if (semanticDecorator instanceof DDiagram) {
            result = new CapellaNodeFormatDataKey(semanticDecorator, semanticKey);
        }
        return result;
    }

    public boolean containsData() {
        return !this.formatDataMap.isEmpty();
    }

    public void clearFormatData() {
        this.formatDataMap.clear();
    }

    protected boolean validateKey(AbstractCapellaFormatDataKey key) {
        return key != AbstractCapellaFormatDataKey.INVALID_KEY && key.getSemantic() != null && !key.getSemantic().eIsProxy() && key.getSemantic().eResource() != null;
    }

    protected AbstractFormatData getLinkedFormatData(AbstractCapellaFormatDataKey key, RepresentationElementMapping mapping) {
        AbstractCapellaFormatDataKey parentKey;
        AbstractFormatData formatData = this.findLinkedFormatData(key, mapping);
        if (formatData == null) {
            for (IKeyProvider provider : this.getKeyProviders()) {
                for (FormatDataKey childKey : provider.getKeys(key)) {
                    formatData = this.findLinkedFormatData(childKey, mapping);
                    if (formatData != null) break;
                }
                if (formatData != null) break;
            }
        }
        if (key instanceof CapellaDecoratorFormatDataKey && (parentKey = ((CapellaDecoratorFormatDataKey)key).getParent()) != null) {
            formatData = this.getLinkedFormatData(parentKey, mapping);
        }
        return formatData;
    }

    protected AbstractFormatData findLinkedFormatData(FormatDataKey key, RepresentationElementMapping mapping) {
        if (!this.formatDataMap.containsKey(key)) {
            return null;
        }
        Map<String, AbstractFormatData> mappingFormatDataMap = this.formatDataMap.get(key);
        if (mappingFormatDataMap.containsKey(mapping.getName())) {
            return this.decorateFormatData(key, mappingFormatDataMap.get(mapping.getName()));
        }
        if (!mappingFormatDataMap.entrySet().isEmpty()) {
            return this.decorateFormatData(key, mappingFormatDataMap.entrySet().iterator().next().getValue());
        }
        return null;
    }

    protected AbstractFormatData decorateFormatData(FormatDataKey key, AbstractFormatData formatData) {
        return formatData;
    }
}

