/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.richtext.fields;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaReadOnlyHelper;
import org.polarsys.capella.core.model.handler.provider.IReadOnlySectionHandler;
import org.polarsys.capella.core.ui.properties.helpers.NotificationHelper;
import org.polarsys.capella.core.ui.properties.richtext.RichtextManager;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.common.intf.SaveStrategy;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaBasedRichTextWidget;
import org.polarsys.kitalpha.richtext.widget.helper.MDERichtextWidgetHelper;

public abstract class ElementDescriptionGroup {
    private static final String FAMILY_DEFERRED_REFRESH = "org.polarsys.capella.core.ui.properties.richtext.refreshJobFamily";
    protected EObject semanticElement;
    protected EStructuralFeature semanticFeature;
    private ISection section;
    protected MDERichTextWidget descriptionTextField;
    protected Group descriptionContainer;
    protected GridData existedEditorLayoutData;
    protected Label existedEditorLabel;
    protected Composite parentComposite;
    private static final String EXISTED_EDITOR_TEXT = "The description is currently opened in an editor. Please use this editor to edit your description.";

    public ElementDescriptionGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, ISection section) {
        this.parentComposite = parent;
        this.existedEditorLabel = new Label(parent, 0);
        this.existedEditorLayoutData = new GridData();
        this.existedEditorLabel.setLayoutData((Object)this.existedEditorLayoutData);
        this.existedEditorLabel.setText(EXISTED_EDITOR_TEXT);
        this.descriptionContainer = new Group(parent, 0){

            public boolean setFocus() {
                return true;
            }

            protected void checkSubclass() {
            }
        };
        if (widgetFactory != null) {
            widgetFactory.adapt((Composite)this.descriptionContainer);
        }
        this.descriptionContainer.setLayout((Layout)new GridLayout());
        this.descriptionContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.descriptionTextField = this.createDescriptionField((Composite)this.descriptionContainer);
        this.section = section;
    }

    public void aboutToBeShown() {
        RichtextManager.getInstance().addWidget((Composite)this.descriptionContainer);
        try {
            if (this.semanticElement != null && this.semanticFeature != null) {
                this.descriptionTextField.bind(this.semanticElement, this.semanticFeature);
            }
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    public void aboutToBeHidden() {
        RichtextManager.getInstance().removeWidget((Composite)this.descriptionContainer);
    }

    public void dispose() {
    }

    protected MDERichTextWidget createDescriptionField(Composite parent) {
        MDERichTextWidget widget = RichtextManager.getInstance().getRichtextWidget(parent);
        widget.setSaveStrategy(new SaveStrategy(){

            public void save(final String editorText, final EObject owner, final EStructuralFeature feature) {
                if (NotificationHelper.isNotificationRequired((EObject)owner, (EStructuralFeature)feature, (String)editorText)) {
                    AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                        public void run() {
                            owner.eSet(feature, (Object)editorText);
                        }
                    };
                    ElementDescriptionGroup.this.executeCommand((ICommand)command, owner, feature);
                }
            }
        });
        return widget;
    }

    protected void executeCommand(final ICommand command, final EObject owner, final EStructuralFeature feature) {
        ExecutionManager executionManager;
        if (command == null) {
            return;
        }
        Object cmd = command;
        if (command instanceof AbstractReadWriteCommand) {
            cmd = new AbstractReadWriteCommand(){

                public void run() {
                    command.run();
                }

                public Collection<?> getAffectedObjects() {
                    return Collections.singletonList(owner);
                }

                public String getName() {
                    return "Model Edition";
                }

                public void commandInterrupted() {
                    this.commandRolledBack();
                }

                public void commandRolledBack() {
                    IReadOnlySectionHandler roHandler = CapellaReadOnlyHelper.getReadOnlySectionHandler();
                    if (roHandler != null && roHandler.isLockedByOthers(owner)) {
                        return;
                    }
                    ElementDescriptionGroup.this.loadData(owner, feature);
                }
            };
        }
        if ((executionManager = TransactionHelper.getExecutionManager((EObject)owner)) != null) {
            executionManager.execute(cmd);
        }
    }

    public void setEnabled(boolean enabled) {
        try {
            if (this.descriptionTextField.isReady()) {
                this.descriptionTextField.setEditable(enabled);
            } else {
                this.scheduleDeferredRefresh();
            }
        }
        catch (Exception e) {
            this.scheduleDeferredRefresh();
        }
        this.descriptionContainer.setEnabled(enabled);
    }

    private void scheduleDeferredRefresh() {
        Job[] jobs = Job.getJobManager().find((Object)FAMILY_DEFERRED_REFRESH);
        if (this.section != null && jobs.length == 0) {
            UIJob job = new UIJob("Deferred Section Refresh"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ElementDescriptionGroup.this.section.refresh();
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return ElementDescriptionGroup.FAMILY_DEFERRED_REFRESH.equals(family);
                }
            };
            job.schedule(1000L);
        }
    }

    public void loadData(EObject element, EStructuralFeature feature) {
        try {
            if (element != this.semanticElement) {
                this.semanticElement = element;
                this.semanticFeature = feature;
                if (this.descriptionTextField instanceof MDENebulaBasedRichTextWidget) {
                    ((MDENebulaBasedRichTextWidget)this.descriptionTextField).setDirtyStateUpdated(true);
                }
                this.descriptionTextField.bind(this.semanticElement, this.semanticFeature);
            } else {
                this.descriptionTextField.loadContent();
            }
            this.updateDescriptionEditability();
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    protected void setTextValue(MDERichTextWidget text, EObject object, EStructuralFeature feature) {
        String newTextValue;
        if (text == null || object == null || feature == null) {
            return;
        }
        Object value = object.eGet(feature);
        String currentTextValue = text.getText();
        if (!currentTextValue.equals(newTextValue = (String)(value instanceof String ? value : "")) || "".equals(currentTextValue)) {
            text.setText(newTextValue);
        }
    }

    protected abstract void setDataValue(EObject var1, EStructuralFeature var2, Object var3);

    public void saveDescription(String newDescription) {
        this.setDataValue(this.semanticElement, this.semanticFeature, newDescription);
    }

    public void save(String value) {
        this.saveDescription(value);
    }

    public String getValueToSave() {
        return this.descriptionTextField.getText();
    }

    protected void updateDescriptionEditability() {
        boolean isEditable = MDERichtextWidgetHelper.getActiveMDERichTextEditors((EObject)this.semanticElement).isEmpty();
        this.descriptionContainer.setVisible(isEditable);
        if (isEditable) {
            this.existedEditorLabel.setVisible(false);
            this.existedEditorLayoutData.exclude = true;
        } else {
            this.existedEditorLabel.setVisible(true);
            this.existedEditorLayoutData.exclude = false;
        }
        this.parentComposite.layout(true);
    }

    public boolean shouldRefresh() {
        return this.descriptionTextField == null || !this.descriptionTextField.hasFocus();
    }
}

