/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.report.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.report.model.LogEntry;
import org.polarsys.kitalpha.report.ui.dialogs.ReportHelper;
import org.polarsys.kitalpha.report.ui.views.ReportsView;
import org.polarsys.kitalpha.report.utils.ReportFactory;

public class ReportDialog
extends MessageDialog {
    private LogEntry entry;

    private ReportDialog(Shell parentShell, LogEntry entry, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, JFaceResources.getString((String)"Problem_Occurred"), null, ReportHelper.getSummary(entry), dialogImageType, dialogButtonLabels, defaultIndex);
        this.entry = entry;
    }

    public static void openError(Shell parent, LogEntry entry) {
        ReportDialog.open(1, parent, entry, 0);
    }

    protected Control createCustomArea(Composite parent) {
        Composite bar = new Composite(parent, 0);
        bar.setLayoutData((Object)new GridData(1808));
        bar.setLayout((Layout)new GridLayout(2, false));
        Link link = new Link(bar, 0);
        link.setText("<a>Show details in report view</a>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ReportsView view = (ReportsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.kitalpha.report.ui.views.reportsview");
                    view.selectAndReveal(ReportDialog.this.entry);
                }
                catch (PartInitException e1) {
                    ReportFactory.INSTANCE.logError((Throwable)e1);
                }
                ReportDialog.this.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        bar.setFocus();
        return bar;
    }

    public static boolean open(int kind, Shell parent, LogEntry entry, int style) {
        ReportDialog dialog = new ReportDialog(parent, entry, kind, ReportDialog.getButtonLabels(kind), 0);
        int newStyle = style & 0x10000000;
        dialog.setShellStyle(dialog.getShellStyle() | newStyle);
        return dialog.open() == 0;
    }

    static String[] getButtonLabels(int kind) {
        String[] dialogButtonLabels;
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                dialogButtonLabels = new String[]{IDialogConstants.OK_LABEL};
                break;
            }
            case 5: {
                dialogButtonLabels = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
                break;
            }
            case 3: {
                dialogButtonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                break;
            }
            case 6: {
                dialogButtonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
            }
        }
        return dialogButtonLabels;
    }
}

