/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.explorer.activity.ui.hyperlinkadapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.Block;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.ConfigurationItemKind;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsFactory;
import org.polarsys.capella.core.data.helpers.ctx.services.ActorPkgExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalActorPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ModelQueryHelper;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.ui.toolkit.helpers.SelectionDialogHelper;

public class ModelCreationHelper {
    protected static Scenario createScenario(AbstractCapability abstractCapability, ScenarioKind scenarioKind) {
        if (abstractCapability != null) {
            Scenario sc = InteractionFactory.eINSTANCE.createScenario("Scenario");
            sc.setKind(scenarioKind);
            abstractCapability.getOwnedScenarios().add((Object)sc);
            return sc;
        }
        return null;
    }

    protected static void createStateMachineRegion(Block block, String stateMachineName) {
        StateMachine defaultSM = null;
        Iterator iterator = block.getOwnedStateMachines().iterator();
        if (iterator.hasNext()) {
            StateMachine sm;
            defaultSM = sm = (StateMachine)iterator.next();
        }
        if (defaultSM == null) {
            defaultSM = CapellacommonFactory.eINSTANCE.createStateMachine(stateMachineName);
            block.getOwnedStateMachines().add((Object)defaultSM);
        }
        Region defaultRegion = null;
        Iterator iterator2 = defaultSM.getOwnedRegions().iterator();
        while (iterator2.hasNext()) {
            Region region;
            defaultRegion = region = (Region)iterator2.next();
        }
        if (defaultRegion == null) {
            defaultRegion = CapellacommonFactory.eINSTANCE.createRegion("Default Region");
            defaultSM.getOwnedRegions().add((Object)defaultRegion);
        }
    }

    protected static AbstractCapability selectCapability(Project project, ComponentArchitecture architecture) {
        AbstractCapability result = null;
        AbstractCapabilityPkg capabilityPkg = ModelQueryHelper.getCapabilityPkgFrom((Project)project, (ComponentArchitecture)architecture);
        if (capabilityPkg != null) {
            Set all;
            EClass clazz = CtxPackage.Literals.CAPABILITY;
            if (capabilityPkg instanceof CapabilityRealizationPkg) {
                clazz = LaPackage.Literals.CAPABILITY_REALIZATION;
            }
            if (!(all = EObjectExt.getAll((EObject)capabilityPkg, (EClass)clazz)).isEmpty()) {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                result = (AbstractCapability)SelectionDialogHelper.simplePropertySelectionDialogWizard(new ArrayList(all), (Shell)shell);
                return result;
            }
            result = ModelCreationHelper.createAbstractCapability(capabilityPkg);
        }
        return result;
    }

    public static AbstractCapability createAbstractCapability(AbstractCapabilityPkg capabilityPkg) {
        Capability result = null;
        if (capabilityPkg instanceof CapabilityPkg) {
            result = CtxFactory.eINSTANCE.createCapability("Capability");
            ((CapabilityPkg)capabilityPkg).getOwnedCapabilities().add((Object)result);
        } else if (capabilityPkg instanceof CapabilityRealizationPkg) {
            result = LaFactory.eINSTANCE.createCapabilityRealization("Capability");
            ((CapabilityRealizationPkg)capabilityPkg).getOwnedCapabilityRealizations().add((Object)((CapabilityRealization)result));
        }
        return result;
    }

    public static Scenario selectCapabilityAndCreateScenario(final Project project, final ComponentArchitecture architecture, final ScenarioKind scenarioKind) {
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){
            private Scenario scenario;

            public Collection<?> getAffectedObjects() {
                return Collections.singletonList(this.scenario);
            }

            public void run() {
                AbstractCapability capability = ModelCreationHelper.selectCapability(project, architecture);
                if (capability != null) {
                    this.scenario = ModelCreationHelper.createScenario(capability, scenarioKind);
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        return (Scenario)cmd.getAffectedObjects().iterator().next();
    }

    protected static CapabilityRealization selectCapabilityRealization(CapabilityRealizationPkg capabilityRealizationPkg) {
        if (capabilityRealizationPkg != null) {
            Set all = EObjectExt.getAll((EObject)capabilityRealizationPkg, (EClass)LaPackage.Literals.CAPABILITY_REALIZATION);
            if (!all.isEmpty()) {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                return (CapabilityRealization)SelectionDialogHelper.simplePropertySelectionDialogWizard(new ArrayList(all), (Shell)shell);
            }
            CapabilityRealization capabilityRealization = LaFactory.eINSTANCE.createCapabilityRealization("Capability Realization");
            capabilityRealizationPkg.getOwnedCapabilityRealizations().add((Object)capabilityRealization);
            return capabilityRealization;
        }
        return null;
    }

    protected static CapabilityRealization selectLACapabilityRealization(Project project) {
        CapabilityRealizationPkg capabilityRealizationPkg = ModelQueryHelper.getLACapabilityRealizationPkg((Project)project);
        if (capabilityRealizationPkg != null) {
            return ModelCreationHelper.selectCapabilityRealization(capabilityRealizationPkg);
        }
        return null;
    }

    public static Scenario selectLACapabilityRealizationAndCreateDataFlowScenario(final Project project) {
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){
            private Scenario scenario;

            public Collection<?> getAffectedObjects() {
                return Collections.singletonList(this.scenario);
            }

            public void run() {
                CapabilityRealization capabilityRealization = ModelCreationHelper.selectLACapabilityRealization(project);
                if (capabilityRealization != null) {
                    this.scenario = ModelCreationHelper.createScenario((AbstractCapability)capabilityRealization, ScenarioKind.DATA_FLOW);
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        return (Scenario)cmd.getAffectedObjects().iterator().next();
    }

    protected static OperationalCapability selectOperationalCapability(Project project) {
        OperationalCapabilityPkg operationalCapabilityPkg = ModelQueryHelper.getOperationalCapabilityPkg((Project)project);
        if (operationalCapabilityPkg != null) {
            Set all = EObjectExt.getAll((EObject)operationalCapabilityPkg, (EClass)OaPackage.Literals.OPERATIONAL_CAPABILITY);
            if (!all.isEmpty()) {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                return (OperationalCapability)SelectionDialogHelper.simplePropertySelectionDialogWizard(new ArrayList(all), (Shell)shell);
            }
            OperationalCapability operationalCapability = OaFactory.eINSTANCE.createOperationalCapability("Operational Capability");
            operationalCapabilityPkg.getOwnedOperationalCapabilities().add((Object)operationalCapability);
            return operationalCapability;
        }
        return null;
    }

    public static Scenario selectOperationalCapabilityAndCreateInteractionScenario(final Project project) {
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){
            private Scenario scenario;

            public Collection<?> getAffectedObjects() {
                return Collections.singletonList(this.scenario);
            }

            public void run() {
                OperationalCapability operationalCapability = ModelCreationHelper.selectOperationalCapability(project);
                if (operationalCapability != null) {
                    this.scenario = ModelCreationHelper.createScenario((AbstractCapability)operationalCapability, ScenarioKind.INTERACTION);
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        return (Scenario)cmd.getAffectedObjects().iterator().next();
    }

    protected static Entity selectOperationalEntity(Project project) {
        EntityPkg operationalEntityPkg = ModelQueryHelper.getOperationalEntityPkg((Project)project);
        if (operationalEntityPkg == null) {
            return null;
        }
        Set existingOperationalEntities = EObjectExt.getAll((EObject)operationalEntityPkg, (EClass)OaPackage.Literals.ENTITY);
        if (!existingOperationalEntities.isEmpty()) {
            return (Entity)SelectionDialogHelper.simplePropertySelectionDialogWizard(new ArrayList(existingOperationalEntities), (Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell());
        }
        Entity operationalEntity = OaFactory.eINSTANCE.createEntity("Operational Entity");
        operationalEntityPkg.getOwnedEntities().add((Object)operationalEntity);
        return operationalEntity;
    }

    public static Region selectOperationalEntityAndCreateStateMachineRegion(final Project project) {
        final Entity[] operationalEntity = new Entity[1];
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                operationalEntity[0] = ModelCreationHelper.selectOperationalEntity(project);
                if (operationalEntity[0] != null) {
                    ModelCreationHelper.createStateMachineRegion((Block)operationalEntity[0], "Operational Entity State Machine");
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        return operationalEntity[0] != null ? ModelQueryHelper.getStateMachineRegion((Block)operationalEntity[0]) : null;
    }

    protected static CapabilityRealization selectPACapabilityRealization(Project project) {
        CapabilityRealizationPkg capabilityRealizationPkg = ModelQueryHelper.getPACapabilityRealizationPkg((Project)project);
        if (capabilityRealizationPkg != null) {
            return ModelCreationHelper.selectCapabilityRealization(capabilityRealizationPkg);
        }
        return null;
    }

    public static Scenario selectPACapabilityRealizationAndCreateDataFlowScenario(final Project project) {
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){
            private Scenario scenario;

            public Collection<?> getAffectedObjects() {
                return Collections.singletonList(this.scenario);
            }

            public void run() {
                CapabilityRealization capabilityRealization = ModelCreationHelper.selectPACapabilityRealization(project);
                if (capabilityRealization != null) {
                    this.scenario = ModelCreationHelper.createScenario((AbstractCapability)capabilityRealization, ScenarioKind.DATA_FLOW);
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        return (Scenario)cmd.getAffectedObjects().iterator().next();
    }

    public static Region selectComponentAtSALevelAndCreateStateMachineRegion(final Project project) {
        final Component[] components = new Component[1];
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                components[0] = ModelCreationHelper.selectComponentAtSaLevel(project);
                if (components[0] != null) {
                    ModelCreationHelper.createStateMachineRegion((Block)components[0], "System State Machine");
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        return components[0] != null ? ModelQueryHelper.getStateMachineRegion((Block)components[0]) : null;
    }

    public static Region selectComponentAtLALevelAndCreateStateMachineRegion(final Project project) {
        final Component[] components = new Component[1];
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                components[0] = ModelCreationHelper.selectComponentAtLaLevel(project);
                if (components[0] != null) {
                    ModelCreationHelper.createStateMachineRegion((Block)components[0], "Logical Component State Machine");
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        return components[0] != null ? ModelQueryHelper.getStateMachineRegion((Block)components[0]) : null;
    }

    public static Region selectComponentAtPALevelAndCreateStateMachineRegion(final Project project) {
        final Component[] components = new Component[1];
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                components[0] = ModelCreationHelper.selectComponentAtPaLevel(project);
                if (components[0] != null) {
                    ModelCreationHelper.createStateMachineRegion((Block)components[0], "Physical Component State Machine");
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        return components[0] != null ? ModelQueryHelper.getStateMachineRegion((Block)components[0]) : null;
    }

    public static Region selectComponentAtAPBSLevelAndCreateStateMachineRegion(final Project project) {
        final Component[] components = new Component[1];
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                components[0] = ModelCreationHelper.selectComponentAtEPBSLevel(project);
                if (components[0] != null) {
                    ModelCreationHelper.createStateMachineRegion((Block)components[0], "Configuration Item State Machine");
                }
            }
        };
        TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        return components[0] != null ? ModelQueryHelper.getStateMachineRegion((Block)components[0]) : null;
    }

    protected static Component selectComponentAtSaLevel(Project project) {
        List allActors;
        SystemEngineering systemEngineering;
        ArrayList<System> components = new ArrayList<System>(0);
        System system = ModelQueryHelper.getSystem((Project)project);
        if (system != null) {
            components.add(system);
        }
        if ((systemEngineering = ModelQueryHelper.getSystemEngineering((Project)project)) != null && (allActors = SystemEngineeringExt.getAllActors((CapellaElement)systemEngineering)) != null && !allActors.isEmpty()) {
            components.addAll(allActors);
        }
        if (!components.isEmpty()) {
            return (Component)SelectionDialogHelper.simplePropertySelectionDialogWizard(new ArrayList(components), (Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell());
        }
        System newSystem = CtxFactory.eINSTANCE.createSystem("System");
        SystemAnalysis systemAnalysis = ModelQueryHelper.getSystemAnalysis((Project)project);
        if (systemAnalysis != null) {
            systemAnalysis.setOwnedSystem(newSystem);
            return newSystem;
        }
        return null;
    }

    protected static Component selectComponentAtLaLevel(Project project) {
        ArrayList components = new ArrayList(0);
        SystemEngineering systemEngineering = ModelQueryHelper.getSystemEngineering((Project)project);
        if (systemEngineering != null) {
            List allLAsFromLAPkg;
            LogicalActorPkg logicalActorPkg;
            List allLogicalComponents = SystemEngineeringExt.getAllLogicalComponents((CapellaElement)systemEngineering);
            if (allLogicalComponents != null && !allLogicalComponents.isEmpty()) {
                components.addAll(allLogicalComponents);
            }
            if ((logicalActorPkg = ModelQueryHelper.getLogicalActorPkg((Project)project)) != null && (allLAsFromLAPkg = ActorPkgExt.getAllActors((LogicalActorPkg)logicalActorPkg)) != null && !allLAsFromLAPkg.isEmpty()) {
                components.addAll(allLAsFromLAPkg);
            }
        }
        if (!components.isEmpty()) {
            return (Component)SelectionDialogHelper.simplePropertySelectionDialogWizard(new ArrayList(components), (Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell());
        }
        LogicalComponent newLC = LaFactory.eINSTANCE.createLogicalComponent("Logical System");
        LogicalArchitecture logicalArchitecute = ModelQueryHelper.getLogicalArchitecture((Project)project);
        if (logicalArchitecute != null) {
            logicalArchitecute.setOwnedLogicalComponent(newLC);
            return newLC;
        }
        return null;
    }

    protected static Component selectComponentAtPaLevel(Project project) {
        ArrayList components = new ArrayList(0);
        SystemEngineering systemEngineering = ModelQueryHelper.getSystemEngineering((Project)project);
        if (systemEngineering != null) {
            List allPhysicalActors;
            List allPhysicalComponents = SystemEngineeringExt.getAllPhysicalComponents((CapellaElement)systemEngineering);
            if (allPhysicalComponents != null && !allPhysicalComponents.isEmpty()) {
                components.addAll(allPhysicalComponents);
            }
            if ((allPhysicalActors = SystemEngineeringExt.getAllPhysicalActors((CapellaElement)systemEngineering)) != null && !allPhysicalActors.isEmpty()) {
                components.addAll(allPhysicalActors);
            }
        }
        if (!components.isEmpty()) {
            return (Component)SelectionDialogHelper.simplePropertySelectionDialogWizard(new ArrayList(components), (Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell());
        }
        PhysicalComponent newPC = PaFactory.eINSTANCE.createPhysicalComponent("Physical System");
        PhysicalArchitecture physicalArchitecute = ModelQueryHelper.getPhysicalArchitecture((Project)project);
        if (physicalArchitecute != null) {
            physicalArchitecute.setOwnedPhysicalComponent(newPC);
            return newPC;
        }
        return null;
    }

    protected static Component selectComponentAtEPBSLevel(Project project) {
        List allConfigurationItems;
        ArrayList components = new ArrayList(0);
        SystemEngineering systemEngineering = ModelQueryHelper.getSystemEngineering((Project)project);
        if (systemEngineering != null && (allConfigurationItems = SystemEngineeringExt.getAllConfigurationItems((CapellaElement)systemEngineering)) != null && !allConfigurationItems.isEmpty()) {
            components.addAll(allConfigurationItems);
        }
        if (!components.isEmpty()) {
            return (Component)SelectionDialogHelper.simplePropertySelectionDialogWizard(new ArrayList(components), (Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell());
        }
        ConfigurationItem newCI = EpbsFactory.eINSTANCE.createConfigurationItem("SystemCI");
        newCI.setKind(ConfigurationItemKind.SYSTEM_CI);
        EPBSArchitecture epbsArchitecute = ModelQueryHelper.getEPBSArchitecture((Project)project);
        if (epbsArchitecute != null) {
            epbsArchitecute.setOwnedConfigurationItem(newCI);
            return newCI;
        }
        return null;
    }
}

